/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.graph;

import de.elpro.ewms.core.fx.graph.GraphChartView;
import de.elpro.ewms.core.fx.graph.ObjectInputValuePrefsDialog;
import de.elpro.ewms.core.graph.ObjectInputValue;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.units.DisplayUnitFormat;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ui.formats.NumberFormats;
import de.elpro.ui.fx.controls.NumericField;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.Window;

class ObjectInputValueView
extends HBox {
    private final ObjectInputValue objectInputValue;
    private final Label label = new Label();
    private final NumericField editor = new NumericField(Double.class, NumberFormats.F0_000);
    private GraphChartView.InputValueChangedCallback inputValueChangedCallback;

    public ObjectInputValueView(ObjectInputValue objectInputValue) {
        super(5.0);
        this.getStyleClass().add((Object)"object-value");
        this.objectInputValue = objectInputValue;
        this.editor.setSuffixOrientation(NumericField.SuffixOrientation.Right);
        this.editor.setMinWidth(60.0);
        this.editor.setPrefWidth(60.0);
        this.editor.valueProperty().addListener((o, ov, nv) -> {
            if (this.inputValueChangedCallback != null && nv != null) {
                double value = nv.doubleValue();
                if (objectInputValue.getMeasuringUnit() != null) {
                    value = objectInputValue.getVariable().getMeasuringUnit().convert(value, objectInputValue.getMeasuringUnit());
                }
                this.inputValueChangedCallback.onEdit(this.objectInputValue, value);
            }
        });
        this.setAlignment(Pos.CENTER_LEFT);
        HBox.setHgrow((Node)this.editor, (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{this.label, this.editor});
        this.updateInputValueView();
    }

    public void updateValue(IVarValue value) {
        String labelText;
        Variable var = this.objectInputValue.getVariable();
        MeasuringUnit unit = this.objectInputValue.getMeasuringUnit() != null ? this.objectInputValue.getMeasuringUnit() : var.getMeasuringUnit();
        String string = labelText = this.objectInputValue.isHidePhysicalUnit() ? null : var.getPhysicalUnit().getName();
        if (this.objectInputValue.getSuffix() != null && !this.objectInputValue.getSuffix().isEmpty()) {
            labelText = labelText == null ? this.objectInputValue.getSuffix() : String.format("%s_%s", labelText, this.objectInputValue.getSuffix());
        }
        this.label.setText(labelText);
        if (Double.isFinite(value.getValue())) {
            this.editor.setValue((Number)unit.convert(value.getValue(), var.getMeasuringUnit()));
        } else {
            this.editor.setValue(null);
        }
    }

    void setInputValueChangedCallback(GraphChartView.InputValueChangedCallback inputValueChangedCallback) {
        this.inputValueChangedCallback = inputValueChangedCallback;
    }

    public static boolean edit(Window window, StructureClass structureClass, ObjectInputValue objectInputValue) {
        ObjectInputValuePrefsDialog dlg = new ObjectInputValuePrefsDialog(window, structureClass, objectInputValue);
        ButtonType btn = (ButtonType)dlg.showAndWait().get();
        if (btn.equals(ButtonType.OK)) {
            objectInputValue.setHidePhysicalUnit(dlg.isHidePhysicalUnit());
            objectInputValue.setSuffix(dlg.getSuffix());
            objectInputValue.setVariable(dlg.getVariable());
            objectInputValue.setMeasuringUnit(dlg.getMeasuringUnit());
            objectInputValue.setFormat(dlg.getFormat());
            return true;
        }
        return false;
    }

    public ObjectInputValue getObjectInputValue() {
        return this.objectInputValue;
    }

    void updateInputValueView() {
        String labelText = null;
        if (!this.objectInputValue.isHidePhysicalUnit() && this.objectInputValue.getVariable() != null) {
            labelText = this.objectInputValue.getVariable().getPhysicalUnit().getName();
        }
        if (this.objectInputValue.getSuffix() != null && !this.objectInputValue.getSuffix().isEmpty()) {
            labelText = labelText == null ? this.objectInputValue.getSuffix() : " " + this.objectInputValue.getSuffix();
        }
        this.label.setText(labelText);
        MeasuringUnit unit = this.objectInputValue.getMeasuringUnit() != null ? this.objectInputValue.getMeasuringUnit() : this.objectInputValue.getVariable().getMeasuringUnit();
        String unitText = unit != null ? String.format("[%s]", unit.getDisplayUnitText(DisplayUnitFormat.SIMPLE)) : null;
        this.editor.setSuffixText(unitText);
        if (this.objectInputValue.getFormat() != null) {
            this.editor.setFormat(this.objectInputValue.getFormat().getDefaultDecimalFormat());
        }
    }
}

