/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.graph;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.graph.ObjectValue;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.MeasuringUnitFormat;
import de.elpro.ewms.core.units.MeasuringUnitFormats;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ui.controlsfx.propertysheet.SeparatorItem;
import de.elpro.ui.fx.propertysheet.BooleanPropertyItem;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.stage.Modality;
import javafx.stage.Window;
import org.controlsfx.control.PropertySheet;

class ObjectValuePrefsDialog
extends Dialog<ButtonType> {
    private final SimpleBooleanProperty hidePU = new SimpleBooleanProperty();
    private final SimpleStringProperty suffix = new SimpleStringProperty();
    private final SimpleObjectProperty<Variable> variable = new SimpleObjectProperty();
    private final SimpleObjectProperty<MeasuringUnit> unit = new SimpleObjectProperty();
    private final SimpleObjectProperty<MeasuringUnitFormat> format = new SimpleObjectProperty();
    private final SimpleObjectProperty<Variable> realtimeVariable = new SimpleObjectProperty();
    private final SimpleObjectProperty<MeasuringUnit> realtimeUnit = new SimpleObjectProperty();
    private final SimpleObjectProperty<MeasuringUnitFormat> realtimeFormat = new SimpleObjectProperty();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);

    public ObjectValuePrefsDialog(Window window, StructureClass structureClass, ObjectValue objectValue) {
        List<Variable> variables;
        this.initModality(Modality.WINDOW_MODAL);
        this.initOwner(window);
        Transaction trx = Transactions.begin();
        try {
            if (objectValue.getVariable() != null) {
                objectValue.setVariable(VariableDAO.get((Transaction)trx, (int)objectValue.getVariable().getId()));
            }
            if (objectValue.getRealtimeVariable() != null) {
                objectValue.setRealtimeVariable(VariableDAO.get((Transaction)trx, (int)objectValue.getRealtimeVariable().getId()));
            }
            variables = Arrays.asList(StructureClassDAO.getAllVariables((Transaction)trx, (int)structureClass.getId()));
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.hidePU.set(objectValue.isHidePhysicalUnit());
        this.suffix.set(objectValue.getSuffix());
        this.variable.set((Object)objectValue.getVariable());
        this.unit.set((Object)objectValue.getMeasuringUnit());
        this.format.set((Object)objectValue.getFormat());
        this.realtimeVariable.set((Object)objectValue.getRealtimeVariable());
        this.realtimeUnit.set((Object)objectValue.getRealtimeMeasuringUnit());
        this.realtimeFormat.set((Object)objectValue.getRealtimeFormat());
        PropertySheet sheet = new PropertySheet();
        BooleanPropertyItem hideMUItem = new BooleanPropertyItem("Hide Physical Unit", (ReadOnlyProperty)this.hidePU);
        StringPropertyItem suffixItem = new StringPropertyItem("Suffix", (ObservableValue)this.suffix);
        ChoicePropertyItem variableItem = new ChoicePropertyItem("Range\tVariable", this.variable, variables);
        variableItem.setNullable(false);
        variableItem.setValidator(Validators.createNotEmptyValidator((String)"Variable cannot be empty"));
        ChoicePropertyItem unitItem = new ChoicePropertyItem("\t\tUnit", this.unit, this.getUnits(this.getVariable()));
        if (this.getVariable() != null) {
            unitItem.setPromptText(String.format("Default: %s", this.getVariable().getMeasuringUnit()));
        }
        ChoicePropertyItem formatItem = new ChoicePropertyItem("\t\tFormat", this.format, MeasuringUnitFormats.getFormats());
        ChoicePropertyItem realtimeVariableItem = new ChoicePropertyItem("Realtime\tVariable", this.realtimeVariable, variables);
        if (this.getVariable() != null) {
            realtimeVariableItem.setPromptText(String.format("Default: %s", this.getVariable()));
        }
        ChoicePropertyItem realtimeUnitItem = new ChoicePropertyItem("\t\tUnit", this.realtimeUnit, this.getUnits(this.getRealtimeVariable()));
        ChoicePropertyItem realtimeFormatItem = new ChoicePropertyItem("\t\tFormat", this.realtimeFormat, MeasuringUnitFormats.getFormats());
        variableItem.valueProperty().addListener(il -> {
            unitItem.setChoices(this.getUnits(this.getVariable()));
            if (this.getVariable() != null) {
                unitItem.setPromptText(String.format("Default: %s", this.getVariable().getMeasuringUnit()));
                realtimeVariableItem.setPromptText(String.format("Default: %s", this.getVariable()));
            } else {
                unitItem.setPromptText(null);
                realtimeVariableItem.setPromptText(null);
            }
        });
        realtimeVariableItem.valueProperty().addListener(il -> {
            realtimeUnitItem.setChoices(this.getUnits(this.getRealtimeVariable()));
            if (this.getRealtimeVariable() != null) {
                realtimeUnitItem.setPromptText(String.format("Default: %s", this.getRealtimeVariable().getMeasuringUnit()));
            } else {
                realtimeUnitItem.setPromptText(null);
            }
        });
        sheet.getItems().addAll((Object[])new PropertySheet.Item[]{hideMUItem, suffixItem, new SeparatorItem(), variableItem, unitItem, formatItem, new SeparatorItem(), realtimeVariableItem, realtimeUnitItem, realtimeFormatItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)sheet.getItems()));
        this.getDialogPane().setPrefWidth(400.0);
        this.getDialogPane().setPrefHeight(400.0);
        this.getDialogPane().setContent((Node)sheet);
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL, ButtonType.OK});
        this.getDialogPane().lookupButton(ButtonType.OK).disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)this.hasChanges));
    }

    private Collection<MeasuringUnit> getUnits(Variable var) {
        return var != null ? var.getPhysicalUnit().getMeasuringUnits() : Collections.emptyList();
    }

    public boolean isHidePhysicalUnit() {
        return this.hidePU.get();
    }

    public String getSuffix() {
        return this.suffix.get();
    }

    public Variable getVariable() {
        return (Variable)this.variable.get();
    }

    public MeasuringUnit getMeasuringUnit() {
        return (MeasuringUnit)this.unit.get();
    }

    public MeasuringUnitFormat getFormat() {
        return (MeasuringUnitFormat)this.format.get();
    }

    public Variable getRealtimeVariable() {
        return (Variable)this.realtimeVariable.get();
    }

    public MeasuringUnit getRealtimeMeasuringUnit() {
        return (MeasuringUnit)this.realtimeUnit.get();
    }

    public MeasuringUnitFormat getRealtimeFormat() {
        return (MeasuringUnitFormat)this.realtimeFormat.get();
    }
}

