/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.graph;

import de.elpro.ewms.core.fx.graph.ObjectValuePrefsDialog;
import de.elpro.ewms.core.graph.ObjectValue;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.units.DisplayUnitFormat;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.MeasuringUnitFormat;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.value.IVarValue;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.Window;

class ObjectValueView
extends HBox {
    private final ObjectValue objectValue;
    private final Label label = new Label();
    private final Label value = new Label();
    private final Label unit = new Label();
    private final List<String> defaultStyleClasses;

    public ObjectValueView(ObjectValue objectValue) {
        super(5.0);
        this.getStyleClass().add((Object)"object-value");
        this.objectValue = objectValue;
        this.defaultStyleClasses = Collections.unmodifiableList(this.getStyleClass());
        this.setAlignment(Pos.CENTER_LEFT);
        HBox valueContainer = new HBox(new Node[]{this.value});
        valueContainer.setAlignment(Pos.CENTER_RIGHT);
        HBox.setHgrow((Node)valueContainer, (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{this.label, valueContainer, this.unit});
        this.updateValueView();
    }

    public void updateValue(IVarValue value, boolean realtime) {
        String styleClass;
        String labelText;
        Variable var = this.getObjectValue().getVariable();
        MeasuringUnit unit = this.getObjectValue().getMeasuringUnit() != null ? this.getObjectValue().getMeasuringUnit() : var.getMeasuringUnit();
        MeasuringUnitFormat format = this.getObjectValue().getFormat();
        if (realtime && this.getObjectValue().getRealtimeVariable() != null) {
            var = this.getObjectValue().getRealtimeVariable();
            MeasuringUnit measuringUnit = unit = this.getObjectValue().getRealtimeMeasuringUnit() != null ? this.getObjectValue().getRealtimeMeasuringUnit() : var.getMeasuringUnit();
            if (this.getObjectValue().getRealtimeFormat() != null) {
                format = this.getObjectValue().getRealtimeFormat();
            }
        }
        String string = labelText = this.getObjectValue().isHidePhysicalUnit() ? null : var.getPhysicalUnit().getName();
        if (this.getObjectValue().getSuffix() != null && !this.getObjectValue().getSuffix().isEmpty()) {
            labelText = labelText == null ? this.getObjectValue().getSuffix() : String.format("%s_%s", labelText, this.getObjectValue().getSuffix());
        }
        this.label.setText(labelText);
        if (Double.isFinite(value.getValue())) {
            styleClass = value.isValid() ? "valid-value" : "invalid-value";
            this.value.setText(unit.formatValue(value.getValue(), var.getMeasuringUnit(), format, false));
        } else {
            styleClass = "nan-value";
            this.value.setText(null);
        }
        HashSet<String> classes = new HashSet<String>(this.defaultStyleClasses);
        classes.add(styleClass);
        this.getStyleClass().setAll(classes);
        String unitText = unit != null ? String.format("[%s]", unit.getDisplayUnitText(DisplayUnitFormat.SIMPLE)) : null;
        this.unit.setText(unitText);
    }

    public static boolean edit(Window window, StructureClass structureClass, ObjectValue objectValue) {
        ObjectValuePrefsDialog dlg = new ObjectValuePrefsDialog(window, structureClass, objectValue);
        ButtonType btn = (ButtonType)dlg.showAndWait().get();
        if (btn.equals(ButtonType.OK)) {
            objectValue.setHidePhysicalUnit(dlg.isHidePhysicalUnit());
            objectValue.setSuffix(dlg.getSuffix());
            objectValue.setVariable(dlg.getVariable());
            objectValue.setMeasuringUnit(dlg.getMeasuringUnit());
            objectValue.setFormat(dlg.getFormat());
            objectValue.setRealtimeVariable(dlg.getRealtimeVariable());
            objectValue.setRealtimeMeasuringUnit(dlg.getRealtimeMeasuringUnit());
            objectValue.setRealtimeFormat(dlg.getRealtimeFormat());
            return true;
        }
        return false;
    }

    public ObjectValue getObjectValue() {
        return this.objectValue;
    }

    void updateValueView() {
        String labelText = null;
        if (!this.getObjectValue().isHidePhysicalUnit() && this.getObjectValue().getVariable() != null) {
            labelText = this.getObjectValue().getVariable().getPhysicalUnit().getName();
        }
        if (this.getObjectValue().getSuffix() != null && !this.getObjectValue().getSuffix().isEmpty()) {
            labelText = labelText == null ? this.getObjectValue().getSuffix() : " " + this.getObjectValue().getSuffix();
        }
        this.label.setText(labelText);
        MeasuringUnit unit = this.objectValue.getMeasuringUnit();
        String unitText = unit != null ? String.format("[%s]", unit.getDisplayUnitText(DisplayUnitFormat.SIMPLE)) : null;
        this.unit.setText(unitText);
    }
}

