/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.graph;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.graph.ObjectValues;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ui.fx.propertysheet.BooleanPropertyItem;
import de.elpro.ui.fx.propertysheet.ChoicePropertyItem;
import de.elpro.ui.fx.propertysheet.DoublePropertyItem;
import de.elpro.ui.fx.propertysheet.EnumPropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.PaintPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.validator.Validators;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.stage.Modality;
import javafx.stage.Window;
import org.controlsfx.control.PropertySheet;

class ObjectValuesPrefsDialog
extends Dialog<ButtonType> {
    private final ObjectValues copy;
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);

    public ObjectValuesPrefsDialog(Window window, ObjectValues objectValues) {
        ChoicePropertyItem classItem;
        this.initModality(Modality.WINDOW_MODAL);
        this.initOwner(window);
        this.copy = objectValues.copy();
        Transaction trx = Transactions.begin();
        try {
            if (objectValues.getStructureObject() != null) {
                this.copy.setStructureObject(StructureObjectDAO.get((Transaction)trx, (int)objectValues.getStructureObject().getId()));
                if (this.copy.getStructureClass() == null) {
                    this.copy.setStructureClass(StructureClassDAO.get((Transaction)trx, (int)this.copy.getStructureObject().getStructureClass().getId()));
                } else {
                    this.copy.setStructureClass(StructureClassDAO.get((Transaction)trx, (int)this.copy.getStructureClass().getId()));
                }
            }
            classItem = new ChoicePropertyItem("Class", (ObservableValue)this.copy.structureClassProperty(), Arrays.asList(StructureClassDAO.getAll((Transaction)trx)));
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        PropertySheet sheet = new PropertySheet();
        classItem.setValidator(Validators.createNotEmptyValidator((String)"Class must be not empty"));
        classItem.setNullable(false);
        EnumPropertyItem searchPolicyItem = new EnumPropertyItem("Object Search Policy", SearchPolicy.class, (ObservableValue)this.copy.structureObjectSearchPolicyProperty());
        searchPolicyItem.setNullable(false);
        searchPolicyItem.setValidator(Validators.createNotEmptyValidator());
        ChoicePropertyItem objectItem = new ChoicePropertyItem("Object", (ObservableValue)this.copy.structureObjectProperty(), this.getObjectChoices());
        LocaleStringPropertyItem labelItem = new LocaleStringPropertyItem("Label", (ObservableValue)this.copy.labelProperty());
        BooleanPropertyItem hideLabelItem = new BooleanPropertyItem("Hide Label", (ReadOnlyProperty)this.copy.hideLabelProperty());
        PaintPropertyItem backgroundColorItem = new PaintPropertyItem("Background", (ObservableValue)this.copy.backgroundColorProperty());
        PaintPropertyItem borderColorItem = new PaintPropertyItem("Border", (ObservableValue)this.copy.borderColorProperty());
        DoublePropertyItem widthItem = new DoublePropertyItem("Width", (ObservableValue)this.copy.contentWidthProperty());
        DoublePropertyItem heightItem = new DoublePropertyItem("Height", (ObservableValue)this.copy.contentHeightProperty());
        DoublePropertyItem xItem = new DoublePropertyItem("Layout X", (ObservableValue)this.copy.contentLayoutXProperty());
        DoublePropertyItem yItem = new DoublePropertyItem("Layout Y", (ObservableValue)this.copy.contentLayoutYProperty());
        classItem.valueProperty().addListener(il -> objectItem.setChoices(this.getObjectChoices()));
        sheet.getItems().addAll((Object[])new PropertySheet.Item[]{classItem, searchPolicyItem, objectItem, labelItem, hideLabelItem, backgroundColorItem, borderColorItem, widthItem, heightItem, xItem, yItem});
        this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)sheet.getItems()));
        this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)sheet.getItems()));
        this.getDialogPane().setPrefWidth(500.0);
        this.getDialogPane().setPrefHeight(500.0);
        this.getDialogPane().setContent((Node)sheet);
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL, ButtonType.OK});
        this.getDialogPane().lookupButton(ButtonType.OK).disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)this.hasChanges));
    }

    private Collection<StructureObject> getObjectChoices() {
        Transaction trx = Transactions.begin();
        try {
            if (this.copy.getStructureClass() != null) {
                Collection collection = StructureClassDAO.getAllObjects((StructureClass)this.copy.getStructureClass());
                return collection;
            }
            List<StructureObject> list = Collections.emptyList();
            return list;
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    public ObjectValues getObjectValues() {
        return this.copy;
    }
}

