/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.graph;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.fx.graph.GraphChartView;
import de.elpro.ewms.core.fx.graph.ObjectGroupView;
import de.elpro.ewms.core.fx.graph.ObjectInputValueView;
import de.elpro.ewms.core.fx.graph.ObjectValueView;
import de.elpro.ewms.core.fx.graph.ObjectValuesPrefsDialog;
import de.elpro.ewms.core.fx.graph.ResizableContentView;
import de.elpro.ewms.core.graph.ObjectInputValue;
import de.elpro.ewms.core.graph.ObjectValue;
import de.elpro.ewms.core.graph.ObjectValues;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ui.fx.utils.FXUtils;
import java.util.Iterator;
import javafx.beans.InvalidationListener;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Window;

class ObjectValuesView
extends VBox
implements ResizableContentView {
    public static final Background DEFAULT_BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, CornerRadii.EMPTY, Insets.EMPTY)});
    private final Label label = new Label();
    private final VBox vLabel = new VBox(new Node[]{this.label});
    private final VBox valuesContainer = new VBox(3.0);
    private final VBox labelContainer = new VBox(5.0, new Node[]{this.vLabel, this.valuesContainer});
    private final VBox dragWrapper = new VBox(new Node[]{this.labelContainer});
    private final StructureObject rootObject;
    private final ObjectValues objectValues;
    private ObjectGroupView parent;
    private double originalX;
    private double originalY;
    private boolean dragging;
    private boolean xResizing;
    private boolean yResizing;
    private final boolean adjustable;

    public ObjectValuesView(StructureObject rootObject, ObjectValues objectValues, boolean adjustable) {
        this.getStyleClass().add((Object)"object-values");
        this.rootObject = rootObject;
        this.objectValues = objectValues;
        this.adjustable = adjustable;
        this.vLabel.setAlignment(Pos.CENTER);
        VBox.setVgrow((Node)this.vLabel, (Priority)Priority.ALWAYS);
        this.labelContainer.getStyleClass().add((Object)"object-values-label-container");
        this.labelContainer.setAlignment(Pos.CENTER);
        VBox.setVgrow((Node)this.labelContainer, (Priority)Priority.ALWAYS);
        this.valuesContainer.getStyleClass().addAll((Object[])new String[]{"obect-values-container"});
        VBox.setVgrow((Node)this.dragWrapper, (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)this.dragWrapper);
        InvalidationListener objectValuesChangedListener = il -> {
            this.updateView();
            ((GraphChartView)FXUtils.findParent((Node)this, GraphChartView.class)).childChanged();
        };
        objectValues.getValues().addListener(objectValuesChangedListener);
        objectValues.getInputValues().addListener(objectValuesChangedListener);
        this.updateView();
        if (this.isAdjustable()) {
            this.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2 && event.getButton() == MouseButton.PRIMARY) {
                    event.consume();
                    this.getObjectValues().setHideLabel(!this.getObjectValues().isHideLabel());
                    this.updateView();
                    ((GraphChartView)FXUtils.findParent((Node)this, GraphChartView.class)).reloadData();
                }
            });
        }
    }

    public boolean isAdjustable() {
        return this.adjustable;
    }

    public void updateView() {
        StructureObject object;
        Throwable throwable = null;
        Iterator iterator = null;
        try (Transaction trx = Transactions.begin();){
            object = GraphChartView.findStructureObject(trx, this.rootObject, this.objectValues);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.valuesContainer.getChildren().clear();
        for (ObjectValue objectValue : this.objectValues.getValues()) {
            this.valuesContainer.getChildren().add((Object)new ObjectValueView(objectValue));
        }
        for (ObjectInputValue objectInputValue : this.objectValues.getInputValues()) {
            this.valuesContainer.getChildren().add((Object)new ObjectInputValueView(objectInputValue));
        }
        if (!(!this.objectValues.isHideLabel() || this.objectValues.getValues().isEmpty() && this.objectValues.getInputValues().isEmpty())) {
            this.dragWrapper.getChildren().setAll((Object[])new Node[]{this.valuesContainer});
        } else {
            String localLabel = this.objectValues.getLocalLabel();
            if (localLabel != null && !localLabel.isEmpty()) {
                this.label.setGraphic(null);
                this.label.setText(localLabel);
            } else if (object != null) {
                this.label.setGraphic(object.getGraphic());
                this.label.setText(object.toString());
            } else {
                this.label.setGraphic(null);
                this.label.setText(null);
            }
            if (this.objectValues.getBackgroundColor() != null) {
                this.labelContainer.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.objectValues.getBackgroundColor(), CornerRadii.EMPTY, Insets.EMPTY)}));
            } else {
                this.labelContainer.setBackground(DEFAULT_BACKGROUND);
            }
            if (this.objectValues.getBorderColor() != null) {
                this.labelContainer.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)this.objectValues.getBorderColor(), BorderStrokeStyle.SOLID, CornerRadii.EMPTY, BorderWidths.DEFAULT)}));
            } else {
                this.labelContainer.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.BLACK, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, BorderWidths.DEFAULT)}));
            }
            if (!this.objectValues.getValues().isEmpty() || !this.objectValues.getInputValues().isEmpty()) {
                if (!this.labelContainer.getChildren().contains((Object)this.valuesContainer)) {
                    this.labelContainer.getChildren().add((Object)this.valuesContainer);
                }
            } else {
                this.labelContainer.getChildren().remove((Object)this.valuesContainer);
            }
            this.dragWrapper.getChildren().setAll((Object[])new Node[]{this.labelContainer});
        }
        this.setWidth(this.objectValues.getContentWidth());
        this.setHeight(this.objectValues.getContentHeight());
        this.setLayoutX(this.objectValues.getContentLayoutX());
        this.setLayoutY(this.objectValues.getContentLayoutY());
    }

    public static boolean edit(Window window, ObjectValues objectValues) {
        ObjectValuesPrefsDialog dlg = new ObjectValuesPrefsDialog(window, objectValues);
        ButtonType btn = (ButtonType)dlg.showAndWait().get();
        if (btn.equals(ButtonType.OK)) {
            ObjectValues dlgObjectValues = dlg.getObjectValues();
            objectValues.setStructureClass(dlgObjectValues.getStructureClass());
            objectValues.setStructureObjectSearchPolicy(dlgObjectValues.getStructureObjectSearchPolicy());
            objectValues.setStructureObject(dlgObjectValues.getStructureObject());
            objectValues.setLabel(dlgObjectValues.getLabel());
            objectValues.setHideLabel(dlgObjectValues.isHideLabel());
            objectValues.setBackgroundColor(dlgObjectValues.getBackgroundColor());
            objectValues.setBorderColor(dlgObjectValues.getBorderColor());
            objectValues.setContentWidth(dlgObjectValues.getContentWidth());
            objectValues.setContentHeight(dlgObjectValues.getContentHeight());
            objectValues.setContentLayoutX(dlgObjectValues.getContentLayoutX());
            objectValues.setContentLayoutY(dlgObjectValues.getContentLayoutY());
            return true;
        }
        return false;
    }

    protected void setWidth(double value) {
        super.setWidth(value);
    }

    protected void setHeight(double value) {
        super.setHeight(value);
    }

    @Override
    public ObjectGroupView getObjectGroupViewParent() {
        return this.parent;
    }

    public void setObjectGroupViewParent(ObjectGroupView parent) {
        this.parent = parent;
    }

    public ObjectValues getObjectValues() {
        return this.objectValues;
    }

    @Override
    public double getContentWidth() {
        return this.objectValues.getContentWidth();
    }

    @Override
    public void setContentWidth(double width) {
        this.objectValues.setContentWidth(width);
    }

    @Override
    public double getContentHeight() {
        return this.objectValues.getContentHeight();
    }

    @Override
    public void setContentHeight(double height) {
        this.objectValues.setContentHeight(height);
    }

    @Override
    public double getContentLayoutX() {
        return this.objectValues.getContentLayoutX();
    }

    @Override
    public void setContentLayoutX(double layoutX) {
        this.objectValues.setContentLayoutX(layoutX);
    }

    @Override
    public double getContentLayoutY() {
        return this.objectValues.getContentLayoutY();
    }

    @Override
    public void setContentLayoutY(double layoutY) {
        this.objectValues.setContentLayoutY(layoutY);
    }

    @Override
    public Region getDragNode() {
        return this.dragWrapper;
    }

    @Override
    public Region getMouseHandleNode() {
        return this;
    }

    @Override
    public double getOriginalX() {
        return this.originalX;
    }

    @Override
    public void setOriginalX(double originalX) {
        this.originalX = originalX;
    }

    @Override
    public double getOriginalY() {
        return this.originalY;
    }

    @Override
    public void setOriginalY(double originalY) {
        this.originalY = originalY;
    }

    @Override
    public boolean getXResizing() {
        return this.xResizing;
    }

    @Override
    public void setXResizing(boolean xDragging) {
        this.xResizing = xDragging;
    }

    @Override
    public boolean getYResizing() {
        return this.yResizing && !this.objectValues.isHideLabel();
    }

    @Override
    public void setYResizing(boolean yDragging) {
        this.yResizing = yDragging;
    }

    @Override
    public boolean getDragging() {
        return this.dragging;
    }

    @Override
    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }
}

