/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.internal;

import de.elpro.ewms.core.fx.Messages;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class ComplexRasterDescriptor {
    private final String customLabel;
    private final ComplexRaster raster;

    public ComplexRasterDescriptor(ComplexRaster raster) {
        this(raster, null);
    }

    public ComplexRasterDescriptor(ComplexRaster raster, String customLabel) {
        this.raster = raster;
        this.customLabel = customLabel == null ? raster.toString() : customLabel;
    }

    public String toString() {
        return this.customLabel;
    }

    public static ObservableList<ComplexRasterDescriptor> createDescriptors(Raster minRaster) {
        ObservableList rasters = FXCollections.observableArrayList();
        Raster[] rasterArray = Raster.values();
        int n = rasterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Raster raster = rasterArray[n2];
            if (raster.toMilli() >= minRaster.toMilli() && raster != Raster.Hour) {
                if (raster == minRaster) {
                    rasters.add((Object)new ComplexRasterDescriptor(ComplexRaster.of((Raster)raster), String.format(Messages.internal_VirtualRasterDescriptor_Default, minRaster.toString())));
                } else if (raster.toMilli() % minRaster.toMilli() == 0L) {
                    rasters.add((Object)new ComplexRasterDescriptor(ComplexRaster.of((Raster)raster)));
                }
            }
            ++n2;
        }
        rasterArray = VirtualRaster.values();
        n = rasterArray.length;
        n2 = 0;
        while (n2 < n) {
            Raster virtualRaster = rasterArray[n2];
            rasters.add((Object)new ComplexRasterDescriptor(ComplexRaster.of((VirtualRaster)virtualRaster)));
            ++n2;
        }
        return rasters;
    }

    public boolean equals(Object obj) {
        if (obj instanceof VirtualRaster) {
            return this.raster == obj;
        }
        if (obj instanceof ComplexRasterDescriptor) {
            return this.raster.equals((Object)((ComplexRasterDescriptor)obj).raster);
        }
        return super.equals(obj);
    }

    public ComplexRaster getComplexRaster() {
        return this.raster;
    }

    public int hashCode() {
        return ComplexRasterDescriptor.class.hashCode() + 17 * (this.raster != null ? this.raster.ordinal() : -1);
    }
}

