/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.jfree;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import de.elpro.ewms.core.fx.jfree.IOptionalItemColorRenderer;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.chart.ui.GradientPaintTransformer;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.category.CategoryDataset;

public class LayeredBarRenderer
extends org.jfree.chart.renderer.category.LayeredBarRenderer
implements IOptionalItemColorRenderer {
    private Table<Integer, Integer, Paint> optionalItemColors = HashBasedTable.create();
    private double shiftFactor = 0.2;
    private boolean hideDuplicates = false;
    private static final long serialVersionUID = 1L;

    public double getSeriesShiftFactor(int series) {
        return this.shiftFactor;
    }

    public void setDefaultShiftFactor(double shiftFactor) {
        this.shiftFactor = shiftFactor;
    }

    protected void drawVerticalItem(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryDataset dataset, int row, int column) {
        EntityCollection entities;
        CategoryItemLabelGenerator generator;
        Number dataValue = dataset.getValue(row, column);
        if (dataValue == null) {
            return;
        }
        double rectX = domainAxis.getCategoryMiddle(column, this.getColumnCount(), dataArea, plot.getDomainAxisEdge()) - state.getBarWidth() / 2.0;
        int seriesCount = this.getRowCount();
        double value = dataValue.doubleValue();
        double base = 0.0;
        double lclip = this.getLowerClip();
        double uclip = this.getUpperClip();
        if (uclip <= 0.0) {
            if (value >= uclip) {
                return;
            }
            base = uclip;
            if (value <= lclip) {
                value = lclip;
            }
        } else if (lclip <= 0.0) {
            if (value >= uclip) {
                value = uclip;
            } else if (value <= lclip) {
                value = lclip;
            }
        } else {
            if (value <= lclip) {
                return;
            }
            base = this.getLowerClip();
            if (value >= uclip) {
                value = uclip;
            }
        }
        RectangleEdge edge = plot.getRangeAxisEdge();
        double transY1 = rangeAxis.valueToJava2D(base, dataArea, edge);
        double transY2 = rangeAxis.valueToJava2D(value, dataArea, edge);
        double rectY = Math.min(transY2, transY1);
        double rectHeight = Math.abs(transY2 - transY1);
        double shift = 0.0;
        double widthFactor = 1.0;
        double seriesBarWidth = this.getSeriesBarWidth(row);
        if (!Double.isNaN(seriesBarWidth)) {
            widthFactor = seriesBarWidth;
        }
        double rectWidth = widthFactor * state.getBarWidth();
        rectX += (1.0 - widthFactor) * state.getBarWidth() / 2.0;
        if (seriesCount > 1) {
            shift = rectWidth * this.getSeriesShiftFactor(row) / (double)(seriesCount - 1);
        }
        Rectangle2D.Double bar = new Rectangle2D.Double(rectX + (double)(seriesCount - 1 - row) * shift, rectY, rectWidth - (double)(seriesCount - 1 - row) * shift * 2.0, rectHeight);
        if (state.getElementHinting()) {
            this.beginElementGroup(g2, dataset.getRowKey(row), dataset.getColumnKey(column));
        }
        Paint itemPaint = this.getItemPaint(row, column);
        GradientPaintTransformer t = this.getGradientPaintTransformer();
        if (t != null && itemPaint instanceof GradientPaint) {
            itemPaint = t.transform((GradientPaint)itemPaint, (Shape)bar);
        }
        g2.setPaint(itemPaint);
        g2.fill(bar);
        if (this.isDrawBarOutline() && state.getBarWidth() > 3.0) {
            g2.setStroke(this.getItemOutlineStroke(row, column));
            g2.setPaint(this.getItemOutlinePaint(row, column));
            g2.draw(bar);
        }
        if (state.getElementHinting()) {
            this.endElementGroup(g2);
        }
        if ((generator = this.getItemLabelGenerator(row, column)) != null && this.isItemLabelVisible(dataset, row, column)) {
            double transX2;
            double transX1 = rangeAxis.valueToJava2D(base, dataArea, edge);
            this.drawItemLabel(g2, dataset, row, column, plot, generator, bar, transX1 > (transX2 = rangeAxis.valueToJava2D(value, dataArea, edge)));
        }
        if ((entities = state.getEntityCollection()) != null) {
            this.addItemEntity(entities, dataset, row, column, bar);
        }
    }

    @Override
    public void setItemPaint(int series, int item, Paint paint) {
        if (paint == null) {
            this.optionalItemColors.remove((Object)series, (Object)item);
        } else {
            this.optionalItemColors.put((Object)series, (Object)item, (Object)paint);
        }
    }

    public Paint getItemPaint(int row, int column) {
        Paint paint = (Paint)this.optionalItemColors.get((Object)row, (Object)column);
        if (paint != null) {
            return paint;
        }
        return super.getItemPaint(row, column);
    }

    public boolean isItemLabelVisible(CategoryDataset dataset, int row, int column) {
        boolean itemLabelVisible = super.isItemLabelVisible(row, column);
        if (itemLabelVisible && this.hideDuplicates && row > 0) {
            Number dataValue = dataset.getValue(row, column);
            Number prevValue = dataset.getValue(row - 1, column);
            if (prevValue == null) {
                return true;
            }
            return !dataValue.equals(prevValue) || row == dataset.getRowCount() - 1;
        }
        return itemLabelVisible;
    }

    public boolean isHideDuplicates() {
        return this.hideDuplicates;
    }

    public void setHideDuplicates(boolean hideDuplicates) {
        this.hideDuplicates = hideDuplicates;
    }
}

