/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.jfree;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import de.elpro.ewms.core.fx.jfree.IOptionalItemColorRenderer;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.category.CategoryDataset;

public class LevelRenderer
extends org.jfree.chart.renderer.category.LevelRenderer
implements IOptionalItemColorRenderer {
    private Table<Integer, Integer, Paint> optionalItemColors = HashBasedTable.create();
    private static final long serialVersionUID = 3697356500788051063L;
    private boolean drawOverlaid = false;

    public boolean isDrawOverlaid() {
        return this.drawOverlaid;
    }

    public void setDrawOverlaid(boolean drawOverlaid) {
        this.drawOverlaid = drawOverlaid;
    }

    protected void calculateItemWidth(CategoryPlot plot, Rectangle2D dataArea, int rendererIndex, CategoryItemRendererState state) {
        CategoryAxis domainAxis = this.getDomainAxis(plot, rendererIndex);
        CategoryDataset dataset = plot.getDataset(rendererIndex);
        if (dataset != null) {
            int rows;
            int columns = dataset.getColumnCount();
            int n = rows = state.getVisibleSeriesCount() >= 0 ? state.getVisibleSeriesCount() : dataset.getRowCount();
            if (this.isDrawOverlaid() && rows > 1) {
                rows = 1;
            }
            double space = 0.0;
            PlotOrientation orientation = plot.getOrientation();
            if (orientation == PlotOrientation.HORIZONTAL) {
                space = dataArea.getHeight();
            } else if (orientation == PlotOrientation.VERTICAL) {
                space = dataArea.getWidth();
            }
            double maxWidth = space * this.getMaximumItemWidth();
            double categoryMargin = 0.0;
            double currentItemMargin = 0.0;
            if (columns > 1) {
                categoryMargin = domainAxis.getCategoryMargin();
            }
            if (rows > 1) {
                currentItemMargin = this.getItemMargin();
            }
            double used = space * (1.0 - domainAxis.getLowerMargin() - domainAxis.getUpperMargin() - categoryMargin - currentItemMargin);
            if (rows * columns > 0) {
                state.setBarWidth(Math.min(used / (double)(rows * columns), maxWidth));
            } else {
                state.setBarWidth(Math.min(used, maxWidth));
            }
        }
    }

    protected double calculateBarW0(CategoryPlot plot, PlotOrientation orientation, Rectangle2D dataArea, CategoryAxis domainAxis, CategoryItemRendererState state, int row, int column) {
        double space = orientation.isHorizontal() ? dataArea.getHeight() : dataArea.getWidth();
        double barW0 = domainAxis.getCategoryStart(column, this.getColumnCount(), dataArea, plot.getDomainAxisEdge());
        int seriesCount = state.getVisibleSeriesCount();
        if (seriesCount < 0) {
            seriesCount = this.getRowCount();
        }
        int categoryCount = this.getColumnCount();
        if (seriesCount > 1 && !this.isDrawOverlaid()) {
            double seriesGap = space * this.getItemMargin() / (double)(categoryCount * (seriesCount - 1));
            double seriesW = this.calculateSeriesWidth(space, domainAxis, categoryCount, seriesCount);
            barW0 = barW0 + (double)row * (seriesW + seriesGap) + seriesW / 2.0 - state.getBarWidth() / 2.0;
        } else {
            barW0 = domainAxis.getCategoryMiddle(column, this.getColumnCount(), dataArea, plot.getDomainAxisEdge()) - state.getBarWidth() / 2.0;
        }
        return barW0;
    }

    @Override
    public void setItemPaint(int series, int item, Paint paint) {
        if (paint == null) {
            this.optionalItemColors.remove((Object)series, (Object)item);
        } else {
            this.optionalItemColors.put((Object)series, (Object)item, (Object)paint);
        }
    }

    public Paint getItemPaint(int row, int column) {
        Paint paint = (Paint)this.optionalItemColors.get((Object)row, (Object)column);
        if (paint != null) {
            return paint;
        }
        return super.getItemPaint(row, column);
    }
}

