/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.notes;

import de.elpro.ewms.core.fx.Messages;
import de.elpro.ewms.core.notes.Note;
import de.elpro.ewms.core.notes.NoteType;
import de.elpro.ui.fx.propertysheet.EnumPropertyItem;
import de.elpro.ui.fx.propertysheet.LocalDateTimePropertyItem;
import de.elpro.ui.fx.propertysheet.LocaleStringPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import de.elpro.ui.fx.propertysheet.StringPropertyItem;
import de.elpro.ui.fx.validator.Validators;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDateTime;
import java.util.Collection;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.stage.Modality;
import javafx.stage.Window;
import jidefx.scene.control.validation.Validator;
import org.controlsfx.control.PropertySheet;

class NoteEditDialog
extends Dialog<ButtonType> {
    private SimpleObjectProperty<LocalDateTime> from = new SimpleObjectProperty();
    private SimpleObjectProperty<LocalDateTime> to = new SimpleObjectProperty();
    private SimpleObjectProperty<NoteType> type = new SimpleObjectProperty();
    private SimpleStringProperty name = new SimpleStringProperty();
    private SimpleStringProperty description = new SimpleStringProperty();

    public NoteEditDialog(Window window, Note note) {
        this.initModality(Modality.WINDOW_MODAL);
        this.initOwner(window);
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL, ButtonType.OK});
        PropertySheet propertySheet = new PropertySheet();
        this.from.set(note.getFrom() != null ? LocalDateTime.ofInstant(note.getFrom(), ZoneId.systemDefault()) : null);
        this.to.set(note.getTo() != null ? LocalDateTime.ofInstant(note.getTo(), ZoneId.systemDefault()) : null);
        this.type.set((Object)note.getType());
        this.name.set(note.getName());
        this.description.set(note.getDescription());
        LocalDateTimePropertyItem fromItem = new LocalDateTimePropertyItem(Messages.notes_NoteEditDialog_from, this.from);
        fromItem.setValidator(Validators.combine((Validator[])new Validator[]{Validators.createNotEmptyValidator((String)Messages.notes_NoteEditDialog_from_not_empty), Validators.createValidator((o, ov, nv) -> {
            if (this.to.get() == null || this.from.get() == null) {
                return true;
            }
            return ((LocalDateTime)this.to.get()).isAfter((ChronoLocalDateTime)this.from.get());
        }, (String)Messages.notes_NoteEditDialog_from_not_before)}));
        LocalDateTimePropertyItem toItem = new LocalDateTimePropertyItem(Messages.notes_NoteEditDialog_to, this.to);
        toItem.setValidator(Validators.createValidator((o, ov, nv) -> {
            if (this.to.get() == null || this.from.get() == null) {
                return true;
            }
            return ((LocalDateTime)this.to.get()).isAfter((ChronoLocalDateTime)this.from.get());
        }, (String)Messages.notes_NoteEditDialog_to_not_after));
        EnumPropertyItem typeItem = new EnumPropertyItem(Messages.notes_NoteEditDialog_type, NoteType.class, this.type);
        typeItem.setValidator(Validators.createNotEmptyValidator((String)Messages.notes_NoteEditDialog_type_not_empty));
        LocaleStringPropertyItem nameItem = new LocaleStringPropertyItem(Messages.notes_NoteEditDialog_name, (ObservableValue)this.name);
        typeItem.setNullable(false);
        nameItem.setValidator(Validators.createNotEmptyValidator((String)Messages.notes_NoteEditDialog_name_not_empty));
        StringPropertyItem descriptionItem = new StringPropertyItem(Messages.notes_NoteEditDialog_description, (ObservableValue)this.description);
        descriptionItem.useAreaEditor(true);
        this.from.addListener(o -> toItem.forceValidate());
        this.to.addListener(o -> fromItem.forceValidate());
        propertySheet.getItems().setAll((Object[])new PropertySheet.Item[]{fromItem, toItem, typeItem, nameItem, descriptionItem});
        this.getDialogPane().lookupButton(ButtonType.OK).disableProperty().bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)propertySheet.getItems()));
        this.getDialogPane().setContent((Node)propertySheet);
        this.getDialogPane().setPrefWidth(600.0);
        this.setResizable(true);
        this.setResultConverter(btn -> {
            if (btn == ButtonType.OK) {
                note.setFrom(((LocalDateTime)this.from.get()).atZone(ZoneId.systemDefault()).toInstant());
                note.setTo(this.to.get() != null ? ((LocalDateTime)this.to.get()).atZone(ZoneId.systemDefault()).toInstant() : null);
                note.setType((NoteType)this.type.get());
                note.setName(this.name.get());
                note.setDescription(this.description.get());
            }
            return btn;
        });
    }
}

