/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.notes;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.notes.NoteDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.fx.model.UIObjectState;
import de.elpro.ewms.core.fx.notes.NotesSkin;
import de.elpro.ewms.core.notes.Note;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.fx.collections.ChangeType;
import de.elpro.ui.fx.utils.TaskUtils;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Worker;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.util.Pair;

public class Notes
extends Control {
    private final StructureObject structureObject;
    private final ObservableList<Note> notes = FXCollections.observableArrayList();
    private final SimpleObjectProperty<UIObjectState> state = new SimpleObjectProperty((Object)UIObjectState.New);
    private final ObservableList<Pair<ChangeType, Note>> changes = FXCollections.observableArrayList();
    private final ObservableBooleanValue hasChanges = Bindings.isNotEmpty(this.changes);
    private ITimeRangeFilter timeRangeFilter;

    public Notes(StructureObject structureObject, ITimeRangeFilter timeRangeFilter) {
        this.structureObject = structureObject;
        this.timeRangeFilter = timeRangeFilter;
        this.reloadData();
    }

    protected Skin<?> createDefaultSkin() {
        return new NotesSkin(this);
    }

    public StructureObject getStructureObject() {
        return this.structureObject;
    }

    public ObservableList<Note> getNotes() {
        return this.notes;
    }

    public UIObjectState getState() {
        return (UIObjectState)((Object)this.state.get());
    }

    public SimpleObjectProperty<UIObjectState> stateProperty() {
        return this.state;
    }

    ObservableList<Pair<ChangeType, Note>> getChanges() {
        return this.changes;
    }

    public ObservableBooleanValue hasChangesProperty() {
        return this.hasChanges;
    }

    public boolean hasChanges() {
        return this.hasChanges.get();
    }

    public Future<?> reloadData() {
        return this.loadData(this.timeRangeFilter);
    }

    public Future<?> loadData(final ITimeRangeFilter timeRangeFilter) {
        this.timeRangeFilter = timeRangeFilter;
        if (timeRangeFilter == null) {
            return null;
        }
        Platform.runLater(() -> this.stateProperty().set((Object)UIObjectState.Loading));
        CallableTask<Collection<Note>> task = new CallableTask<Collection<Note>>(){

            public Collection<Note> call() throws Exception {
                Transaction trx = Transactions.begin();
                try {
                    Note[] notes = NoteDAO.getByStructureObject((Transaction)trx, (RawValuesViewType)timeRangeFilter.getType().toRawValueViewType(), (Integer)timeRangeFilter.getCustomViewIndex(), (StructureObject)Notes.this.structureObject, (Instant)timeRangeFilter.getFrom(), (Instant)timeRangeFilter.getTo());
                    List<Note> list = Arrays.asList(notes);
                    return list;
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            }
        };
        return TaskUtils.executeUITask(null, (CallableTask)task).consumeResult((status, result) -> Platform.runLater(() -> {
            if (status == Worker.State.SUCCEEDED) {
                this.notes.setAll(result);
                this.stateProperty().setValue((Object)UIObjectState.Ready);
            } else {
                this.notes.clear();
                this.stateProperty().setValue((Object)UIObjectState.Error);
            }
        }));
    }

    public void saveChanges() throws DAOOperationException {
        Transaction trx = Transactions.begin();
        try {
            try {
                for (Pair change : this.changes) {
                    if (change.getKey() == ChangeType.New || change.getKey() == ChangeType.Modified) {
                        NoteDAO.saveOrUpdate((Transaction)trx, (Note)((Note)change.getValue()));
                        continue;
                    }
                    if (change.getKey() != ChangeType.Removed) continue;
                    NoteDAO.delete((Transaction)trx, (int)((Note)change.getValue()).getId());
                }
                Transactions.commitAsync((Transaction)trx);
                this.resetChanges();
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                throw exc;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    public void resetChanges() {
        this.changes.clear();
    }
}

