/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.notes;

import de.elpro.ewms.core.fx.Messages;
import de.elpro.ewms.core.fx.model.UIObjectState;
import de.elpro.ewms.core.fx.notes.NoteEditDialog;
import de.elpro.ewms.core.fx.notes.Notes;
import de.elpro.ewms.core.notes.Note;
import de.elpro.ewms.core.notes.NoteType;
import de.elpro.resources.Icons;
import de.elpro.ui.formats.TimeFormatType;
import de.elpro.ui.fx.cells.InstantTableCell;
import de.elpro.ui.fx.cells.uimodel.UIModelTableCell;
import de.elpro.ui.fx.collections.ChangeType;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import de.elpro.ui.fx.utils.FXUtils;
import de.elpro.ui.text.LocaleText;
import java.time.Instant;
import java.util.Collections;
import java.util.HashSet;
import javafx.beans.property.SimpleStringProperty;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.PickResult;
import javafx.scene.layout.BorderPane;
import javafx.util.Pair;

class NotesSkin
extends SkinBase<Notes> {
    private final TableView<Note> tableView;
    private final TableColumn<Note, Instant> fromColumn = new TableColumn(Messages.notes_NotesSkin_from);
    private final TableColumn<Note, Instant> toColumn = new TableColumn(Messages.notes_NotesSkin_to);
    private final TableColumn<Note, NoteType> typeColumn = new TableColumn(Messages.notes_NotesSkin_type);
    private final TableColumn<Note, String> nameColumn = new TableColumn(Messages.notes_NotesSkin_name);
    private final MenuItem editNote = new MenuItem(Messages.notes_NotesSkin_edit, (Node)new ImageView(Icons.EDIT_ITEM_URL.toString()));
    private final MenuItem addNote = new MenuItem(Messages.notes_NotesSkin_add, (Node)new ImageView(Icons.ADD_ITEM_URL.toString()));
    private final MenuItem deleteNote = new MenuItem(Messages.notes_NotesSkin_delete, (Node)new ImageView(Icons.DELETE_ITEM_URL.toString()));
    private final ContextMenu menu = new ContextMenu(new MenuItem[]{this.editNote, new SeparatorMenuItem(), this.addNote, this.deleteNote});
    private final BorderPane borderPane = new BorderPane();

    public NotesSkin(Notes control) {
        super((Control)control);
        this.tableView = new TableView(control.getNotes());
        this.tableView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.fromColumn.setCellFactory(cf -> new InstantTableCell(TimeFormatType.DateTimeHMs.getFormatter(), (cell, item) -> cell.setAlignment(Pos.CENTER_RIGHT)));
        this.fromColumn.setCellValueFactory(cf -> ((Note)cf.getValue()).fromProperty());
        this.fromColumn.setPrefWidth(150.0);
        this.toColumn.setCellFactory(cf -> new InstantTableCell(TimeFormatType.DateTimeHMs.getFormatter(), (cell, item) -> cell.setAlignment(Pos.CENTER_RIGHT)));
        this.toColumn.setCellValueFactory(cf -> ((Note)cf.getValue()).toProperty());
        this.toColumn.setPrefWidth(150.0);
        this.typeColumn.setCellFactory(cf -> new UIModelTableCell((cell, item) -> {
            cell.setAlignment(Pos.CENTER_RIGHT);
            cell.setStyle("-fx-font-weight: bold;");
        }, new String[0]));
        this.typeColumn.setCellValueFactory(cf -> ((Note)cf.getValue()).typeProperty());
        this.typeColumn.setPrefWidth(150.0);
        this.nameColumn.setCellValueFactory(cf -> {
            SimpleStringProperty localNameProperty = new SimpleStringProperty(((Note)cf.getValue()).getLocalName());
            ((Note)cf.getValue()).nameProperty().addListener((o, ov, nv) -> localNameProperty.set(LocaleText.tryParse((String)nv).getTextOrDefault()));
            return localNameProperty;
        });
        this.nameColumn.setPrefWidth(500.0);
        this.editNote.setDisable(true);
        this.deleteNote.setDisable(true);
        this.tableView.getSelectionModel().getSelectedItems().addListener(o -> {
            boolean selectionEmpty = this.tableView.getSelectionModel().getSelectedItems().isEmpty();
            this.editNote.setDisable(selectionEmpty);
            this.deleteNote.setDisable(selectionEmpty);
        });
        this.tableView.setOnMouseClicked(e -> {
            if (e.getButton() == MouseButton.PRIMARY && e.getClickCount() == 2) {
                PickResult pr = e.getPickResult();
                TableCell cell = (TableCell)FXUtils.findParent((Node)pr.getIntersectedNode(), TableCell.class);
                if (cell == null) {
                    return;
                }
                int index = cell.getIndex();
                if (this.tableView.getItems().size() > index) {
                    Note note = (Note)this.tableView.getItems().get(index);
                    NoteEditDialog dlg = new NoteEditDialog(control.getScene().getWindow(), note);
                    dlg.showAndWait().ifPresent(btn -> {
                        if (btn == ButtonType.OK) {
                            Collections.sort(control.getNotes(), (n1, n2) -> n2.getFrom().compareTo(n1.getFrom()));
                            if (!control.getChanges().stream().filter(change -> change.getValue() == note).findAny().isPresent()) {
                                control.getChanges().add((Object)new Pair((Object)ChangeType.Modified, (Object)note));
                            }
                        }
                    });
                }
            }
        });
        this.addNote.setOnAction(e -> {
            Note note = new Note();
            note.setStructureObject(control.getStructureObject());
            NoteEditDialog dlg = new NoteEditDialog(control.getScene().getWindow(), note);
            dlg.showAndWait().ifPresent(btn -> {
                if (btn == ButtonType.OK) {
                    control.getNotes().add((Object)note);
                    Collections.sort(control.getNotes(), (n1, n2) -> n2.getFrom().compareTo(n1.getFrom()));
                    if (!control.getChanges().stream().filter(change -> change.getValue() == note).findAny().isPresent()) {
                        control.getChanges().add((Object)new Pair((Object)ChangeType.New, (Object)note));
                    }
                }
            });
        });
        this.editNote.setOnAction(e -> {
            Note note = (Note)this.tableView.getSelectionModel().getSelectedItem();
            if (note == null) {
                return;
            }
            NoteEditDialog dlg = new NoteEditDialog(control.getScene().getWindow(), note);
            dlg.showAndWait().ifPresent(btn -> {
                if (btn == ButtonType.OK) {
                    Collections.sort(control.getNotes(), (n1, n2) -> n2.getFrom().compareTo(n1.getFrom()));
                    if (!control.getChanges().stream().filter(change -> change.getValue() == note).findAny().isPresent()) {
                        control.getChanges().add((Object)new Pair((Object)ChangeType.Modified, (Object)note));
                    }
                }
            });
        });
        this.deleteNote.setOnAction(e -> {
            Alert alert = new Alert(Alert.AlertType.WARNING, Messages.notes_NotesSkin_warning, new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
            alert.setContentText(Messages.notes_NotesSkin_delete_question);
            alert.initOwner(control.getScene().getWindow());
            alert.showAndWait().ifPresent(btn -> {
                if (btn == ButtonType.OK) {
                    HashSet removedNotes = new HashSet(this.tableView.getSelectionModel().getSelectedItems());
                    control.getNotes().removeAll(removedNotes);
                    control.getChanges().removeIf(change -> removedNotes.contains(change.getValue()));
                    removedNotes.forEach(note -> {
                        if (note.getId() != null) {
                            control.getChanges().add((Object)new Pair((Object)ChangeType.Removed, note));
                        }
                    });
                    this.tableView.getSelectionModel().clearSelection();
                }
            });
        });
        this.tableView.getColumns().addAll((Object[])new TableColumn[]{this.fromColumn, this.toColumn, this.typeColumn, this.nameColumn});
        this.tableView.setContextMenu(this.menu);
        this.borderPane.setCenter(this.tableView);
        ProgressIndicatorPane progressIndicatorPane = new ProgressIndicatorPane((Node)this.borderPane);
        control.stateProperty().addListener((o, ov, nv) -> progressIndicatorPane.showIndicator(control.getState() == UIObjectState.Loading));
        progressIndicatorPane.showIndicator(control.getState() == UIObjectState.Loading);
        this.getChildren().add((Object)progressIndicatorPane);
    }
}

