/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.properties;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.PropertyDAO;
import de.elpro.ewms.core.client.structure.PropertyGroupDAO;
import de.elpro.ewms.core.client.structure.PropertyValueDAO;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.fx.Messages;
import de.elpro.ewms.core.structure.IPropertyType;
import de.elpro.ewms.core.structure.PropertyGroup;
import de.elpro.ewms.core.structure.PropertyTypes;
import de.elpro.ewms.core.structure.PropertyValue;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ui.fx.propertysheet.DynamicEditorPropertyItem;
import de.elpro.ui.fx.propertysheet.PropertyItemsHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.ExceptionDialog;

public class ObjectPropertiesView
extends Control {
    private final StructureObject structureObject;
    private final Collection<de.elpro.ewms.core.structure.Property> properties;
    private final Map<de.elpro.ewms.core.structure.Property, DynamicEditorPropertyItem<String>> editorProperties = new HashMap<de.elpro.ewms.core.structure.Property, DynamicEditorPropertyItem<String>>();
    private final SimpleBooleanProperty hasChanges = new SimpleBooleanProperty(false);
    private final SimpleBooleanProperty hasErrors = new SimpleBooleanProperty(false);

    public ObjectPropertiesView(StructureObject structureObject) {
        LinkedList<de.elpro.ewms.core.structure.Property> visibleProperties = new LinkedList<de.elpro.ewms.core.structure.Property>();
        Transaction trx = Transactions.begin();
        try {
            structureObject = StructureObjectDAO.get((Transaction)trx, (int)structureObject.getId());
            PropertyGroup[] propertyGroupArray = PropertyGroupDAO.getAllByStructureClass((Transaction)trx, (StructureClass)structureObject.getStructureClass());
            int n = propertyGroupArray.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyGroup pg = propertyGroupArray[n2];
                de.elpro.ewms.core.structure.Property[] propertyArray = PropertyDAO.get((Transaction)trx, (PropertyGroup)pg);
                int n3 = propertyArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    de.elpro.ewms.core.structure.Property p = propertyArray[n4];
                    if (p.isUserVisible()) {
                        p.setGroup(pg);
                        visibleProperties.add(p);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        this.structureObject = structureObject;
        this.properties = Collections.unmodifiableList(visibleProperties);
    }

    public void saveChanges() {
        if (!this.hasChanges.get()) {
            return;
        }
        if (this.hasErrors.get()) {
            Alert alert = new Alert(Alert.AlertType.WARNING);
            alert.setContentText(String.format(Messages.properties_ObjectPropertiesView_Cannot_save_Fix_errors_first, this.structureObject.toString()));
            alert.showAndWait();
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                LinkedList<PropertyValue> changedValues = new LinkedList<PropertyValue>();
                for (Map.Entry<de.elpro.ewms.core.structure.Property, DynamicEditorPropertyItem<String>> entry : this.editorProperties.entrySet()) {
                    if (!entry.getValue().hasChangesProperty().get()) continue;
                    changedValues.add(new PropertyValue(this.structureObject, entry.getKey(), (String)entry.getValue().valueProperty().getValue()));
                }
                PropertyValueDAO.saveOrUpdate((Transaction)trx, changedValues);
                Transactions.commitSync((Transaction)trx);
                PropertyItemsHelper.resetHasChangesProperties(this.editorProperties.values());
            }
            catch (DAOOperationException exc) {
                Transactions.rollback((Transaction)trx);
                Platform.runLater(() -> {
                    ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                    dlg.setContentText(Messages.properties_ObjectPropertiesView_Error_saving_variable);
                    dlg.show();
                });
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    public ObservableBooleanValue hasChangesProperty() {
        return this.hasChanges;
    }

    public boolean hasChanges() {
        return this.hasChanges.get();
    }

    public boolean hasErrors() {
        return this.hasErrors.get();
    }

    protected Skin<?> createDefaultSkin() {
        return new ObjectPropertiesViewSkin(this);
    }

    private <V, P> Node createValueEditor(IPropertyType<V, P> type, Property<String> valuesStrProperty, String paramStr, ObservableBooleanValue editableProperty) {
        Property valueProperty = type.createValueProperty(valuesStrProperty);
        Object parameter = type.getParameterConverter() != null ? type.getParameterConverter().fromString(paramStr) : null;
        Node editor = type.createValueEditor(valueProperty, parameter, editableProperty);
        return editor;
    }

    private final class ObjectPropertiesViewSkin
    extends SkinBase<ObjectPropertiesView> {
        protected ObjectPropertiesViewSkin(ObjectPropertiesView control) {
            super((Control)control);
            PropertySheet sheet = new PropertySheet();
            for (de.elpro.ewms.core.structure.Property p : ObjectPropertiesView.this.properties) {
                IPropertyType type = PropertyTypes.getPropertyType((String)p.getTypeId());
                if (type == null) continue;
                PropertyValue propertyValue = ObjectPropertiesView.this.structureObject.getPropertyValue(p);
                if (propertyValue == null) {
                    propertyValue = new PropertyValue(ObjectPropertiesView.this.structureObject, p);
                    ObjectPropertiesView.this.structureObject.getPropertyValues().add(propertyValue);
                }
                DynamicEditorPropertyItem dynamicEditorItem = new DynamicEditorPropertyItem(p.getGroup().getLocalName(), p.getLocalName(), (ObservableValue)propertyValue.valueProperty());
                Node editor = ObjectPropertiesView.this.createValueEditor(type, (Property<String>)propertyValue.valueProperty(), p.getParameter(), (ObservableBooleanValue)p.userEditableProperty());
                dynamicEditorItem.setEditor(editor);
                sheet.getItems().add((Object)dynamicEditorItem);
                ObjectPropertiesView.this.editorProperties.put(p, (DynamicEditorPropertyItem<String>)dynamicEditorItem);
            }
            ObjectPropertiesView.this.hasChanges.bind((ObservableValue)PropertyItemsHelper.createHasChangesProperty((Collection)sheet.getItems()));
            ObjectPropertiesView.this.hasErrors.bind((ObservableValue)PropertyItemsHelper.createHasErrorsProperty((Collection)sheet.getItems()));
            sheet.setMode(PropertySheet.Mode.CATEGORY);
            this.getChildren().add((Object)sheet);
        }
    }
}

