/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.propertysheet.editors;

import de.elpro.ewms.core.client.resources.ResourcesDAO;
import de.elpro.ewms.core.fx.Messages;
import de.elpro.ewms.core.fx.propertysheet.IconKeyPropertyItem;
import de.elpro.ewms.core.resources.ResourceLoader;
import de.elpro.resources.Icons;
import de.elpro.ui.controlsfx.propertysheet.PropertyItem;
import de.elpro.ui.fx.cells.uimodel.UIModelListCell;
import de.elpro.ui.model.UIModelElement;
import java.io.File;
import java.util.LinkedList;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.property.editor.PropertyEditor;

public class IconKeyPropertyEditor
implements PropertyEditor<String> {
    private final ComboBox<IconDescriptor> editor = new ComboBox();
    private final Button addIconBtn = new Button(null, (Node)new ImageView(Icons.ADD_ITEM_URL.toString()));
    private final HBox editorBox = new HBox(4.0, new Node[]{this.editor, this.addIconBtn});
    private final IconKeyPropertyItem iconKeyItem;
    private static final IconDescriptor EMTPY_ICON = new IconDescriptor("", null);

    public IconKeyPropertyEditor(PropertySheet.Item property) {
        this.editor.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow(this.editor, (Priority)Priority.ALWAYS);
        if (property instanceof PropertyItem) {
            this.getEditor().disableProperty().bind((ObservableValue)((PropertyItem)property).readOnlyProperty());
        } else {
            this.getEditor().setDisable(!property.isEditable());
        }
        this.iconKeyItem = (IconKeyPropertyItem)property;
        this.editor.setButtonCell((ListCell)new UIModelListCell());
        this.editor.setCellFactory(listview -> new UIModelListCell());
        this.editor.setPromptText(this.iconKeyItem.getPromptText());
        this.reloadIcons();
        this.editor.valueProperty().addListener(l -> {
            if (this.editor.getValue() == null || this.editor.getValue() == EMTPY_ICON) {
                this.iconKeyItem.setValue(null);
            } else {
                this.iconKeyItem.setValue(((IconDescriptor)this.editor.getValue()).getPath());
            }
        });
        this.addIconBtn.setOnAction(e -> {
            UploadIconDialog dlg = new UploadIconDialog();
            dlg.showAndWait().ifPresent(b -> {
                if (b == ButtonType.OK) {
                    String prefix = this.iconKeyItem.getPathPrefix();
                    if (!prefix.isEmpty() && !prefix.endsWith("/")) {
                        prefix = String.valueOf(prefix) + "/";
                    }
                    if (!(prefix = String.valueOf(prefix) + (dlg.getGroup() != null ? dlg.getGroup() : "")).isEmpty() && !prefix.endsWith("/")) {
                        prefix = String.valueOf(prefix) + "/";
                    }
                    String iconName = dlg.getIconName();
                    ResourcesDAO.uploadResource((String)(String.valueOf(prefix) + iconName), (File)dlg.getIcon());
                    this.reloadIcons();
                    this.setValue(String.valueOf(prefix) + iconName);
                }
            });
        });
    }

    private void reloadIcons() {
        String[] iconKeys = ResourcesDAO.getResources((String)this.iconKeyItem.getPathPrefix());
        LinkedList<IconDescriptor> descriptors = new LinkedList<IconDescriptor>();
        if (this.iconKeyItem.isNullable()) {
            descriptors.add(EMTPY_ICON);
        }
        String[] stringArray = iconKeys;
        int n = iconKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String iconKey = stringArray[n2];
            descriptors.add(new IconDescriptor(this.iconKeyItem.getPathPrefix(), iconKey));
            ++n2;
        }
        this.editor.getItems().setAll(descriptors);
    }

    public Node getEditor() {
        return this.editorBox;
    }

    public void setValue(String arg0) {
        String prefix;
        if (arg0 == null) {
            this.editor.setValue((Object)EMTPY_ICON);
            return;
        }
        String iconKey = prefix = this.iconKeyItem.getPathPrefix();
        if (!prefix.isEmpty()) {
            iconKey = arg0.replace(String.valueOf(prefix) + (prefix.endsWith("/") ? "" : "/"), "");
        }
        IconDescriptor tempDescriptor = new IconDescriptor(prefix, iconKey);
        for (IconDescriptor item : this.editor.getItems()) {
            if (!item.equals(tempDescriptor)) continue;
            this.editor.setValue((Object)item);
            return;
        }
        this.editor.setValue((Object)EMTPY_ICON);
    }

    public String getValue() {
        IconDescriptor descriptor = (IconDescriptor)this.editor.getValue();
        if (descriptor == null || descriptor == EMTPY_ICON) {
            return null;
        }
        return descriptor.getPath();
    }

    private static class IconDescriptor
    implements UIModelElement {
        private final String prefix;
        private final String iconKey;

        public IconDescriptor(String prefix, String iconKey) {
            this.prefix = prefix != null ? prefix : "";
            this.iconKey = iconKey;
        }

        public String getPath() {
            if (this.prefix.endsWith("/")) {
                return String.valueOf(this.prefix) + this.iconKey;
            }
            return String.valueOf(this.prefix) + "/" + this.iconKey;
        }

        public String toString() {
            return this.iconKey;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IconDescriptor)) {
                return false;
            }
            IconDescriptor objDesc = (IconDescriptor)obj;
            if (this.getPath() == null) {
                return objDesc.getPath() == null;
            }
            return this.getPath().equals(objDesc.getPath());
        }

        public int hashCode() {
            return String.valueOf(IconDescriptor.class.hashCode()) + this.iconKey == null ? 0 : this.iconKey.hashCode();
        }

        public Node getGraphic() {
            if (this.iconKey == null) {
                return null;
            }
            return new ImageView(ResourceLoader.getCachedIconPath((String)this.getPath()));
        }
    }

    private class UploadIconDialog
    extends Dialog<ButtonType> {
        private final GridPane pane = new GridPane();
        private final TextField nameField = new TextField();
        private final TextField groupField = new TextField();
        private final TextField iconPath = new TextField();
        private final TextField highDpiIconPath = new TextField();

        public UploadIconDialog() {
            this.initModality(Modality.WINDOW_MODAL);
            this.initOwner(IconKeyPropertyEditor.this.addIconBtn.getScene().getWindow());
            this.setWidth(600.0);
            this.pane.setPrefWidth(600.0);
            this.pane.setHgap(5.0);
            this.pane.setVgap(5.0);
            this.pane.addRow(0, new Node[]{new Label(Messages.propertysheet_editors_IconKeyPropertyEditor_Name), this.nameField});
            this.pane.addRow(1, new Node[]{new Label(Messages.propertysheet_editors_IconKeyPropertyEditor_Group), this.groupField});
            Button browseIconPath = new Button("...");
            this.pane.addRow(2, new Node[]{new Label(Messages.propertysheet_editors_IconKeyPropertyEditor_Icon_Path), new HBox(4.0, new Node[]{this.iconPath, browseIconPath})});
            Button browseHighDpiIconPath = new Button("...");
            this.pane.addRow(3, new Node[]{new Label(Messages.propertysheet_editors_IconKeyPropertyEditor_High_DPI_Icon_Path), new HBox(4.0, new Node[]{this.highDpiIconPath, browseHighDpiIconPath})});
            GridPane.setHgrow((Node)this.nameField, (Priority)Priority.ALWAYS);
            GridPane.setHgrow((Node)this.groupField, (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)this.iconPath, (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)this.highDpiIconPath, (Priority)Priority.ALWAYS);
            this.getDialogPane().setContent((Node)this.pane);
            this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL, ButtonType.OK});
            browseIconPath.setOnAction(e -> {
                FileChooser fc = new FileChooser();
                fc.setTitle(Messages.propertysheet_editors_IconKeyPropertyEditor_Select_Icon);
                fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(Messages.propertysheet_editors_IconKeyPropertyEditor_All_Icons, new String[]{"*.png", "*.gif"}));
                File file = fc.showOpenDialog(IconKeyPropertyEditor.this.addIconBtn.getScene().getWindow());
                if (file != null) {
                    this.nameField.setText(file.getName());
                    this.iconPath.setText(file.getAbsolutePath());
                }
            });
            browseHighDpiIconPath.setOnAction(e -> {
                FileChooser fc = new FileChooser();
                fc.setTitle(Messages.propertysheet_editors_IconKeyPropertyEditor_Select_High_DPI_Icon);
                fc.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(Messages.propertysheet_editors_IconKeyPropertyEditor_All_Icons, new String[]{"*.png", "*.gif"}));
                File file = fc.showOpenDialog(IconKeyPropertyEditor.this.addIconBtn.getScene().getWindow());
                if (file != null) {
                    this.highDpiIconPath.setText(file.getAbsolutePath());
                }
            });
        }

        public String getIconName() {
            return this.nameField.getText();
        }

        public String getGroup() {
            return this.groupField.getText();
        }

        public File getIcon() {
            return new File(this.iconPath.getText());
        }

        public File getHighDpiIcon() {
            return new File(this.highDpiIconPath.getText());
        }
    }
}

