/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.tables;

import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.fx.model.DataSelection;
import de.elpro.ewms.core.fx.model.IDataComposition;
import de.elpro.ewms.core.fx.model.IDataSelection;
import de.elpro.ewms.core.fx.model.IExportable;
import de.elpro.ewms.core.fx.model.UIObjectState;
import de.elpro.ewms.core.fx.tables.VarValuesColumn;
import de.elpro.ewms.core.fx.tables.skins.ChartValuesTableSkin;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ewms.core.variable.value.SupplementValueChange;
import de.elpro.resources.Resources;
import java.net.URL;
import java.time.Instant;
import java.util.Collection;
import java.util.concurrent.Future;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.TreeTableView;

public class ChartValuesTable
extends Control
implements IDataComposition,
IExportable {
    public static final URL DEFAULT_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"eclipse/all_instances.gif");
    private final ObservableList<VarValuesColumn> columns = FXCollections.observableArrayList();
    private final SimpleObjectProperty<IDataSelection> selectedData = new SimpleObjectProperty();
    private final ObservableList<SupplementValueChange> varValuesChanges = FXCollections.observableArrayList();
    private final ObservableBooleanValue hasChanges = Bindings.isNotEmpty(this.varValuesChanges);
    private final ChartValuesTableSkin skin;
    private final String title;

    public ChartValuesTable(String title) {
        this.title = title;
        this.skin = new ChartValuesTableSkin(this);
    }

    public ChartValuesTable(String title, Collection<VarValuesColumn> columns) {
        this(title);
        this.columns.addAll(columns);
    }

    protected Skin<?> createDefaultSkin() {
        return this.skin;
    }

    public ObservableList<VarValuesColumn> getColumns() {
        return this.columns;
    }

    @Override
    public void selectData(Instant atTimestamp, Object o) {
        Instant oldTimestamp;
        Instant instant = oldTimestamp = this.selectedData.getValue() != null ? ((IDataSelection)this.selectedData.getValue()).getEndTimestamp() : null;
        if (atTimestamp != null && !atTimestamp.equals(oldTimestamp)) {
            this.selectedData.set((Object)new DataSelection(atTimestamp, null));
        }
    }

    @Override
    public ReadOnlyProperty<IDataSelection> dataSelectionProperty() {
        return this.selectedData;
    }

    public ObservableList<SupplementValueChange> getVarValuesChanges() {
        return this.varValuesChanges;
    }

    public void saveChanges() throws DAOOperationException {
        VariableInstanceDAO.applySupplementValuesChanges((SupplementValueChange[])((SupplementValueChange[])this.varValuesChanges.toArray((Object[])new SupplementValueChange[0])), (boolean)false);
        this.resetChanges();
    }

    public void resetChanges() {
        this.varValuesChanges.clear();
    }

    public ObservableBooleanValue hasChangesProperty() {
        return this.hasChanges;
    }

    public boolean hasChanges() {
        return this.hasChanges.get();
    }

    @Override
    public String getReportLabel() {
        return this.title;
    }

    public TreeTableView<?> getReportObject() {
        return this.skin.getTableView();
    }

    @Override
    public Future<?> reloadData() {
        return null;
    }

    @Override
    public Future<?> loadData(ITimeRangeFilter timeRangeFilter) {
        return null;
    }

    @Override
    public UIObjectState getState() {
        return null;
    }

    @Override
    public SimpleObjectProperty<UIObjectState> stateProperty() {
        return null;
    }

    @Override
    public void dispose() {
        if (this.getSkin() != null) {
            this.getSkin().dispose();
        }
    }
}

