/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.tables;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import de.elpro.ewms.core.charts.ShapeType;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.fx.Messages;
import de.elpro.ewms.core.fx.charts.ChartUtils;
import de.elpro.ewms.core.fx.charts.DefaultJFreeChartTheme;
import de.elpro.ewms.core.fx.jfree.EfficientXYLineAndOptionalShapeRenderer;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.SupplementValue;
import de.elpro.ewms.core.variable.value.SupplementValueChange;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import de.elpro.ewms.core.virtualtime.VirtualZone;
import de.elpro.ui.fx.controls.DateTimePicker;
import java.awt.Color;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.Slider;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.fx.ChartViewer;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYDataset;

public class SaveSupplementValueChangesDialog
extends Alert {
    private final SimpleObjectProperty<Instant> changeFromTimestamp = new SimpleObjectProperty();
    private final SimpleBooleanProperty overwriteValues = new SimpleBooleanProperty(false);
    private final DateTimePicker changeFromPicker = new DateTimePicker();
    private XYPlot plot;
    private JFreeChart chart;
    private ChartViewer fxChartViewer;
    private final Map<ChangeGroup, NumberAxis> columnToNumberAxisMap = new HashMap<ChangeGroup, NumberAxis>();
    private final Map<ChangeGroup, TimeSeriesCollection> datasets = new HashMap<ChangeGroup, TimeSeriesCollection>();
    private final Map<ChangeGroup, Integer> datasetIndexes = new HashMap<ChangeGroup, Integer>();
    private final Map<ChangeGroup, EfficientXYLineAndOptionalShapeRenderer> renderers = new HashMap<ChangeGroup, EfficientXYLineAndOptionalShapeRenderer>();
    private final ITimeRangeFilter timeRangeFilter;
    private final Table<ChangeGroup, VariableInstance, SupplementValueChange> changes = HashBasedTable.create();
    private final Multimap<VariableInstance, SupplementValue> savedValues = LinkedHashMultimap.create();

    public SaveSupplementValueChangesDialog(Window window, Map<ChangeGroup, List<SupplementValueChange>> flatChanges, ITimeRangeFilter timeRangeFilter) {
        super(Alert.AlertType.CONFIRMATION);
        this.setResizable(true);
        this.initOwner(window);
        this.timeRangeFilter = timeRangeFilter;
        for (Map.Entry<ChangeGroup, List<SupplementValueChange>> entry : flatChanges.entrySet()) {
            for (SupplementValueChange svc : entry.getValue()) {
                this.changes.put((Object)entry.getKey(), (Object)svc.getInstance(), (Object)svc);
            }
        }
        LocalDate rangeFrom = VirtualZone.INSTANCE.getOffsetDateTime(VirtualRaster.Day.getRasterBegin(timeRangeFilter.getFrom()).minusNanos(1L)).toLocalDate();
        LocalDate rangeTo = VirtualZone.INSTANCE.getOffsetDateTime(VirtualRaster.Day.getRasterEnd(timeRangeFilter.getTo())).toLocalDate();
        this.changeFromTimestamp.set((Object)timeRangeFilter.getFrom());
        GridPane pane = new GridPane();
        pane.setVgap(5.0);
        pane.setHgap(10.0);
        this.createChartPreview();
        this.loadSavedValues();
        this.fxChartViewer.setPrefHeight(400.0);
        this.fxChartViewer.setPrefWidth(700.0);
        pane.add((Node)this.fxChartViewer, 0, 0, 2, 1);
        Slider slider = new Slider(0.0, (double)Math.max(0L, Duration.between(rangeFrom.atStartOfDay(), rangeTo.atStartOfDay()).toDays()), 0.0);
        slider.setMajorTickUnit(Math.max(1.0, slider.getMax() / 50.0));
        slider.setMinorTickCount(0);
        slider.setSnapToTicks(slider.getMax() <= 50.0);
        slider.setShowTickMarks(true);
        slider.setBlockIncrement(1.0);
        slider.valueProperty().addListener((o, ov, nv) -> {
            long nextValue;
            long prevValue = Math.round(ov.doubleValue());
            if (prevValue != (nextValue = Math.round(nv.doubleValue()))) {
                this.sliderMoved(rangeFrom.plusDays(nextValue));
            }
        });
        HBox labelBox = new HBox(new Node[]{this.changeFromPicker});
        labelBox.setAlignment(Pos.CENTER);
        GridPane.setHgrow((Node)labelBox, (Priority)Priority.ALWAYS);
        VBox changeFromPane = new VBox(5.0, new Node[]{slider, labelBox});
        pane.addRow(1, new Node[]{new Label(Messages.tables_SaveSupplementValueChangesDialog_ChangeFrom), changeFromPane});
        CheckBox deleteFolowingValuesCb = new CheckBox();
        this.overwriteValues.bind((ObservableValue)deleteFolowingValuesCb.selectedProperty());
        this.overwriteValues.addListener(il -> this.updateChart());
        pane.addRow(2, new Node[]{new Label(Messages.tables_SaveSupplementValueChangesDialog_OverwriteValues), deleteFolowingValuesCb});
        pane.add((Node)new Separator(Orientation.HORIZONTAL), 0, 3, 2, 1);
        this.getDialogPane().setContent((Node)pane);
        this.setTitle(Messages.tables_SaveSupplementValueChangesDialog_DialogTitle);
        this.setHeaderText(Messages.tables_SaveSupplementValueChangesDialog_DialogHeaderText);
        this.changeFromPicker.dateTimeValueProperty().addListener((o, ov, nv) -> {
            ZonedDateTime zdt = ZonedDateTime.of(nv, ZoneId.systemDefault());
            this.changeFromTimestamp.set((Object)zdt.toInstant());
            this.updateChart();
        });
        this.sliderMoved(rangeFrom);
    }

    private void createChartPreview() {
        DateAxis dateAxis = new DateAxis(Messages.tables_SaveSupplementValueChangesDialog_Time);
        dateAxis.setStandardTickUnits(ChartUtils.createStandardDateTickUnits(TimeZone.getDefault(), Locale.getDefault()));
        this.plot = new XYPlot(null, (ValueAxis)dateAxis, null, null);
        this.chart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, (Plot)this.plot, true);
        DefaultJFreeChartTheme.getChartTheme().apply(this.chart);
        this.fxChartViewer = new ChartViewer(this.chart);
        int datasetIndex = 0;
        for (ChangeGroup changeGroup : this.changes.rowKeySet()) {
            NumberAxis yAxis = new NumberAxis(changeGroup.getAxisName());
            TimeSeriesCollection dataset = new TimeSeriesCollection(TimeZone.getTimeZone("UTC"));
            EfficientXYLineAndOptionalShapeRenderer renderer = new EfficientXYLineAndOptionalShapeRenderer();
            renderer.setUseFillPaint(true);
            yAxis.setAutoRangeIncludesZero(false);
            this.columnToNumberAxisMap.put(changeGroup, yAxis);
            this.datasets.put(changeGroup, dataset);
            this.datasetIndexes.put(changeGroup, datasetIndex);
            this.renderers.put(changeGroup, renderer);
            this.plot.setRangeAxis(datasetIndex, (ValueAxis)yAxis);
            this.plot.setRenderer(datasetIndex, (XYItemRenderer)renderer);
            this.plot.setDataset(datasetIndex, (XYDataset)dataset);
            this.plot.mapDatasetToRangeAxis(datasetIndex, datasetIndex);
            ++datasetIndex;
        }
        DefaultJFreeChartTheme.getChartTheme().apply(this.chart);
    }

    private void loadSavedValues() {
        for (SupplementValueChange svc : this.changes.values()) {
            VariableInstance instance = svc.getInstance();
            if (this.savedValues.containsKey((Object)instance)) continue;
            this.savedValues.putAll((Object)instance, Arrays.asList(VariableInstanceDAO.getOriginalSupplementValues((int)instance.getId(), null, (Instant)this.timeRangeFilter.getFrom(), (Instant)this.timeRangeFilter.getTo())));
        }
    }

    private void sliderMoved(LocalDate newDate) {
        this.changeFromPicker.setValue((Object)newDate);
    }

    private void updateChart() {
        this.plot.setNotify(false);
        long ts = ((Instant)this.changeFromTimestamp.getValue()).toEpochMilli();
        TimeSeriesCollection[] newDatasets = new TimeSeriesCollection[this.datasets.size()];
        int i = 0;
        while (i < newDatasets.length) {
            newDatasets[i] = new TimeSeriesCollection(TimeZone.getTimeZone("UTC"));
            ++i;
        }
        for (EfficientXYLineAndOptionalShapeRenderer renderer : this.renderers.values()) {
            renderer.clearSeriesItemPaints(false);
            renderer.clearSeriesItemShapes(false);
        }
        for (Table.Cell cell : this.changes.cellSet()) {
            ChangeGroup changeGroup = (ChangeGroup)cell.getRowKey();
            VariableInstance instance = (VariableInstance)cell.getColumnKey();
            SupplementValueChange svc = (SupplementValueChange)cell.getValue();
            TimeSeriesCollection dataset = newDatasets[this.datasetIndexes.get(changeGroup)];
            EfficientXYLineAndOptionalShapeRenderer renderer = this.renderers.get(changeGroup);
            int seriesIndex = dataset.getSeriesCount();
            TimeSeries series = new TimeSeries((Comparable)((Object)String.format("%s - %s", changeGroup.getSeriesName(), instance.getStructureObject())));
            dataset.addSeries(series);
            renderer.setSeriesShape(seriesIndex, ShapeType.Circle.createAWTShape(4.0f));
            Long prevTS = null;
            Double prevValue = null;
            long beginTs = this.timeRangeFilter.getFrom().toEpochMilli();
            LinkedList<SupplementValue> filteredValues = new LinkedList<SupplementValue>();
            for (SupplementValue originalSV : this.savedValues.get((Object)instance)) {
                if (originalSV.getStartTimestamp() <= beginTs && !filteredValues.isEmpty()) {
                    filteredValues.clear();
                }
                filteredValues.add(originalSV);
            }
            for (SupplementValue originalSV : filteredValues) {
                long displayOriginalSVTS = Math.max(this.timeRangeFilter.getFrom().toEpochMilli(), originalSV.getStartTimestamp());
                if ((prevTS == null || prevTS != null && prevTS < ts) && ts <= displayOriginalSVTS) {
                    this.insertNewPoint(renderer, series, seriesIndex, prevValue, ts, svc.getValue(), true, true);
                    prevTS = ts;
                    prevValue = svc.getValue();
                }
                if (displayOriginalSVTS >= ts && (displayOriginalSVTS <= ts || this.isOverwriteValues())) continue;
                this.insertNewPoint(renderer, series, seriesIndex, prevValue, displayOriginalSVTS, originalSV.getValue(), displayOriginalSVTS == originalSV.getStartTimestamp(), false);
                prevTS = displayOriginalSVTS;
                prevValue = originalSV.getValue();
            }
            if (prevTS == null || prevTS < ts) {
                this.insertNewPoint(renderer, series, seriesIndex, prevValue, ts, svc.getValue(), true, true);
                prevValue = svc.getValue();
            }
            if (ts >= this.timeRangeFilter.getTo().toEpochMilli()) continue;
            this.insertNewPoint(renderer, series, seriesIndex, prevValue, this.timeRangeFilter.getTo().toEpochMilli(), prevValue, false, false);
        }
        i = 0;
        while (i < newDatasets.length) {
            this.plot.setDataset(i, (XYDataset)newDatasets[i]);
            ++i;
        }
        this.plot.setNotify(true);
    }

    private Second toSecond(long endTimestamp) {
        LocalDateTime ldt = LocalDateTime.ofInstant(Instant.ofEpochMilli(endTimestamp), ZoneOffset.UTC);
        Day day = new Day(ldt.getDayOfMonth(), ldt.getMonthValue(), ldt.getYear());
        Hour hour = new Hour(ldt.getHour(), day);
        Minute minute = new Minute(ldt.getMinute(), hour);
        return new Second(ldt.getSecond(), minute);
    }

    private void insertNewPoint(EfficientXYLineAndOptionalShapeRenderer renderer, TimeSeries series, int seriesIndex, Double prevValue, long ts, double value, boolean showPointShape, boolean newValue) {
        if (prevValue != null) {
            TimeSeriesDataItem prevLinePoint = new TimeSeriesDataItem((RegularTimePeriod)this.toSecond(ts - 1000L), (Number)prevValue);
            series.add(prevLinePoint);
            renderer.setItemShapeVisible(seriesIndex, series.getItemCount() - 1, false);
        }
        TimeSeriesDataItem newLinePoint = new TimeSeriesDataItem((RegularTimePeriod)this.toSecond(ts), value);
        series.add(newLinePoint);
        renderer.setItemShapeVisible(seriesIndex, series.getItemCount() - 1, showPointShape);
        if (newValue) {
            renderer.setItemShape(seriesIndex, series.getItemCount() - 1, ShapeType.Circle.createAWTShape(6.0f));
            renderer.setItemShapeFilled(seriesIndex, series.getItemCount() - 1, true);
            renderer.setItemFillPaint(seriesIndex, series.getItemCount() - 1, Color.black);
        }
    }

    public Instant getChangeFrom() {
        return (Instant)this.changeFromTimestamp.get();
    }

    public boolean isOverwriteValues() {
        return this.overwriteValues.get();
    }

    public static class ChangeGroup {
        private final String axisName;
        private final String seriesName;

        public ChangeGroup(String axisName, String seriesName) {
            this.axisName = axisName;
            this.seriesName = axisName;
        }

        public String getAxisName() {
            return this.axisName;
        }

        public String getSeriesName() {
            return this.seriesName;
        }
    }
}

