/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.tables;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.structure.StructureClassDAO;
import de.elpro.ewms.core.client.tables.viewprefs.TableViewPrefsDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.fx.Messages;
import de.elpro.ewms.core.fx.internal.ComplexRasterDescriptor;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.tables.Table;
import de.elpro.ewms.core.tables.viewprefs.TableViewPrefs;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TimeRangeFilterType;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Window;

public class TablePrefsDialog
extends Dialog<ButtonType> {
    private final SimpleBooleanProperty copyPreferencesProperty = new SimpleBooleanProperty(false);
    private final TableViewPrefs tableViewPrefs;
    private final TimeRangeFilterType timeRangeFilterType;
    private final Integer customViewIndex;
    private final Raster minRaster;

    public TablePrefsDialog(Window window, TableViewPrefs tableViewPrefs, TimeRangeFilterType timeRangeFilterType, Integer customViewIndex, Raster minRaster) {
        this.initOwner(window);
        this.tableViewPrefs = tableViewPrefs;
        this.timeRangeFilterType = timeRangeFilterType;
        this.customViewIndex = customViewIndex;
        this.minRaster = minRaster;
        BorderPane pane = new BorderPane();
        pane.setTop(this.createRasterSettingsUI());
        CheckBox copyPrefsCb = new CheckBox(Messages.tables_TablePrefsDialog_Copy_preferences_to_similar_tables);
        copyPrefsCb.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
        this.copyPreferencesProperty.bind((ObservableValue)copyPrefsCb.selectedProperty());
        this.getDialogPane().setContent((Node)new VBox(10.0, new Node[]{pane, copyPrefsCb}));
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.CANCEL, ButtonType.OK});
    }

    protected Node createRasterSettingsUI() {
        ObservableList<ComplexRasterDescriptor> rasters = ComplexRasterDescriptor.createDescriptors(this.minRaster);
        ComboBox rasterCb = new ComboBox(rasters);
        rasterCb.setValue((Object)new ComplexRasterDescriptor(this.tableViewPrefs.getComplexRaster() != null ? this.tableViewPrefs.getComplexRaster() : ComplexRaster.of((Raster)this.minRaster)));
        rasterCb.valueProperty().addListener(il -> {
            ComplexRaster cr = ((ComplexRasterDescriptor)rasterCb.getValue()).getComplexRaster();
            if (cr == null || cr.ordinal() <= this.minRaster.ordinal()) {
                this.tableViewPrefs.setRaster(this.minRaster);
                this.tableViewPrefs.setVirtualRaster(null);
            } else {
                this.tableViewPrefs.setRaster(cr.getRaster());
                this.tableViewPrefs.setVirtualRaster(cr.getVirtualRaster());
            }
        });
        Label label = new Label(Messages.tables_TablePrefsDialog_Raster1);
        label.setPadding(new Insets(5.0));
        HBox box = new HBox(10.0, new Node[]{label, rasterCb});
        box.setPadding(new Insets(10.0));
        return box;
    }

    public void persist() {
        if (this.tableViewPrefs.getTable().getId() == null) {
            return;
        }
        Transaction trx = Transactions.begin();
        try {
            try {
                this.tableViewPrefs.setTimeRangeFilterType(this.timeRangeFilterType);
                this.tableViewPrefs.setCustomViewIndex(this.customViewIndex);
                TableViewPrefsDAO.saveOrUpdate((Transaction)trx, (TableViewPrefs)this.tableViewPrefs);
                if (this.copyPreferencesProperty.get()) {
                    StructureObject[] structureObjectArray = StructureClassDAO.getAllObjects((Transaction)trx, (int)this.tableViewPrefs.getTable().getStructureClass().getId());
                    int n = structureObjectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        StructureObject object = structureObjectArray[n2];
                        if (!object.equals((Object)this.tableViewPrefs.getStructureObject())) {
                            TableViewPrefs clonedPrefs = this.copyPreferences(trx, this.tableViewPrefs, object);
                            TableViewPrefsDAO.saveOrUpdate((Transaction)trx, (TableViewPrefs)clonedPrefs);
                        }
                        ++n2;
                    }
                }
                Transactions.commitSync((Transaction)trx);
            }
            catch (DAOOperationException e) {
                e.printStackTrace();
                Transactions.rollback((Transaction)trx);
                Transactions.close((Transaction)trx);
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    private TableViewPrefs copyPreferences(Transaction trx, TableViewPrefs sourcePrefs, StructureObject object) throws DAOOperationException {
        TableViewPrefs prefs = TableViewPrefsDAO.get((Transaction)trx, (Table)sourcePrefs.getTable(), (StructureObject)object);
        prefs = prefs != null ? new TableViewPrefs(prefs.getId().intValue(), sourcePrefs.getTable(), object) : new TableViewPrefs(sourcePrefs.getTable(), object);
        prefs.setTimeRangeFilterType(sourcePrefs.getTimeRangeFilterType());
        prefs.setCustomViewIndex(sourcePrefs.getCustomViewIndex());
        prefs.setRaster(sourcePrefs.getRaster());
        prefs.setVirtualRaster(sourcePrefs.getVirtualRaster());
        prefs.setColumnsPersistedState(sourcePrefs.getColumnsPersistedState());
        return prefs;
    }
}

