/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.tables;

import de.elpro.ewms.core.time.TimeIntervalStringValue;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.MeasuringUnitFormat;
import de.elpro.ewms.core.units.number.Number;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.IVarValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

public class VarTableCellData
implements Comparable<Object> {
    private final VariableInstance instance;
    private final MeasuringUnit displayUnit;
    private final MeasuringUnit valueUnit;
    private final MeasuringUnitFormat displayUnitFormat;
    private final Object object;
    private final boolean lockedCell;
    private final boolean summary;
    private Collection<String> cellStyleClasses = new LinkedHashSet<String>();

    public VarTableCellData(boolean summary) {
        this((MeasuringUnit)Number.DIMENSIONLESS, (MeasuringUnit)Number.DIMENSIONLESS, null, null, summary);
    }

    public VarTableCellData(String value) {
        this(value, false);
    }

    public VarTableCellData(VariableInstance instance, String value) {
        this(instance, null, null, value, false, false);
    }

    public VarTableCellData(VariableInstance instance, TimeIntervalStringValue ... values) {
        this(instance, null, null, (Object)values, false, false);
    }

    public VarTableCellData(String value, boolean summary) {
        this((MeasuringUnit)Number.DIMENSIONLESS, (MeasuringUnit)Number.DIMENSIONLESS, null, (Object)value, summary);
    }

    public VarTableCellData(Double value, MeasuringUnitFormat valueFormat) {
        this(value, valueFormat, false);
    }

    public VarTableCellData(Double value, MeasuringUnitFormat valueFormat, boolean summary) {
        this((MeasuringUnit)Number.DIMENSIONLESS, (MeasuringUnit)Number.DIMENSIONLESS, valueFormat, (Object)value, summary);
    }

    public VarTableCellData(MeasuringUnit displayUnit, MeasuringUnit valueUnit, MeasuringUnitFormat displayUnitFormat, Object object, boolean summary) {
        this.instance = null;
        this.valueUnit = valueUnit;
        this.displayUnit = displayUnit;
        this.displayUnitFormat = displayUnitFormat;
        this.object = object;
        this.summary = summary;
        this.lockedCell = false;
    }

    public VarTableCellData(VariableInstance instance, MeasuringUnit displayUnit, MeasuringUnitFormat displayUnitFormat, Object object, boolean lockedCell) {
        this(instance, displayUnit, displayUnitFormat, object, false, lockedCell);
    }

    public VarTableCellData(VariableInstance instance, MeasuringUnit displayUnit, MeasuringUnitFormat displayUnitFormat, Object object, boolean summary, boolean lockedCell) {
        this.instance = instance;
        this.valueUnit = instance.getVariable().getMeasuringUnit();
        this.displayUnit = displayUnit;
        this.displayUnitFormat = displayUnitFormat;
        this.object = object;
        this.lockedCell = lockedCell;
        this.summary = summary;
    }

    public MeasuringUnit getDisplayUnit() {
        return this.displayUnit;
    }

    public MeasuringUnit getValueUnit() {
        return this.valueUnit;
    }

    public MeasuringUnitFormat getDisplayUnitFormat() {
        return this.displayUnitFormat;
    }

    public VariableInstance getInstance() {
        return this.instance;
    }

    public Object getObject() {
        return this.object;
    }

    public boolean isLockedCell() {
        return this.lockedCell;
    }

    public boolean isSummary() {
        return this.summary;
    }

    public IVarValue getVarValue() {
        if (this.object instanceof IVarValue) {
            return (IVarValue)this.object;
        }
        if (this.object instanceof ArrayList) {
            ArrayList list = (ArrayList)this.object;
            if (list.size() == 1) {
                return (IVarValue)list.get(0);
            }
            return this.instance.getVariable().getResultAggregation().aggregateAndConvert((List)list);
        }
        return null;
    }

    public TimeIntervalStringValue[] getTimeIntervalStringValues() {
        if (this.object instanceof TimeIntervalStringValue[]) {
            return (TimeIntervalStringValue[])this.object;
        }
        return null;
    }

    public Double getDoubleValue() {
        IVarValue val = this.getVarValue();
        if (val != null) {
            return val.getValue();
        }
        if (this.object instanceof java.lang.Number) {
            return ((java.lang.Number)this.object).doubleValue();
        }
        return null;
    }

    public Double getDisplayDoubleValue() {
        Double value = this.getDoubleValue();
        if (value != null && this.displayUnit != null && this.valueUnit != null) {
            return this.displayUnit.convert(value.doubleValue(), this.valueUnit);
        }
        return value;
    }

    public double getDisplayValue() {
        Double doubleValue = this.getDoubleValue();
        return this.displayUnit.convert(doubleValue.doubleValue(), this.valueUnit);
    }

    public void addCellStyleClass(String styleClass) {
        this.cellStyleClasses.add(styleClass);
    }

    public Collection<String> getCellStyleClasses() {
        return Collections.unmodifiableCollection(this.cellStyleClasses);
    }

    public String toString() {
        return this.object != null ? this.object.toString() : null;
    }

    @Override
    public int compareTo(Object o) {
        if (this.isSummary()) {
            if (o instanceof VarTableCellData) {
                if (!((VarTableCellData)o).isSummary()) {
                    return 1;
                }
            } else {
                return 1;
            }
        }
        if (!(o instanceof VarTableCellData)) {
            return -1;
        }
        VarTableCellData vtcd = (VarTableCellData)o;
        if (!this.isSummary() && vtcd.isSummary()) {
            return -1;
        }
        Object o1 = this.getObject();
        Object o2 = vtcd.getObject();
        Double d1 = null;
        Double d2 = null;
        if (o1 instanceof IVarValue) {
            d1 = ((IVarValue)o1).getValue();
        } else if (o1 instanceof java.lang.Number) {
            d1 = ((java.lang.Number)o1).doubleValue();
        }
        if (o2 instanceof IVarValue) {
            d2 = ((IVarValue)o2).getValue();
        } else if (o1 instanceof java.lang.Number) {
            d2 = ((java.lang.Number)o2).doubleValue();
        }
        if (d1 != null && d2 != null) {
            return Double.compare(d1, d2);
        }
        if (d1 != null) {
            return -1;
        }
        if (d2 != null) {
            return 1;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return -1;
        }
        return o1.toString().compareTo(o2.toString());
    }
}

