/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.tables;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import de.elpro.ewms.core.fx.tables.VarTableCellData;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.tables.Column;
import de.elpro.ewms.core.variable.SupplementValueStrategy;
import de.elpro.ewms.core.variable.VariableInstance;
import java.time.Instant;
import java.util.ArrayList;
import javafx.beans.property.SimpleObjectProperty;

public class VarTableRow
implements Comparable<Object> {
    private final Instant intervalBegin;
    private final Instant intervalEnd;
    private final StructureObject structureObject;
    private final Table<Column, StructureObject, SimpleObjectProperty<VarTableCellData>> columnValues = HashBasedTable.create();
    private final Table<String, StructureObject, SimpleObjectProperty<VarTableCellData>> columnKeyValues = HashBasedTable.create();
    private final boolean summary;
    private CellEditCallback editCallback;

    public VarTableRow(Instant intervalBegin, Instant intervalEnd, StructureObject structureObject) {
        this(intervalBegin, intervalEnd, structureObject, false);
    }

    public VarTableRow(Instant intervalBegin, Instant intervalEnd, StructureObject structureObject, boolean summary) {
        this.intervalBegin = intervalBegin;
        this.intervalEnd = intervalEnd;
        this.structureObject = structureObject;
        this.summary = summary;
    }

    public Instant getIntervalBegin() {
        return this.intervalBegin;
    }

    public Instant getIntervalEnd() {
        return this.intervalEnd;
    }

    public StructureObject getStructureObject() {
        return this.structureObject;
    }

    public void setCellEditCallback(CellEditCallback cellEditCallback) {
        this.editCallback = cellEditCallback;
    }

    public void setColumnValue(Column column, StructureObject structureObject, VariableInstance instance, Object value) {
        SimpleObjectProperty<VarTableCellData> valueProperty = this.getColumnValueProperty(column, structureObject);
        if (instance != null) {
            valueProperty.set((Object)new VarTableCellData(instance, column.getResultDisplayMeasuringUnit(), column.getMeasuringUnitFormat(), value, this.summary, false));
        } else {
            valueProperty.set((Object)new VarTableCellData(column.getResultDisplayMeasuringUnit(), column.getResultValueMeasuringUnit(), column.getMeasuringUnitFormat(), value, this.summary));
        }
    }

    @Override
    public int compareTo(Object o) {
        if (!(o instanceof VarTableRow)) {
            return -1;
        }
        VarTableRow vtr = (VarTableRow)o;
        if (this.intervalEnd != null) {
            return this.intervalEnd.compareTo(vtr.intervalEnd);
        }
        return this.structureObject.compareTo((Object)vtr.structureObject);
    }

    public SimpleObjectProperty<VarTableCellData> getColumnValueProperty(Column column, StructureObject structureObject) {
        SimpleObjectProperty valueProperty = (SimpleObjectProperty)this.columnValues.get((Object)column, (Object)structureObject);
        if (valueProperty == null) {
            valueProperty = new SimpleObjectProperty();
            if (this.summary) {
                valueProperty.set((Object)new VarTableCellData(true));
            }
            if (column.isEditable()) {
                valueProperty.addListener((o, ov, nv) -> {
                    if (this.editCallback != null && ov != null) {
                        boolean unrasterized = nv.getInstance().getSupplementValueStrategy() == SupplementValueStrategy.Unrasterized;
                        this.editCallback.onEdit(column, nv.getInstance(), unrasterized ? null : this.intervalBegin, unrasterized ? null : this.intervalEnd, column.getSupplementValuesSelector(), nv.getObject());
                    }
                });
            }
            this.columnValues.put((Object)column, (Object)structureObject, (Object)valueProperty);
            if (!column.isKeyEmpty()) {
                this.columnKeyValues.put((Object)column.getKey(), (Object)structureObject, (Object)valueProperty);
            }
        }
        return valueProperty;
    }

    public VarTableCellData getColumnValue(Column column, StructureObject structureObject) {
        SimpleObjectProperty valueProperty = (SimpleObjectProperty)this.columnValues.get((Object)column, (Object)structureObject);
        return valueProperty != null ? (VarTableCellData)valueProperty.get() : null;
    }

    public VarTableCellData getColumnValue(String columnKey, StructureObject structureObject) {
        SimpleObjectProperty prop = (SimpleObjectProperty)this.columnKeyValues.get((Object)columnKey, (Object)structureObject);
        return prop != null ? (VarTableCellData)prop.getValue() : null;
    }

    public VarTableCellData[] getColumnValues(String columnKey) {
        ArrayList<VarTableCellData> values = new ArrayList<VarTableCellData>();
        for (SimpleObjectProperty prop : this.columnKeyValues.row((Object)columnKey).values()) {
            if (prop == null) continue;
            values.add((VarTableCellData)prop.get());
        }
        return (VarTableCellData[])values.toArray(VarTableCellData[]::new);
    }

    public boolean isSummary() {
        return this.summary;
    }

    static interface CellEditCallback {
        public void onEdit(Column var1, VariableInstance var2, Instant var3, Instant var4, Integer var5, Object var6);
    }
}

