/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.tables;

import com.google.common.base.Charsets;
import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.preferences.ServerDAO;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.client.tables.viewprefs.TableViewPrefsDAO;
import de.elpro.ewms.core.client.variable.VariableDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.client.variable.VariableRoleDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.fx.model.DataSelection;
import de.elpro.ewms.core.fx.model.IDataComposition;
import de.elpro.ewms.core.fx.model.IDataSelection;
import de.elpro.ewms.core.fx.model.IExportable;
import de.elpro.ewms.core.fx.model.ILoadDataCallback;
import de.elpro.ewms.core.fx.model.UIObjectState;
import de.elpro.ewms.core.fx.tables.LoadCustomColumnDataCallback;
import de.elpro.ewms.core.fx.tables.VarTableCellData;
import de.elpro.ewms.core.fx.tables.VarTableRow;
import de.elpro.ewms.core.fx.tables.skins.VarTableViewSkin;
import de.elpro.ewms.core.lang.ScriptParser;
import de.elpro.ewms.core.prefs.IViewPrefs;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.tables.Column;
import de.elpro.ewms.core.tables.ColumnGroup;
import de.elpro.ewms.core.tables.ColumnType;
import de.elpro.ewms.core.tables.Table;
import de.elpro.ewms.core.tables.TableType;
import de.elpro.ewms.core.tables.viewprefs.TableViewPrefs;
import de.elpro.ewms.core.time.ITimeRangeFilter;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.time.TimeIntervalStringValue;
import de.elpro.ewms.core.time.TimeIntervalStringValueCollection;
import de.elpro.ewms.core.time.TimeRange;
import de.elpro.ewms.core.time.TimeRangeFilterType;
import de.elpro.ewms.core.time.TsInterval;
import de.elpro.ewms.core.time.VariableInstanceTimeIntervalStringValues;
import de.elpro.ewms.core.units.Aggregation;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.PhysicalUnits;
import de.elpro.ewms.core.units.time.Second;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.calculated.FormulaNode;
import de.elpro.ewms.core.variable.calculated.FormulaOperation;
import de.elpro.ewms.core.variable.value.GetValuesRequest;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.IVarValuesCollection;
import de.elpro.ewms.core.variable.value.SupplementValue;
import de.elpro.ewms.core.variable.value.SupplementValueChange;
import de.elpro.ewms.core.variable.value.ValueSource;
import de.elpro.ewms.core.variable.value.VarValue;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import de.elpro.ui.concurrent.CallableTask;
import de.elpro.ui.formats.TimeFormatType;
import de.elpro.ui.fx.utils.ColumnsPersistedState;
import de.elpro.ui.fx.utils.FXUtils;
import de.elpro.ui.fx.utils.TaskUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.TableView;
import javafx.stage.Window;
import javafx.util.Callback;
import org.apache.commons.io.FileUtils;

public class VarTableView
extends Control
implements IExportable,
IDataComposition {
    private final Table tableConfig;
    private final StructureObject structureObject;
    private ITimeRangeFilter lastTimeRangeFilter;
    private TableViewPrefs tableViewPrefs;
    private final VirtualRaster fixedRaster;
    private final ObservableList<VarTableRow> rows = FXCollections.observableArrayList();
    private final SimpleObjectProperty<UIObjectState> state = new SimpleObjectProperty((Object)UIObjectState.New);
    private final SimpleObjectProperty<IDataSelection> dataSelection = new SimpleObjectProperty();
    private final Window window;
    private final HashMap<Column, List<SupplementValueChange>> columnSupplementValuesChanges = new HashMap();
    private final Map<VariableInstance, List<TimeIntervalStringValue>> timeIntervalValuesChanges = new HashMap<VariableInstance, List<TimeIntervalStringValue>>();
    private final BooleanProperty hasChanges = new SimpleBooleanProperty();
    private final Skin<?> skin;
    private final ColumnsPersistedState initialState = new ColumnsPersistedState();
    private ILoadDataCallback loadDataCallback;
    private Map<Column, LoadCustomColumnDataCallback> onLoadCustomColumnDataCallbacks = new LinkedHashMap<Column, LoadCustomColumnDataCallback>();
    private static final Comparator<Object> ROW_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Instant || o2 instanceof Instant) {
                if (o1 instanceof Instant && o2 instanceof Instant) {
                    return ((Instant)o1).compareTo((Instant)o2);
                }
                return o1 instanceof Instant ? -1 : 1;
            }
            if (o1 instanceof StructureObject || o2 instanceof StructureObject) {
                if (o1 instanceof StructureObject && o2 instanceof StructureObject) {
                    return ((StructureObject)o1).compareTo(o2);
                }
                return o1 instanceof StructureObject ? -1 : 1;
            }
            if (o1 instanceof Aggregation || o2 instanceof Aggregation) {
                if (o1 instanceof Aggregation && o2 instanceof Aggregation) {
                    return ((Aggregation)o1).compareTo((Enum)((Aggregation)o2));
                }
                return o1 instanceof Aggregation ? -1 : 1;
            }
            return o1.toString().compareTo(o2.toString());
        }
    };
    private final VarTableRow.CellEditCallback cellEditCallback = (tableColumn, instance, from, to, selector, newValue) -> {
        switch (tableColumn.getType()) {
            case AssignedText: {
                TimeIntervalStringValue tisv;
                TimeIntervalStringValue timeIntervalStringValue = tisv = newValue instanceof TimeIntervalStringValue[] ? ((TimeIntervalStringValue[])newValue)[0] : null;
                if (tisv == null) {
                    return;
                }
                List<TimeIntervalStringValue> ivVals = this.timeIntervalValuesChanges.get(instance);
                if (ivVals == null) {
                    ivVals = new ArrayList<TimeIntervalStringValue>();
                    this.timeIntervalValuesChanges.put(instance, ivVals);
                }
                ivVals.add(tisv);
                break;
            }
            default: {
                Double dVal = newValue instanceof IVarValue ? Double.valueOf(((IVarValue)newValue).getValue()) : null;
                SupplementValueChange svc = new SupplementValueChange(instance, from, to, selector, dVal.doubleValue());
                List<SupplementValueChange> cc = this.columnSupplementValuesChanges.get(tableColumn);
                if (cc == null) {
                    cc = new LinkedList<SupplementValueChange>();
                    this.columnSupplementValuesChanges.put(tableColumn, cc);
                }
                cc.add(svc);
            }
        }
        this.hasChanges.set(true);
    };

    public VarTableView(Table tableConfig, StructureObject structureObject, Window window, ITimeRangeFilter timeRangeFilter) {
        this(tableConfig, structureObject, window, timeRangeFilter, null);
    }

    public VarTableView(Table tableConfig, StructureObject structureObject, Window window, ITimeRangeFilter timeRangeFilter, VirtualRaster fixedRaster) {
        this.tableConfig = tableConfig;
        this.structureObject = structureObject;
        this.window = window;
        this.lastTimeRangeFilter = timeRangeFilter;
        this.fixedRaster = fixedRaster;
        tableConfig.normalize();
        this.skin = new VarTableViewSkin(this);
        if (tableConfig.getFXStylesheet() != null && !tableConfig.getFXStylesheet().isBlank() || tableConfig.getTableStyle() != null) {
            try {
                String css;
                File stylesheetTempFile = File.createTempFile("table_stylesheet_" + UUID.randomUUID().toString(), ".css_tmp");
                String string = css = tableConfig.getTableStyle() != null ? tableConfig.getTableStyle().toStylesheet() : "";
                if (tableConfig.getFXStylesheet() != null && !tableConfig.getFXStylesheet().isBlank()) {
                    css = String.valueOf(css) + tableConfig.getFXStylesheet();
                }
                FileUtils.writeStringToFile((File)stylesheetTempFile, (String)css, (Charset)Charsets.UTF_8);
                this.getStylesheets().add((Object)stylesheetTempFile.toURI().toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public ITimeRangeFilter getLastTimeRangeFilter() {
        return this.lastTimeRangeFilter;
    }

    protected Skin<?> createDefaultSkin() {
        ColumnsPersistedState state;
        this.reloadData();
        this.initialState.persistColumns(this.getReportObject().getColumns());
        if (this.tableViewPrefs != null && this.tableViewPrefs.getColumnsPersistedState() != null && (state = ColumnsPersistedState.parse((String)this.tableViewPrefs.getColumnsPersistedState())) != null) {
            state.restoreColumnsState(this.getReportObject().getColumns());
        }
        return this.skin;
    }

    public Table getConfig() {
        return this.tableConfig;
    }

    public StructureObject getStructureObject() {
        return this.structureObject;
    }

    public Window getWindow() {
        return this.window;
    }

    public ILoadDataCallback getOnLoadDataCallback() {
        return this.loadDataCallback;
    }

    public void setOnLoadDataCallback(ILoadDataCallback loadDataCallback) {
        this.loadDataCallback = loadDataCallback;
    }

    public LoadCustomColumnDataCallback getOnLoadCustomColumnDataCallback(Column column) {
        return this.onLoadCustomColumnDataCallbacks.get(column);
    }

    public void addOnLoadCustomColumnData(Column column, LoadCustomColumnDataCallback onLoadCustomColumnDataCallback) {
        this.onLoadCustomColumnDataCallbacks.put(column, onLoadCustomColumnDataCallback);
    }

    public void removeOnLoadCustomColumnDataCallback(Column column) {
        this.onLoadCustomColumnDataCallbacks.remove(column);
    }

    @Override
    public String getReportLabel() {
        return String.format("%s - %s", this.tableConfig.getLocalName(), this.structureObject);
    }

    public TableView<?> getReportObject() {
        return (TableView)FXUtils.findChild((Node)this, TableView.class);
    }

    @Override
    public Future<?> reloadData() {
        return this.loadData(this.lastTimeRangeFilter);
    }

    protected TableViewPrefs loadViewPrefs() {
        Transaction trx = Transactions.begin();
        try {
            TableViewPrefs prefs = null;
            prefs = TableViewPrefsDAO.get((Transaction)trx, (Table)this.tableConfig, (StructureObject)this.structureObject);
            if (prefs == null) {
                prefs = new TableViewPrefs(this.tableConfig, this.structureObject);
                prefs.setVirtualRaster(this.tableConfig.getDefaultRaster());
            }
            if (prefs.getTimeRangeFilterType() == null && this.lastTimeRangeFilter != null) {
                prefs.setTimeRangeFilterType(this.lastTimeRangeFilter.getType());
                prefs.setCustomViewIndex(this.lastTimeRangeFilter.getCustomViewIndex());
            }
            prefs.setTable(this.tableConfig);
            prefs.setStructureObject(this.structureObject);
            TableViewPrefs tableViewPrefs = prefs;
            return tableViewPrefs;
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    public TableViewPrefs getViewPrefs() {
        if (this.tableConfig.getId() != null && this.fixedRaster == null) {
            this.tableViewPrefs = this.loadViewPrefs();
        } else if (this.tableViewPrefs == null) {
            this.tableViewPrefs = new TableViewPrefs(this.tableConfig, this.structureObject);
            if (this.lastTimeRangeFilter != null) {
                this.tableViewPrefs.setTimeRangeFilterType(this.lastTimeRangeFilter.getType());
                this.tableViewPrefs.setCustomViewIndex(this.lastTimeRangeFilter.getCustomViewIndex());
            }
            this.tableViewPrefs.setVirtualRaster(this.tableConfig.getDefaultRaster());
            if (this.fixedRaster != null) {
                this.tableViewPrefs.setVirtualRaster(this.fixedRaster);
            }
        }
        return this.tableViewPrefs;
    }

    public TableViewPrefs getLastViewPrefs() {
        return this.tableViewPrefs;
    }

    @Override
    public Future<?> loadData(ITimeRangeFilter timeRangeFilter) {
        return this.loadData(timeRangeFilter, true);
    }

    protected void updateViewPrefsRaster(IViewPrefs viewPrefs) {
        if (!viewPrefs.getTimeRangeFilterType().toRawValueViewType().equals((Object)this.lastTimeRangeFilter.getType().toRawValueViewType()) || viewPrefs.getTimeRangeFilterType().toRawValueViewType() == RawValuesViewType.CustomView && (viewPrefs.getCustomViewIndex() != null || this.lastTimeRangeFilter.getCustomViewIndex() != null) && !viewPrefs.getCustomViewIndex().equals(this.lastTimeRangeFilter.getCustomViewIndex())) {
            viewPrefs.setTimeRangeFilterType(this.lastTimeRangeFilter.getType());
            viewPrefs.setCustomViewIndex(this.lastTimeRangeFilter.getCustomViewIndex());
            viewPrefs.setRaster(null);
            viewPrefs.setVirtualRaster(this.tableConfig.getDefaultRaster());
        }
        if (viewPrefs.getComplexRaster() == null) {
            viewPrefs.setRaster(ServerDAO.getRawValuesViewRaster((RawValuesViewType)this.lastTimeRangeFilter.getType().toRawValueViewType(), (Integer)this.lastTimeRangeFilter.getCustomViewIndex()));
        } else if (viewPrefs.getComplexRaster().getRaster() != null) {
            Raster minRaster = ServerDAO.getRawValuesViewRaster((RawValuesViewType)this.lastTimeRangeFilter.getType().toRawValueViewType(), (Integer)this.lastTimeRangeFilter.getCustomViewIndex());
            if (viewPrefs.getComplexRaster().getRaster().toMilli() < minRaster.toMilli()) {
                viewPrefs.setRaster(minRaster);
            }
        }
    }

    public Future<?> loadData(final ITimeRangeFilter timeRangeFilter, boolean withProgressIndicator) {
        this.lastTimeRangeFilter = timeRangeFilter;
        if (timeRangeFilter == null) {
            return null;
        }
        Platform.runLater(() -> this.stateProperty().set((Object)UIObjectState.Loading));
        TableViewPrefs viewPrefs = this.getViewPrefs();
        final boolean realtime = timeRangeFilter.getType() == TimeRangeFilterType.RealtimeView;
        final RawValuesViewType viewType = timeRangeFilter.getType().toRawValueViewType();
        final Integer customViewIndex = timeRangeFilter.getCustomViewIndex();
        this.updateViewPrefsRaster((IViewPrefs)viewPrefs);
        final ComplexRaster complexRaster = this.fixedRaster != null ? ComplexRaster.of((VirtualRaster)this.fixedRaster) : (viewPrefs.getComplexRaster() == null ? ComplexRaster.of((Raster)ServerDAO.getRawValuesViewRaster((RawValuesViewType)timeRangeFilter.getType().toRawValueViewType(), (Integer)timeRangeFilter.getCustomViewIndex())) : viewPrefs.getComplexRaster());
        CallableTask<Void> task = new CallableTask<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void call() throws Exception {
                VarTableView varTableView = VarTableView.this;
                synchronized (varTableView) {
                    VarTableView.this.loadDataTask(timeRangeFilter, viewType, customViewIndex, realtime, complexRaster);
                    return null;
                }
            }
        };
        return TaskUtils.executeUITask(null, (CallableTask)task).consumeResult((status, result) -> Platform.runLater(() -> {
            if (status == Worker.State.SUCCEEDED) {
                this.stateProperty().setValue((Object)UIObjectState.Ready);
            } else {
                this.stateProperty().setValue((Object)UIObjectState.Error);
            }
        }));
    }

    private void loadDataTask(ITimeRangeFilter timeRangeFilter, RawValuesViewType viewType, Integer customViewIndex, boolean realtime, ComplexRaster complexRaster) throws Exception {
        HashMap rows = new HashMap();
        if (this.loadDataCallback != null) {
            this.loadDataCallback.loadData(timeRangeFilter);
        }
        HashMap structureObjectCache = new HashMap();
        Transaction trx = Transactions.begin();
        try {
            try {
                Collection<StructureObject> objects;
                VarTableRow row2;
                Instant from = timeRangeFilter.getFrom();
                Instant to = timeRangeFilter.getTo();
                TimeRange viewTimeRange = ServerDAO.getValuesTimeRange((RawValuesViewType)viewType, (Integer)customViewIndex);
                TsInterval viewInterval = viewType == RawValuesViewType.GlobalView ? new TsInterval(from != null ? from.toEpochMilli() : viewTimeRange.getFrom().toEpochMilli(), to != null ? to.toEpochMilli() : viewTimeRange.getTo().toEpochMilli()) : new TsInterval(viewTimeRange.getFrom().toEpochMilli(), viewTimeRange.getTo().toEpochMilli());
                if (this.tableConfig.getType() == TableType.Time && this.tableConfig.getPhasingVariable() != null) {
                    VariableInstance phasingInstance = VariableDAO.findInstances((Transaction)trx, (Variable)this.tableConfig.getPhasingVariable(), (StructureObject)this.structureObject, (SearchPolicy)SearchPolicy.Auto)[0];
                    IVarValuesCollection phasingValues = VariableInstanceDAO.getVarValues((RawValuesViewType)viewType, (Integer)customViewIndex, (VariableInstance)phasingInstance, (Instant)from, (Instant)to);
                    IVarValue prevValue = phasingValues.getFirst();
                    long fromTs = from.toEpochMilli();
                    long toTs = prevValue.getEndTimestamp();
                    double phasingDelta = this.tableConfig.getPhasingDelta();
                    for (IVarValue val : phasingValues) {
                        if (val.equalValue(prevValue, phasingDelta)) {
                            toTs = val.getEndTimestamp();
                            continue;
                        }
                        Instant intervalBegin = Instant.ofEpochMilli(fromTs);
                        Instant intervalEnd = Instant.ofEpochMilli(toTs);
                        row2 = new VarTableRow(intervalBegin, intervalEnd, this.structureObject);
                        rows.put(intervalEnd, row2);
                        fromTs = toTs;
                        toTs = val.getEndTimestamp();
                        prevValue = val;
                    }
                    Instant intervalBegin = Instant.ofEpochMilli(fromTs);
                    Instant intervalEnd = Instant.ofEpochMilli(toTs);
                    VarTableRow row3 = new VarTableRow(intervalBegin, intervalEnd, this.structureObject);
                    rows.put(intervalEnd, row3);
                }
                for (Column column : this.tableConfig.getColumns()) {
                    VariableInstance columnInstance;
                    Variable variable;
                    if (column.getType() == ColumnType.Variable || column.getType() == ColumnType.VariableRole) {
                        VariableInstance columnInstance2;
                        if (column.getType() == ColumnType.Variable) {
                            variable = column.getVariable();
                            columnInstance2 = column.getVariableInstance();
                        } else {
                            variable = VariableRoleDAO.getUniqueVariable((Transaction)trx, (String)column.getVariableRoleId());
                            columnInstance2 = null;
                        }
                        if (variable == null) continue;
                        objects = VarTableView.getColumnObjects(trx, column, this.tableConfig.getObjectSearchPolicy(), this.structureObject);
                        for (StructureObject structureObject : objects) {
                            VariableInstance[] instances;
                            if (this.tableConfig.getType() == TableType.Time) {
                                VariableInstance instance;
                                VariableInstance variableInstance = instance = columnInstance2 != null ? columnInstance2 : VariableInstanceDAO.get((Transaction)trx, (Variable)variable, (StructureObject)structureObject);
                                if (instance == null) continue;
                                instance.setVariable(variable);
                                VarTableView.initTimeVariableRows(this.tableConfig, viewType, customViewIndex, column, structureObject, instance, from, to, complexRaster, realtime, rows);
                                if (!column.getShowAggrValue() || realtime) continue;
                                Aggregation aggr = variable.getResultAggregation();
                                VarTableRow aggrRow = VarTableView.getOrCreateAggrRow(this.tableConfig, this.structureObject, rows, aggr, from, to);
                                IVarValuesCollection aggrValue = VariableInstanceDAO.getVarValues((RawValuesViewType)viewType, (Integer)customViewIndex, (int)instance.getId(), (Instant)from, (Instant)to, (ComplexRaster)ComplexRaster.OVERALL);
                                aggrRow.setColumnValue(column, structureObject, instance, aggrValue.getFirst());
                                continue;
                            }
                            if (this.tableConfig.getType() == TableType.ObjectRangeValues && !realtime) {
                                instances = columnInstance2 != null ? new VariableInstance[]{columnInstance2} : (structureObject.equals((Object)this.structureObject) ? VariableDAO.findInstances((Transaction)trx, (Variable)variable, (StructureObject)structureObject, (SearchPolicy)this.tableConfig.getObjectSearchPolicy()) : VariableDAO.findInstances((Transaction)trx, (Variable)variable, (StructureObject)structureObject));
                                GetValuesRequest getVarValuesRequest = new GetValuesRequest(viewType, customViewIndex, from, to, ComplexRaster.OVERALL);
                                Arrays.stream(instances).forEach(i -> getVarValuesRequest.addInstance(i.getId().intValue(), column.getCustomAggregation()));
                                IVarValuesCollection[] values = VariableInstanceDAO.getVarValues((GetValuesRequest)getVarValuesRequest);
                                int i2 = 0;
                                while (i2 < instances.length) {
                                    VariableInstance instance = instances[i2];
                                    instance.setVariable(variable);
                                    StructureObject instanceObject = (StructureObject)structureObjectCache.get(instance.getStructureObject().getId());
                                    if (instanceObject == null) {
                                        instanceObject = StructureObjectDAO.get((Transaction)trx, (int)instance.getStructureObject().getId());
                                    }
                                    if (instanceObject.getPresenceInterval().getIntersectDuration(viewInterval) > 0L) {
                                        row2 = (VarTableRow)rows.get(instance.getStructureObject());
                                        if (row2 == null) {
                                            row2 = new VarTableRow(from, to, instanceObject);
                                            rows.put((Comparable<?>)instanceObject, row2);
                                        }
                                        row2.setColumnValue(column, structureObject, instance, values[i2].getFirst());
                                    }
                                    ++i2;
                                }
                                if (!column.getShowAggrValue() || values.length <= 0) continue;
                                ArrayList<IVarValue> flatValues = new ArrayList<IVarValue>(values.length);
                                IVarValuesCollection[] iVarValuesCollectionArray = values;
                                int row4 = values.length;
                                int instanceObject = 0;
                                while (instanceObject < row4) {
                                    IVarValuesCollection valArray = iVarValuesCollectionArray[instanceObject];
                                    flatValues.add(valArray.getFirst());
                                    ++instanceObject;
                                }
                                Aggregation aggr = variable.getResultAggregation();
                                if (column.getCustomAggregation() != null) {
                                    aggr = column.getCustomAggregation();
                                }
                                if (column.getCustomAggrRowAggregation() != null) {
                                    aggr = column.getCustomAggrRowAggregation();
                                }
                                VarTableRow aggrRow = VarTableView.getOrCreateAggrRow(this.tableConfig, structureObject, rows, aggr, from, to);
                                IVarValue aggrValue = aggr.aggregateAndConvert(flatValues);
                                aggrRow.setColumnValue(column, this.structureObject, null, aggrValue);
                                continue;
                            }
                            if (this.tableConfig.getType() != TableType.ObjectLastValues) continue;
                            instances = columnInstance2 != null ? new VariableInstance[]{columnInstance2} : (structureObject.equals((Object)this.structureObject) ? VariableDAO.findInstances((Transaction)trx, (Variable)variable, (StructureObject)structureObject, (SearchPolicy)this.tableConfig.getObjectSearchPolicy()) : VariableDAO.findInstances((Transaction)trx, (Variable)variable, (StructureObject)structureObject));
                            SupplementValue[] values = realtime ? VariableInstanceDAO.getLastOriginalSupplementValues((VariableInstance[])instances, (Integer)column.getSupplementValuesSelector()) : VariableInstanceDAO.getOriginalSupplementValues((VariableInstance[])instances, (Integer)column.getSupplementValuesSelector(), (Instant)to);
                            int i3 = 0;
                            while (i3 < instances.length) {
                                VariableInstance instance = instances[i3];
                                instance.setVariable(variable);
                                StructureObject instanceObject = (StructureObject)structureObjectCache.get(instance.getStructureObject().getId());
                                if (instanceObject == null) {
                                    instanceObject = StructureObjectDAO.get((Transaction)trx, (int)instance.getStructureObject().getId());
                                }
                                if (instanceObject.isPresent(Instant.ofEpochMilli(viewInterval.getToTs()))) {
                                    VarTableRow row5 = (VarTableRow)rows.get(instance.getStructureObject());
                                    SupplementValue varValue = values[i3];
                                    if (varValue == null) {
                                        varValue = realtime ? VariableInstanceDAO.getCurrentValues((RawValuesViewType)viewType, (Integer)customViewIndex, (VariableInstance[])new VariableInstance[]{instance})[0] : VariableInstanceDAO.getVarValue((RawValuesViewType)viewType, (Integer)customViewIndex, (int)instance.getId(), (Instant)to);
                                    }
                                    if (row5 == null) {
                                        row5 = new VarTableRow(null, Instant.ofEpochMilli(varValue.getEndTimestamp()), instanceObject);
                                        rows.put((Comparable<?>)instanceObject, row5);
                                    }
                                    row5.setColumnValue(column, structureObject, instance, varValue);
                                }
                                ++i3;
                            }
                        }
                        continue;
                    }
                    if (column.getType() != ColumnType.AssignedText || this.tableConfig.getType() != TableType.Time) continue;
                    if (column.getVariable() != null) {
                        variable = column.getVariable();
                        columnInstance = column.getVariableInstance();
                    } else {
                        variable = VariableRoleDAO.getUniqueVariable((Transaction)trx, (String)column.getVariableRoleId());
                        columnInstance = null;
                    }
                    if (variable == null) continue;
                    objects = VarTableView.getColumnObjects(trx, column, this.tableConfig.getObjectSearchPolicy(), this.structureObject);
                    for (StructureObject structureObject : objects) {
                        VariableInstance instance;
                        VariableInstance variableInstance = instance = columnInstance != null ? columnInstance : VariableInstanceDAO.get((Transaction)trx, (Variable)variable, (StructureObject)structureObject);
                        if (instance == null) continue;
                        instance.setVariable(variable);
                        VarTableView.initTimeIntervalTextRows(column, viewType, customViewIndex, structureObject, instance, from, to, complexRaster, rows);
                    }
                }
                VarTableView.processCustomDataColumns(this.tableConfig, this.structureObject, trx, rows, complexRaster, viewType, customViewIndex, realtime, complexRaster, from, to, (Callback<Column, LoadCustomColumnDataCallback>)((Callback)c -> this.getOnLoadCustomColumnDataCallback((Column)c)));
                VarTableView.processCalculatedColumns(this.tableConfig, this.structureObject, trx, rows, complexRaster, viewType, customViewIndex, realtime, complexRaster, from, to);
                List<VarTableRow> allRows = this.appendSummaryRows(rows, complexRaster, viewType, customViewIndex, realtime, complexRaster, from, to);
                List sortedCellStyleColumns = this.tableConfig.getColumns().stream().filter(c -> c.getCellStyleClassExpression() != null && !c.getCellStyleClassExpression().isEmpty()).sorted((c1, c2) -> {
                    FormulaNode c1Node = ScriptParser.parseFormula((String)c1.getCellStyleClassExpression());
                    FormulaNode c2Node = ScriptParser.parseFormula((String)c2.getCellStyleClassExpression());
                    if (!c2.isKeyEmpty() && c1Node.containsParameter(c2.getKey())) {
                        return 1;
                    }
                    if (!c1.isKeyEmpty() && c2Node.containsParameter(c1.getKey())) {
                        return -1;
                    }
                    return 0;
                }).collect(Collectors.toList());
                for (Column column : sortedCellStyleColumns) {
                    objects = VarTableView.getColumnObjects(trx, column, this.tableConfig.getObjectSearchPolicy(), this.structureObject);
                    FormulaNode formulaNode = ScriptParser.parseFormula((String)column.getCellStyleClassExpression());
                    for (StructureObject structureObject : objects) {
                        for (VarTableRow row6 : allRows) {
                            VarTableCellData cellData;
                            Object valObj = VarTableView.evaluate(formulaNode, row6, structureObject);
                            LinkedHashSet<String> styleClasses = new LinkedHashSet<String>();
                            if (valObj instanceof String) {
                                String[] parts;
                                String[] stringArray = parts = ((String)valObj).replace(',', ' ').split(" ");
                                int n = parts.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String part = stringArray[n2];
                                    styleClasses.add(part.trim());
                                    ++n2;
                                }
                            }
                            if ((cellData = row6.getColumnValue(column, structureObject)) == null) continue;
                            for (String styleClass : styleClasses) {
                                cellData.addCellStyleClass(styleClass);
                            }
                        }
                    }
                }
                allRows.stream().forEach(row -> row.setCellEditCallback(this.cellEditCallback));
                this.rows.setAll(allRows);
            }
            catch (Exception exc) {
                this.rows.clear();
                throw exc;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
    }

    private static void processCustomDataColumns(Table tableConfig, StructureObject forObject, Transaction trx, Map<Comparable<?>, VarTableRow> rows, ComplexRaster complexRaste, RawValuesViewType viewType, Integer customViewIndex, boolean realtime, ComplexRaster complexRaster, Instant from, Instant to, Callback<Column, LoadCustomColumnDataCallback> getCallback) {
        for (Column column : tableConfig.getColumns()) {
            LoadCustomColumnDataCallback loadDataCallback;
            if (column.getType() != ColumnType.CustomData || (loadDataCallback = (LoadCustomColumnDataCallback)getCallback.call((Object)column)) == null) continue;
            for (Map.Entry<Comparable<?>, ?> entry : loadDataCallback.loadData(forObject, column, from, to, complexRaster, realtime).entrySet()) {
                Comparable<?> rowKey = entry.getKey();
                Object value = entry.getValue();
                StructureObject rowObject = rowKey instanceof StructureObject ? (StructureObject)rowKey : forObject;
                VarTableRow row = rows.get(rowKey);
                if (row == null) {
                    Instant fromTs = null;
                    Instant toTs = null;
                    if (tableConfig.getType() == TableType.Time) {
                        if (value instanceof IVarValue) {
                            IVarValue varValue = (IVarValue)value;
                            if (complexRaster.getRaster() != null) {
                                toTs = Instant.ofEpochMilli(complexRaster.getRaster().getRasterEnd(varValue.getEndTimestamp()));
                                fromTs = toTs.minusMillis(complexRaster.getRaster().toMilli());
                            } else if (complexRaster.getVirtualRaster() != VirtualRaster.Overall) {
                                toTs = complexRaster.getVirtualRaster().getRasterEnd(Instant.ofEpochMilli(varValue.getEndTimestamp()));
                                fromTs = complexRaster.getVirtualRaster().getRasterBegin(toTs);
                            } else {
                                fromTs = from;
                                toTs = to;
                            }
                        }
                    } else if (tableConfig.getType() == TableType.ObjectRangeValues) {
                        fromTs = from;
                        toTs = to;
                    }
                    row = new VarTableRow(fromTs, toTs, rowObject);
                    rows.put(rowKey, row);
                }
                row.setColumnValue(column, forObject, null, value);
            }
        }
    }

    private static void processCalculatedColumns(Table tableConfig, StructureObject forObject, Transaction trx, Map<Comparable<?>, VarTableRow> rows, ComplexRaster complexRaste, RawValuesViewType viewType, Integer customViewIndex, boolean realtime, ComplexRaster complexRaster, Instant from, Instant to) {
        List sortedCalcColumns = tableConfig.getColumns().stream().filter(c -> c.getType() == ColumnType.Calculated).sorted((c1, c2) -> {
            FormulaNode c1Node = ScriptParser.parseFormula((String)c1.getCalculationFormula());
            FormulaNode c2Node = ScriptParser.parseFormula((String)c2.getCalculationFormula());
            if (!c2.isKeyEmpty() && (c1Node == null || c1Node.containsParameter(c2.getKey()))) {
                return 1;
            }
            if (!c1.isKeyEmpty() && (c2Node == null || c2Node.containsParameter(c1.getKey()))) {
                return -1;
            }
            return 0;
        }).collect(Collectors.toList());
        for (Column column : sortedCalcColumns) {
            Collection<StructureObject> objects = VarTableView.getColumnObjects(trx, column, tableConfig.getObjectSearchPolicy(), forObject);
            FormulaNode formulaNode = ScriptParser.parseFormula((String)column.getCalculationFormula());
            for (StructureObject structureObject : objects) {
                VariableInstance ownInstance = null;
                if (!column.isKeyEmpty() && column.getVariable() != null) {
                    Variable variable = column.getVariable();
                    if (tableConfig.getType() == TableType.ObjectRangeValues) {
                        for (VarTableRow row : rows.values()) {
                            if (row.isSummary()) continue;
                            StructureObject rowObject = row.getStructureObject();
                            if (column.getVariableInstance() != null) {
                                ownInstance = column.getVariableInstance();
                            } else {
                                VariableInstance[] instances = VariableDAO.findInstances((Transaction)trx, (Variable)variable, (StructureObject)rowObject, (SearchPolicy)SearchPolicy.ThisOrParent);
                                if (instances.length == 1) {
                                    ownInstance = instances[0];
                                }
                            }
                            if (ownInstance == null) continue;
                            ownInstance.setVariable(variable);
                            IVarValuesCollection val = VariableInstanceDAO.getVarValues((RawValuesViewType)viewType, (Integer)customViewIndex, (VariableInstance)ownInstance, (Instant)row.getIntervalBegin(), (Instant)row.getIntervalEnd(), (ComplexRaster)ComplexRaster.of((VirtualRaster)VirtualRaster.Overall));
                            row.setColumnValue(column, structureObject, ownInstance, val.getFirst());
                        }
                    } else if (tableConfig.getType() == TableType.Time) {
                        if (column.getVariableInstance() != null) {
                            ownInstance = column.getVariableInstance();
                        } else {
                            instances = VariableDAO.findInstances((Transaction)trx, (Variable)variable, (StructureObject)structureObject, (SearchPolicy)SearchPolicy.ThisOrParent);
                            if (instances.length == 1) {
                                ownInstance = instances[0];
                            }
                        }
                        if (ownInstance != null) {
                            ownInstance.setVariable(variable);
                            VarTableView.initTimeVariableRows(tableConfig, viewType, customViewIndex, column, structureObject, ownInstance, from, to, complexRaster, realtime, rows);
                        }
                    } else if (tableConfig.getType() == TableType.ObjectLastValues) {
                        instances = column.getVariableInstance() != null ? new VariableInstance[]{column.getVariableInstance()} : (structureObject.equals((Object)forObject) ? VariableDAO.findInstances((Transaction)trx, (Variable)variable, (StructureObject)structureObject, (SearchPolicy)tableConfig.getObjectSearchPolicy()) : VariableDAO.findInstances((Transaction)trx, (Variable)variable, (StructureObject)structureObject));
                        IVarValue[] values = VariableInstanceDAO.getCurrentValues((RawValuesViewType)viewType, (Integer)customViewIndex, (VariableInstance[])instances);
                        int i = 0;
                        while (i < instances.length) {
                            VariableInstance instance = instances[i];
                            instance.setVariable(variable);
                            VarTableRow row = rows.get(instance.getStructureObject());
                            IVarValue varValue = values[i];
                            if (row == null) {
                                StructureObject rowObject = StructureObjectDAO.get((Transaction)trx, (int)instance.getStructureObject().getId());
                                row = new VarTableRow(null, Instant.ofEpochMilli(varValue.getEndTimestamp()), rowObject);
                                rows.put((Comparable<?>)rowObject, row);
                            }
                            row.setColumnValue(column, structureObject, instance, varValue);
                            ++i;
                        }
                    }
                }
                ArrayList<IVarValue> calcVarValues = new ArrayList<IVarValue>(rows.size());
                for (VarTableRow row : rows.values()) {
                    if (row.isSummary()) continue;
                    Object valObj = VarTableView.evaluate(formulaNode, row, structureObject);
                    Object value = valObj instanceof Double ? new VarValue(row.getIntervalEnd().toEpochMilli(), ((Double)valObj).doubleValue(), 1.0, ValueSource.Calculated) : (valObj instanceof String ? valObj : new VarValue(row.getIntervalEnd().toEpochMilli(), Double.NaN, -1.0, ValueSource.Calculated));
                    if (value instanceof IVarValue) {
                        calcVarValues.add((IVarValue)value);
                    }
                    row.setColumnValue(column, structureObject, null, value);
                }
                if (!column.getShowAggrValue() || calcVarValues.isEmpty()) continue;
                Aggregation aggr = column.getCalculationPhysicalUnit().getAggregation();
                if (column.getCustomAggregation() != null) {
                    aggr = column.getCustomAggregation();
                }
                if (column.getCustomAggrRowAggregation() != null) {
                    aggr = column.getCustomAggrRowAggregation();
                }
                VarTableRow aggrRow = VarTableView.getOrCreateAggrRow(tableConfig, forObject, rows, aggr, from, to);
                IVarValue aggrValue = aggr.aggregateAndConvert(calcVarValues);
                aggrRow.setColumnValue(column, forObject, null, aggrValue);
            }
        }
    }

    private List<VarTableRow> appendSummaryRows(Map<Comparable<?>, VarTableRow> rows, ComplexRaster complexRaste, RawValuesViewType viewType, Integer customViewIndex, boolean realtime, ComplexRaster complexRaster, Instant from, Instant to) {
        TreeMap sortedRows = new TreeMap(ROW_COMPARATOR);
        rows.entrySet().stream().forEach(e -> {
            VarTableRow varTableRow = sortedRows.put((Comparable)e.getKey(), (VarTableRow)e.getValue());
        });
        ArrayList<VarTableRow> allRows = new ArrayList<VarTableRow>(sortedRows.values());
        for (Column column : this.tableConfig.getColumns()) {
            LocalDateTime localDt;
            String label;
            Instant ts;
            if (column.getType() == ColumnType.ObjectName) {
                for (VarTableRow row : allRows) {
                    if (row.isSummary()) continue;
                    row.setColumnValue(column, this.structureObject, null, row.getStructureObject());
                }
                continue;
            }
            if (column.getType() == ColumnType.TimeBegin || column.getType() == ColumnType.TimeEnd) {
                for (VarTableRow row : allRows) {
                    if (row.isSummary()) continue;
                    ts = column.getType() == ColumnType.TimeBegin ? row.getIntervalBegin() : row.getIntervalEnd().minusNanos(1L);
                    label = null;
                    localDt = LocalDateTime.ofInstant(ts, ZoneId.systemDefault());
                    label = column.getTimeColumnFormat() != null ? column.getTimeColumnFormat().format((TemporalAccessor)localDt) : (!realtime && complexRaster.getVirtualRaster() != null ? (complexRaster.getVirtualRaster() != VirtualRaster.Overall ? complexRaster.getVirtualRaster().getLabel(ts) : "") : TimeFormatType.DateTimeHMs.format((TemporalAccessor)localDt));
                    row.setColumnValue(column, this.structureObject, null, label);
                }
                continue;
            }
            if (column.getType() == ColumnType.TimeInterval) {
                for (VarTableRow row : allRows) {
                    if (row.isSummary()) continue;
                    long seconds = Duration.between(row.getIntervalBegin(), row.getIntervalEnd()).getSeconds();
                    double value = column.getMeasuringUnit() != null && column.getMeasuringUnit().getPhysicalUnit() == PhysicalUnits.TIME ? column.getMeasuringUnit().convert((double)seconds, (MeasuringUnit)Second.INSTANCE) : (double)seconds;
                    row.setColumnValue(column, this.structureObject, null, Math.round(value));
                }
                continue;
            }
            if (column.getType() == ColumnType.VirtualZoneTimeID) {
                for (VarTableRow row : allRows) {
                    if (row.isSummary()) continue;
                    ts = complexRaster.getVirtualRaster() != null && complexRaster.getVirtualRaster() != null && complexRaster.getVirtualRaster().ordinal() > VirtualRaster.Hour.ordinal() ? row.getIntervalBegin() : row.getIntervalEnd();
                    localDt = LocalDateTime.ofInstant(ts, ZoneId.systemDefault());
                    label = !realtime && complexRaster.getVirtualRaster() != null ? (complexRaster.getVirtualRaster() != VirtualRaster.Overall ? complexRaster.getVirtualRaster().getLabel(ts) : "") : TimeFormatType.DateTimeHMs.format((TemporalAccessor)localDt);
                    row.setColumnValue(column, this.structureObject, null, label);
                }
                continue;
            }
            if (column.getType() != ColumnType.TimeRange) continue;
            for (VarTableRow row : allRows) {
                if (row.isSummary()) continue;
                Instant tsBegin = row.getIntervalBegin();
                Instant tsEnd = row.getIntervalEnd().minusNanos(1L);
                String label2 = null;
                LocalDateTime localDtBegin = LocalDateTime.ofInstant(tsBegin, ZoneId.systemDefault());
                LocalDateTime localDtEnd = LocalDateTime.ofInstant(tsEnd, ZoneId.systemDefault());
                label2 = column.getTimeColumnFormat() != null ? String.format("%s - %s", column.getTimeColumnFormat().format((TemporalAccessor)localDtBegin), column.getTimeColumnFormat().format((TemporalAccessor)localDtEnd)) : (!realtime && complexRaster.getVirtualRaster() != null && complexRaster.getVirtualRaster() != VirtualRaster.Overall ? String.format("%s - %s", complexRaster.getVirtualRaster().getLabel(tsBegin), complexRaster.getVirtualRaster().getLabel(tsEnd)) : String.format("%s - %s", TimeFormatType.DateTimeHMs.format((TemporalAccessor)localDtBegin), TimeFormatType.DateTimeHMs.format((TemporalAccessor)localDtEnd)));
                row.setColumnValue(column, this.structureObject, null, label2);
            }
        }
        return allRows;
    }

    private static VarTableRow getOrCreateAggrRow(Table tableConfig, StructureObject forObject, Map<Comparable<?>, VarTableRow> rows, Aggregation aggr, Instant from, Instant to) {
        VarTableRow aggrRow = rows.get(aggr);
        if (aggrRow == null) {
            aggrRow = new VarTableRow(from, to, forObject, true);
            rows.put((Comparable<?>)aggr, aggrRow);
            if (tableConfig.getAggrLabelColumn() != null) {
                aggrRow.setColumnValue(tableConfig.getAggrLabelColumn(), forObject, null, aggr);
            }
        }
        return aggrRow;
    }

    private static void initTimeVariableRows(Table tableConfig, RawValuesViewType viewType, Integer customViewIndex, Column column, StructureObject structureObject, VariableInstance instance, Instant from, Instant to, ComplexRaster complexRaster, boolean realtime, Map<Comparable<?>, VarTableRow> timeRows) {
        if (tableConfig.getPhasingVariable() == null) {
            if (realtime) {
                from = null;
                to = null;
            }
            IVarValuesCollection values = column.getRaster2() == null || column.getCustomAggregationFromRaster2() == null ? VariableInstanceDAO.getVarValues((RawValuesViewType)viewType, (Integer)customViewIndex, (int)instance.getId(), (Instant)from, (Instant)to, (ComplexRaster)complexRaster, (Aggregation)column.getCustomAggregation()) : VariableInstanceDAO.getVarValuesWithTwoStepAggregation((RawValuesViewType)viewType, (Integer)customViewIndex, (int)instance.getId(), (Instant)from, (Instant)to, (ComplexRaster)complexRaster, (Aggregation)column.getCustomAggregation(), (Raster)column.getRaster2(), (Aggregation)column.getCustomAggregationFromRaster2());
            for (IVarValue value : values) {
                VarTableRow row;
                Instant beginTs;
                Instant endTs;
                if (complexRaster.getRaster() != null) {
                    endTs = Instant.ofEpochMilli(complexRaster.getRaster().getRasterEnd(value.getEndTimestamp()));
                    beginTs = endTs.minusMillis(complexRaster.getRaster().toMilli());
                } else if (complexRaster != ComplexRaster.OVERALL) {
                    endTs = complexRaster.getRasterEnd(Instant.ofEpochMilli(value.getEndTimestamp()));
                    beginTs = complexRaster.getRasterBegin(endTs);
                } else {
                    beginTs = from;
                    endTs = to;
                }
                if (!realtime) {
                    if (to != null && endTs.isAfter(to)) {
                        endTs = to;
                    }
                    if (from != null && beginTs.isBefore(from)) {
                        beginTs = from;
                    }
                }
                if ((row = timeRows.get(endTs)) == null) {
                    row = new VarTableRow(beginTs, endTs, structureObject);
                    timeRows.put(endTs, row);
                }
                row.setColumnValue(column, structureObject, instance, value);
            }
        } else {
            for (VarTableRow row : timeRows.values()) {
                IVarValuesCollection val = VariableInstanceDAO.getVarValues((RawValuesViewType)viewType, (Integer)customViewIndex, (VariableInstance)instance, (Instant)row.getIntervalBegin(), (Instant)row.getIntervalEnd(), (ComplexRaster)ComplexRaster.of((VirtualRaster)VirtualRaster.Overall), (Aggregation)column.getCustomAggregation());
                row.setColumnValue(column, structureObject, instance, val.getFirst());
            }
        }
    }

    private static void initTimeIntervalTextRows(Column column, RawValuesViewType viewType, Integer customViewIndex, StructureObject structureObject, VariableInstance instance, Instant from, Instant to, ComplexRaster complexRaster, Map<Comparable<?>, VarTableRow> timeRows) {
        if (timeRows.isEmpty()) {
            IVarValuesCollection rowValues = VariableInstanceDAO.getVarValues((RawValuesViewType)viewType, (Integer)customViewIndex, (int)instance.getId(), (Instant)from, (Instant)to, (ComplexRaster)complexRaster, (Aggregation)column.getCustomAggregation());
            for (IVarValue rowValue : rowValues) {
                VarTableRow row;
                Instant beginTs;
                Instant endTs;
                if (complexRaster.getRaster() != null) {
                    endTs = Instant.ofEpochMilli(complexRaster.getRaster().getRasterEnd(rowValue.getEndTimestamp()));
                    beginTs = endTs.minusMillis(complexRaster.getRaster().toMilli());
                } else if (complexRaster != ComplexRaster.OVERALL) {
                    endTs = complexRaster.getRasterEnd(Instant.ofEpochMilli(rowValue.getEndTimestamp()));
                    beginTs = complexRaster.getRasterBegin(endTs);
                } else {
                    beginTs = from;
                    endTs = to;
                }
                if (viewType != RawValuesViewType.RealtimeView) {
                    if (to != null && endTs.isAfter(to)) {
                        endTs = to;
                    }
                    if (from != null && beginTs.isBefore(from)) {
                        beginTs = from;
                    }
                }
                if ((row = timeRows.get(endTs)) != null) continue;
                row = new VarTableRow(beginTs, endTs, structureObject);
                timeRows.put(endTs, row);
            }
        }
        TimeIntervalStringValueCollection values = VariableInstanceDAO.getTimeIntervalStringValues((Instant)from, (Instant)to, (VariableInstance[])new VariableInstance[]{instance})[0];
        TreeMap<Long, TimeIntervalStringValue> fromOrientedValues = new TreeMap<Long, TimeIntervalStringValue>();
        for (TimeIntervalStringValue value : values) {
            fromOrientedValues.put(value.getFromTs(), value);
        }
        for (VarTableRow row : timeRows.values()) {
            TimeIntervalStringValue value;
            if (row.isSummary()) continue;
            Map.Entry entry = fromOrientedValues.floorEntry(row.getIntervalBegin().toEpochMilli());
            TimeIntervalStringValue timeIntervalStringValue = value = entry != null ? (TimeIntervalStringValue)entry.getValue() : null;
            if (value == null || value.getToTs() <= row.getIntervalBegin().toEpochMilli()) {
                entry = fromOrientedValues.ceilingEntry(row.getIntervalBegin().toEpochMilli());
                value = entry != null ? (TimeIntervalStringValue)entry.getValue() : null;
            }
            ArrayList<TimeIntervalStringValue> cellValues = new ArrayList<TimeIntervalStringValue>();
            while (value != null && value.getFromTs() < row.getIntervalEnd().toEpochMilli() && value.getToTs() > row.getIntervalBegin().toEpochMilli()) {
                if (value.getValue() != null) {
                    cellValues.add(value);
                }
                TimeIntervalStringValue timeIntervalStringValue2 = value = (entry = fromOrientedValues.ceilingEntry(value.getFromTs() + 1L)) != null ? (TimeIntervalStringValue)entry.getValue() : null;
            }
            row.setColumnValue(column, structureObject, instance, cellValues.toArray(TimeIntervalStringValue[]::new));
        }
    }

    private static Collection<StructureObject> getColumnObjects(Transaction trx, Column column, SearchPolicy searchPolicy, StructureObject forObject) {
        LinkedList<StructureObject> objects = new LinkedList<StructureObject>();
        StructureClass objectsClass = null;
        ColumnGroup columnGroup = column.getColumnGroup();
        while (columnGroup != null) {
            if (columnGroup.getObjectClass() != null) {
                objectsClass = columnGroup.getObjectClass();
                if (columnGroup.getObjectSearchPolicy() == null) break;
                searchPolicy = columnGroup.getObjectSearchPolicy();
                break;
            }
            columnGroup = columnGroup.getParentGroup();
        }
        if (objectsClass == null) {
            objects.add(forObject);
        } else {
            objects.addAll(Arrays.asList(StructureObjectDAO.findObjects((Transaction)trx, (StructureObject)forObject, (StructureClass)objectsClass, (SearchPolicy)searchPolicy)));
        }
        return objects;
    }

    private static Object evaluate(FormulaNode node, VarTableRow row, StructureObject structureObject) {
        if (node == null) {
            return null;
        }
        switch (node.getType()) {
            case Constant: {
                return node.getNodeObject();
            }
            case Parameter: {
                String columnKey = (String)node.getNodeObject();
                VarTableCellData data = row.getColumnValue(columnKey, structureObject);
                if (data == null) {
                    VarTableCellData[] cells = row.getColumnValues(columnKey);
                    double[] vals = Arrays.stream(cells).filter(c -> c.getVarValue() != null && c.getVarValue().isValid()).mapToDouble(c -> c.getVarValue().getValue()).toArray();
                    return vals;
                }
                IVarValue value = data.getVarValue();
                return value != null && value.isValid() ? Double.valueOf(value.getValue()) : null;
            }
            case Text: {
                String text = (String)node.getNodeObject();
                return text;
            }
            case Operation: {
                int n;
                int n2;
                Object[] objectArray;
                FormulaOperation operation = (FormulaOperation)node.getNodeObject();
                if (operation == FormulaOperation.Map) {
                    int size = node.getParameters().size();
                    if (size <= 3) {
                        return null;
                    }
                    Object arg = VarTableView.evaluate((FormulaNode)node.getParameters().get(0), row, structureObject);
                    if (arg == null) {
                        return null;
                    }
                    int i = 1;
                    while (i < node.getParameters().size()) {
                        if (size <= i + 1) {
                            return null;
                        }
                        Object testValue = VarTableView.evaluate((FormulaNode)node.getParameters().get(i), row, structureObject);
                        if (arg instanceof Double && testValue instanceof Double && Double.compare((Double)arg, (Double)testValue) == 0) {
                            return VarTableView.evaluate((FormulaNode)node.getParameters().get(i + 1), row, structureObject);
                        }
                        if (arg instanceof String && testValue instanceof String && ((String)arg).equals(testValue)) {
                            return VarTableView.evaluate((FormulaNode)node.getParameters().get(i + 1), row, structureObject);
                        }
                        i += 2;
                    }
                    return null;
                }
                int expectedParamsLength = node.getParameters().size();
                ArrayList<Object> paramsList = new ArrayList<Object>(expectedParamsLength);
                int i = 0;
                while (i < expectedParamsLength) {
                    Object valObj = VarTableView.evaluate((FormulaNode)node.getParameters().get(i), row, structureObject);
                    if (valObj == null) {
                        return null;
                    }
                    if (valObj instanceof double[]) {
                        double[] vals = (double[])valObj;
                        objectArray = vals;
                        n2 = vals.length;
                        n = 0;
                        while (n < n2) {
                            Object val = objectArray[n];
                            paramsList.add(Double.valueOf(val));
                            ++n;
                        }
                    } else {
                        paramsList.add(valObj);
                    }
                    ++i;
                }
                T[] params = paramsList.toArray(Object[]::new);
                double result = 0.0;
                switch (operation) {
                    case Abs: {
                        if (params.length != 1 || !(params[0] instanceof Double)) {
                            return false;
                        }
                        return Math.abs((Double)params[0]);
                    }
                    case Div: {
                        if (params.length != 2 || !(params[0] instanceof Double) || !(params[1] instanceof Double)) {
                            return false;
                        }
                        return (Double)params[0] / (Double)params[1];
                    }
                    case Mult: {
                        int count = 0;
                        result = 1.0;
                        objectArray = params;
                        n2 = params.length;
                        n = 0;
                        while (n < n2) {
                            Object paramObj = objectArray[n];
                            if (paramObj instanceof Double) {
                                result *= ((Double)paramObj).doubleValue();
                                ++count;
                            }
                            ++n;
                        }
                        if (count > 0) {
                            return result;
                        }
                        return null;
                    }
                    case Min: {
                        int count = 0;
                        result = Double.POSITIVE_INFINITY;
                        objectArray = params;
                        n2 = params.length;
                        n = 0;
                        while (n < n2) {
                            Object paramObj = objectArray[n];
                            if (paramObj instanceof Double) {
                                result = Math.min(result, (Double)paramObj);
                                ++count;
                            }
                            ++n;
                        }
                        if (count > 0) {
                            return result;
                        }
                        return null;
                    }
                    case Max: {
                        int count = 0;
                        result = Double.NEGATIVE_INFINITY;
                        objectArray = params;
                        n2 = params.length;
                        n = 0;
                        while (n < n2) {
                            Object paramObj = objectArray[n];
                            if (paramObj instanceof Double) {
                                result = Math.max(result, (Double)paramObj);
                                ++count;
                            }
                            ++n;
                        }
                        if (count > 0) {
                            return result;
                        }
                        return null;
                    }
                    case Avg: 
                    case Average: {
                        int count = 0;
                        result = 0.0;
                        objectArray = params;
                        n2 = params.length;
                        n = 0;
                        while (n < n2) {
                            Object paramObj = objectArray[n];
                            if (paramObj instanceof Double) {
                                result += ((Double)paramObj).doubleValue();
                                ++count;
                            }
                            ++n;
                        }
                        if (count > 0) {
                            return result / (double)count;
                        }
                        return null;
                    }
                    case Sum: {
                        int count = 0;
                        result = 0.0;
                        objectArray = params;
                        n2 = params.length;
                        n = 0;
                        while (n < n2) {
                            Object paramObj = objectArray[n];
                            if (paramObj instanceof Double) {
                                result += ((Double)paramObj).doubleValue();
                                ++count;
                            }
                            ++n;
                        }
                        if (count > 0) {
                            return result;
                        }
                        return null;
                    }
                    case Diff: {
                        int i2 = 0;
                        while (i2 < params.length) {
                            if (!(params[i2] instanceof Double)) {
                                return null;
                            }
                            result = i2 == 0 ? (Double)params[i2] : (result -= ((Double)params[i2]).doubleValue());
                            ++i2;
                        }
                        return result;
                    }
                    case Eq: {
                        boolean eq = true;
                        Object prevValue = params[0];
                        int i3 = 1;
                        while (i3 < params.length) {
                            Object nextValue = params[i3];
                            if (prevValue instanceof Double && nextValue instanceof Double) {
                                eq &= Double.compare((Double)prevValue, (Double)nextValue) == 0;
                            } else if (prevValue instanceof String && nextValue instanceof String) {
                                eq &= ((String)prevValue).equals(nextValue);
                            } else {
                                return null;
                            }
                            ++i3;
                        }
                        return eq ? 1.0 : 0.0;
                    }
                    case NotEq: {
                        if (params.length != 2 || !(params[0] instanceof Double) || !(params[1] instanceof Double)) {
                            return null;
                        }
                        return ((Double)params[0]).doubleValue() != ((Double)params[1]).doubleValue() ? 1.0 : 0.0;
                    }
                    case And: {
                        boolean and = true;
                        int i4 = 0;
                        while (i4 < params.length) {
                            Object oValue = params[i4];
                            if (oValue instanceof Double) {
                                and &= (Double)oValue != 0.0;
                            } else {
                                return null;
                            }
                            ++i4;
                        }
                        return and ? 1.0 : 0.0;
                    }
                    case Or: {
                        boolean or = true;
                        int i5 = 0;
                        while (i5 < params.length) {
                            Object oValue = params[i5];
                            if (oValue instanceof Double) {
                                or |= (Double)oValue != 0.0;
                            } else {
                                return null;
                            }
                            ++i5;
                        }
                        return or ? 1.0 : 0.0;
                    }
                    case Not: {
                        if (params.length != 1 || !(params[0] instanceof Double)) {
                            return null;
                        }
                        return (Double)params[0] == 0.0 ? 1.0 : 0.0;
                    }
                    case If: {
                        if (params.length != 3 || !(params[0] instanceof Double)) {
                            return null;
                        }
                        return (Double)params[0] != 0.0 ? params[1] : params[2];
                    }
                    case Gt: {
                        if (params.length != 2 || !(params[0] instanceof Double) || !(params[1] instanceof Double)) {
                            return null;
                        }
                        return (Double)params[0] > (Double)params[1] ? 1.0 : 0.0;
                    }
                    case Ge: {
                        if (params.length != 2 || !(params[0] instanceof Double) || !(params[1] instanceof Double)) {
                            return null;
                        }
                        return (Double)params[0] >= (Double)params[1] ? 1.0 : 0.0;
                    }
                    case Lt: {
                        if (params.length != 2 || !(params[0] instanceof Double) || !(params[1] instanceof Double)) {
                            return null;
                        }
                        return (Double)params[0] < (Double)params[1] ? 1.0 : 0.0;
                    }
                    case Le: {
                        if (params.length != 2 || !(params[0] instanceof Double) || !(params[1] instanceof Double)) {
                            return null;
                        }
                        return (Double)params[0] <= (Double)params[1] ? 1.0 : 0.0;
                    }
                    case BitAnd: {
                        if (params.length != 2 || !(params[0] instanceof Double) || !(params[1] instanceof Double)) {
                            return null;
                        }
                        long p1 = ((Double)params[0]).longValue();
                        long mask = ((Double)params[1]).longValue();
                        long res = p1 & mask;
                        return (double)res;
                    }
                    case BitOr: {
                        if (params.length != 2 || !(params[0] instanceof Double) || !(params[1] instanceof Double)) {
                            return null;
                        }
                        long p1 = ((Double)params[0]).longValue();
                        long mask = ((Double)params[1]).longValue();
                        return (double)(p1 | mask);
                    }
                }
                return null;
            }
        }
        return null;
    }

    public ObservableList<VarTableRow> getRows() {
        return this.rows;
    }

    public List<SupplementValueChange> getSupplementValueChanges() {
        List changes = this.columnSupplementValuesChanges.values().stream().reduce((l1, l2) -> {
            ArrayList r = new ArrayList(l1);
            r.addAll(l2);
            return r;
        }).orElse(new ArrayList());
        return changes;
    }

    public Map<Column, List<SupplementValueChange>> getColumnSupplementValueChanges() {
        return this.columnSupplementValuesChanges;
    }

    public void saveChanges(Instant unrasterizedValuesTs, boolean overwriteLaterUnrasterizedValues) throws DAOOperationException {
        VariableInstanceTimeIntervalStringValues[] distinctTimeIntervalValuesChanges;
        List<SupplementValueChange> supplementValuesChanges = this.getSupplementValueChanges();
        for (SupplementValueChange svc : supplementValuesChanges) {
            if (!svc.isUnrasterizedValue()) continue;
            svc.setUnrasterizedTs(unrasterizedValuesTs);
        }
        if (!supplementValuesChanges.isEmpty()) {
            VariableInstanceDAO.applySupplementValuesChanges((SupplementValueChange[])supplementValuesChanges.toArray(new SupplementValueChange[0]), (boolean)overwriteLaterUnrasterizedValues);
        }
        if ((distinctTimeIntervalValuesChanges = VariableInstanceTimeIntervalStringValues.disctinctChanges(this.timeIntervalValuesChanges)) != null && distinctTimeIntervalValuesChanges.length > 0) {
            VariableInstanceDAO.applyTimeIntervalValuesChanges((VariableInstanceTimeIntervalStringValues[])distinctTimeIntervalValuesChanges);
        }
        this.resetChanges();
    }

    public void resetChanges() {
        this.columnSupplementValuesChanges.clear();
        this.timeIntervalValuesChanges.clear();
        this.hasChanges.set(false);
    }

    public void restoreColumnsPersistedState() {
        this.initialState.restoreColumnsState(this.getReportObject().getColumns());
    }

    public ObservableBooleanValue hasChangesProperty() {
        return this.hasChanges;
    }

    public boolean hasChanges() {
        return this.hasChanges.get();
    }

    @Override
    public UIObjectState getState() {
        return (UIObjectState)((Object)this.state.get());
    }

    @Override
    public SimpleObjectProperty<UIObjectState> stateProperty() {
        return this.state;
    }

    @Override
    public ReadOnlyProperty<IDataSelection> dataSelectionProperty() {
        return this.dataSelection;
    }

    @Override
    public void selectData(Instant atTimestamp, Object o) {
        if (atTimestamp == null) {
            return;
        }
        if (this.dataSelection.getValue() != null && atTimestamp.equals(((IDataSelection)this.dataSelection.getValue()).getEndTimestamp())) {
            return;
        }
        TableView<?> table = this.getReportObject();
        for (VarTableRow row : table.getItems()) {
            if (row.getIntervalBegin() == null || row.getIntervalEnd() == null || !atTimestamp.isAfter(row.getIntervalBegin()) || row.getIntervalEnd().isBefore(atTimestamp)) continue;
            this.dataSelection.setValue((Object)new DataSelection(atTimestamp, null));
            table.getSelectionModel().select((Object)row);
            table.scrollTo(Math.max(0, table.getItems().indexOf((Object)row) - 1));
            break;
        }
    }

    @Override
    public void dispose() {
        Skin skin = this.getSkin();
        if (skin != null) {
            skin.dispose();
        }
        this.rows.clear();
        this.columnSupplementValuesChanges.clear();
    }

    public VirtualRaster getFixedVirtualRaster() {
        return this.fixedRaster;
    }
}

