/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.tables.skins;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import de.elpro.ewms.core.fx.Messages;
import de.elpro.ewms.core.fx.tables.ChartValuesTable;
import de.elpro.ewms.core.fx.tables.VarTableCellData;
import de.elpro.ewms.core.fx.tables.VarValuesColumn;
import de.elpro.ewms.core.fx.tables.skins.FlatVarValuesRow;
import de.elpro.ewms.core.fx.tables.skins.VarTreeTableCell;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.units.DisplayUnitFormat;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.MeasuringUnitFormats;
import de.elpro.ewms.core.variable.SupplementValueStrategy;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.SupplementValueChange;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import de.elpro.ui.fx.utils.FXUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ListChangeListener;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;

public class ChartValuesTableSkin
extends SkinBase<ChartValuesTable> {
    private static final ComplexRaster[] TIMERANGE_RASTERS = new ComplexRaster[]{ComplexRaster.of((Raster)Raster.Hour), ComplexRaster.of((VirtualRaster)VirtualRaster.Day), ComplexRaster.of((VirtualRaster)VirtualRaster.Month), ComplexRaster.of((VirtualRaster)VirtualRaster.Year)};
    private static final ComplexRaster[] REALTIME_RASTERS = new ComplexRaster[]{ComplexRaster.of((Raster)Raster.Hour), ComplexRaster.of((VirtualRaster)VirtualRaster.Day)};
    private final ChartValuesTable control;
    private final Map<VarValuesColumn, TreeTableColumn<FlatVarValuesRow, VarTableCellData>> tableColumns = new HashMap<VarValuesColumn, TreeTableColumn<FlatVarValuesRow, VarTableCellData>>();
    private final TreeItem<FlatVarValuesRow> rootItem = new TreeItem();
    private final Table<ComplexRaster, Instant, TreeItem<FlatVarValuesRow>> treeItems = HashBasedTable.create();
    private final TreeTableView<FlatVarValuesRow> view = new TreeTableView(this.rootItem);
    private boolean skipScrollTo = false;
    private boolean skipDataSelection = false;

    public ChartValuesTableSkin(ChartValuesTable control) {
        super((Control)control);
        this.control = control;
        control.getStyleClass().add((Object)"var-table");
        TreeTableColumn timestampColumn = new TreeTableColumn(Messages.tables_skins_FlatVarValuesTableSkin_Timestamp);
        timestampColumn.setCellValueFactory(cf -> new ReadOnlyObjectWrapper((Object)((FlatVarValuesRow)cf.getValue().getValue())));
        timestampColumn.setCellFactory(cf -> new FlatVarValuesRowCell());
        timestampColumn.setPrefWidth(250.0);
        this.view.setShowRoot(false);
        this.view.getColumns().add((Object)timestampColumn);
        this.view.setTableMenuButtonVisible(true);
        for (VarValuesColumn varValuesColumn : control.getColumns()) {
            this.addTableColumn(varValuesColumn);
        }
        this.getChildren().add(this.view);
        control.getColumns().addListener(this::varValuesColumnsListChangeListener);
        control.dataSelectionProperty().addListener((o, ov, nv) -> {
            Instant newTimestamp;
            Instant oldTimestamp = ov != null ? ov.getEndTimestamp() : null;
            Instant instant = newTimestamp = nv != null ? nv.getEndTimestamp() : null;
            if (newTimestamp != null && !newTimestamp.equals(oldTimestamp)) {
                Map rasterItems = this.treeItems.column((Object)newTimestamp);
                rasterItems.values().stream().filter(ti -> ti.getChildren().isEmpty()).findAny().ifPresent(ti -> {
                    ArrayList selectedRows = new ArrayList(this.view.getSelectionModel().getSelectedItems());
                    if (selectedRows.stream().anyMatch(p -> p != null && p.getValue() != null && ((FlatVarValuesRow)p.getValue()).getIntervalEnd().equals(newTimestamp))) {
                        return;
                    }
                    this.skipDataSelection = true;
                    try {
                        TreeItem parent = ti.getParent();
                        while (parent != null) {
                            parent.setExpanded(true);
                            parent = parent.getParent();
                        }
                        Integer viewIndex = FXUtils.getTreeTableViewItemIndex(this.view, (TreeItem)(ti.getParent() != null ? ti.getParent() : ti));
                        if (viewIndex != null && !this.skipScrollTo) {
                            this.view.scrollTo(viewIndex.intValue());
                        }
                        this.view.getSelectionModel().select(ti);
                    }
                    finally {
                        this.skipDataSelection = false;
                    }
                });
            }
        });
        this.view.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> {
            if (!(this.skipDataSelection || nv == null || nv.getValue() == null || ov != null && ((FlatVarValuesRow)ov.getValue()).getIntervalEnd().equals(((FlatVarValuesRow)nv.getValue()).getIntervalEnd()))) {
                this.skipScrollTo = true;
                try {
                    control.selectData(((FlatVarValuesRow)nv.getValue()).getIntervalEnd(), null);
                }
                finally {
                    this.skipScrollTo = false;
                }
            }
        });
    }

    private void varValuesColumnsListChangeListener(ListChangeListener.Change<? extends VarValuesColumn> c) {
        while (c.next()) {
            for (VarValuesColumn removedColumns : c.getRemoved()) {
                this.removeVarValuesColumn(removedColumns);
            }
            for (VarValuesColumn addedColumns : c.getAddedSubList()) {
                this.addTableColumn(addedColumns);
            }
        }
    }

    private LinkedHashMap<ComplexRaster, FlatVarValuesRow> initRowsForVarValue(LinkedList<ComplexRaster> rasters, IVarValue varValue, boolean isRealtimeValues) {
        LinkedHashMap<ComplexRaster, FlatVarValuesRow> rasterRows = new LinkedHashMap<ComplexRaster, FlatVarValuesRow>();
        for (ComplexRaster raster : rasters) {
            Instant to = raster.getRasterEnd(Instant.ofEpochMilli(varValue.getEndTimestamp()));
            Instant from = raster.getRasterBegin(to).minusNanos(1L);
            TreeItem treeItem = (TreeItem)this.treeItems.get((Object)raster, (Object)to);
            if (treeItem == null) {
                treeItem = new TreeItem((Object)new FlatVarValuesRow(from, to, raster, isRealtimeValues ? FlatVarValuesRow.RangeType.Realtime : FlatVarValuesRow.RangeType.TimeRange));
                ComplexRaster nextRaster = this.getNextRaster(raster, rasters);
                if (nextRaster == null) {
                    this.rootItem.getChildren().add((Object)treeItem);
                } else {
                    Instant nextRasterToTs = nextRaster.getRasterEnd(to);
                    ((TreeItem)this.treeItems.get((Object)nextRaster, (Object)nextRasterToTs)).getChildren().add((Object)treeItem);
                }
                this.treeItems.put((Object)raster, (Object)to, (Object)treeItem);
            }
            rasterRows.put(raster, (FlatVarValuesRow)treeItem.getValue());
        }
        return rasterRows;
    }

    private ComplexRaster getNextRaster(ComplexRaster raster, LinkedList<ComplexRaster> rasterHierarchie) {
        int currentRasterIndex = rasterHierarchie.indexOf(raster);
        return currentRasterIndex > 0 ? rasterHierarchie.get(currentRasterIndex - 1) : null;
    }

    private LinkedList<ComplexRaster> getRasterHierarchie(ComplexRaster raster, boolean realtime) {
        LinkedList<ComplexRaster> rasters = new LinkedList<ComplexRaster>();
        if (raster == ComplexRaster.WEEK) {
            rasters.add(raster);
            rasters.addFirst(ComplexRaster.of((VirtualRaster)VirtualRaster.Year));
        } else {
            ComplexRaster[] candidateRasters;
            ComplexRaster[] complexRasterArray = candidateRasters = realtime ? REALTIME_RASTERS : TIMERANGE_RASTERS;
            if (raster.getRaster() == Raster.Hour) {
                rasters.add(ComplexRaster.of((VirtualRaster)VirtualRaster.Hour));
            } else {
                rasters.add(raster);
            }
            ComplexRaster[] complexRasterArray2 = candidateRasters;
            int n = candidateRasters.length;
            int n2 = 0;
            while (n2 < n) {
                ComplexRaster candidateRaster = complexRasterArray2[n2];
                if (raster.ordinal() < candidateRaster.ordinal()) {
                    rasters.addFirst(candidateRaster);
                }
                ++n2;
            }
        }
        return rasters;
    }

    protected TreeTableColumn<FlatVarValuesRow, VarTableCellData> addTableColumn(VarValuesColumn varValuesColumn) {
        LinkedList<ComplexRaster> rasters = this.getRasterHierarchie(varValuesColumn.getComplexRaster(), varValuesColumn.isRealtimeValues());
        VariableInstance instance = varValuesColumn.getVariableInstance();
        MeasuringUnit displayUnit = varValuesColumn.getDisplayUnit();
        this.removeVarValuesColumn(varValuesColumn);
        for (IVarValue varValue : varValuesColumn.getValues()) {
            for (Map.Entry<ComplexRaster, FlatVarValuesRow> entry : this.initRowsForVarValue(rasters, varValue, varValuesColumn.isRealtimeValues()).entrySet()) {
                ComplexRaster raster = entry.getKey();
                FlatVarValuesRow row = entry.getValue();
                VarTableCellData cellData = row.getColumnValues().get(varValuesColumn);
                if (cellData == null) {
                    boolean lockedCell = raster.getVirtualRaster() != null && raster.getVirtualRaster().ordinal() > VirtualRaster.Day.ordinal();
                    cellData = new VarTableCellData(instance, displayUnit, MeasuringUnitFormats.SIMPLE, new ArrayList(), lockedCell);
                    row.getColumnValues().put(varValuesColumn, cellData);
                }
                ((List)cellData.getObject()).add(varValue);
            }
        }
        MeasuringUnit valueMU = varValuesColumn.getVariableInstance().getVariable().getMeasuringUnit();
        MeasuringUnit displayMU = varValuesColumn.getDisplayUnit();
        String columnName = String.format("%s\r\n[%s]", varValuesColumn.getLabelText(), displayMU.getDisplayUnitText(DisplayUnitFormat.SIMPLE));
        TreeTableColumn tableColumn = new TreeTableColumn(columnName);
        tableColumn.setCellValueFactory(cf -> new ObservableRowVarValue((FlatVarValuesRow)cf.getValue().getValue(), varValuesColumn));
        tableColumn.setGraphic(varValuesColumn.getLabelNode());
        tableColumn.setCellFactory(cf -> new VarTreeTableCell(valueMU, displayMU));
        if (varValuesColumn.getVariableInstance().getSupplementValueStrategy() == null) {
            tableColumn.getStyleClass().add((Object)"supplement-strategy-none");
        } else if (varValuesColumn.getVariableInstance().getSupplementValueStrategy() == SupplementValueStrategy.Rasterized) {
            tableColumn.getStyleClass().add((Object)"supplement-strategy-rasterized");
        } else if (varValuesColumn.getVariableInstance().getSupplementValueStrategy() == SupplementValueStrategy.Unrasterized) {
            tableColumn.getStyleClass().add((Object)"supplement-strategy-unrasterized");
        }
        tableColumn.getStyleClass().add((Object)"var-value");
        this.tableColumns.put(varValuesColumn, (TreeTableColumn<FlatVarValuesRow, VarTableCellData>)tableColumn);
        this.view.getColumns().add((Object)tableColumn);
        if (instance.getSupplementValueStrategy() != null) {
            this.view.setEditable(true);
            if (!this.control.getStyleClass().contains((Object)"editable")) {
                this.control.getStyleClass().add((Object)"editable");
            }
            tableColumn.setEditable(true);
        }
        return tableColumn;
    }

    protected void removeVarValuesColumn(VarValuesColumn varValuesColumn) {
        TreeTableColumn<FlatVarValuesRow, VarTableCellData> tableColumn = this.tableColumns.remove(varValuesColumn);
        if (tableColumn != null) {
            this.view.getColumns().remove(tableColumn);
            this.clearRowsColumnValues(varValuesColumn);
        }
    }

    protected void clearRowsColumnValues(VarValuesColumn varValuesColumn) {
        LinkedList<FlatVarValuesRow> emptyRows = new LinkedList<FlatVarValuesRow>();
        for (TreeItem treeItem : this.treeItems.values()) {
            FlatVarValuesRow row = (FlatVarValuesRow)treeItem.getValue();
            row.getColumnValues().remove(varValuesColumn);
            if (!row.getColumnValues().isEmpty()) continue;
            emptyRows.add(row);
            treeItem.getParent().getChildren().remove((Object)treeItem);
        }
        for (FlatVarValuesRow row : emptyRows) {
            this.treeItems.remove((Object)row.getRaster(), (Object)row.getIntervalEnd());
        }
    }

    public TreeTableView<?> getTableView() {
        return this.view;
    }

    public void dispose() {
        this.getChildren().clear();
        super.dispose();
    }

    private static class FlatVarValuesRowCell
    extends TreeTableCell<FlatVarValuesRow, FlatVarValuesRow> {
        private FlatVarValuesRowCell() {
        }

        protected void updateItem(FlatVarValuesRow item, boolean empty) {
            if (empty || item == null) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                this.setText(item.getRasterLabel());
                this.setGraphic(null);
            }
        }
    }

    private class ObservableRowVarValue
    extends SimpleObjectProperty<VarTableCellData> {
        private final FlatVarValuesRow row;
        private final VarValuesColumn column;

        public ObservableRowVarValue(FlatVarValuesRow row, VarValuesColumn varValuesColumn) {
            super((Object)row.getColumnValues().get(varValuesColumn));
            this.row = row;
            this.column = varValuesColumn;
        }

        public void set(VarTableCellData newCellData) {
            IVarValue newValue = newCellData.getVarValue();
            this.row.getColumnValues().put(this.column, newCellData);
            Instant from = this.row.getIntervalBegin();
            Instant to = newCellData.getInstance().getSupplementValueStrategy() == SupplementValueStrategy.Unrasterized ? from : this.row.getIntervalEnd();
            SupplementValueChange change = new SupplementValueChange(this.column.getVariableInstance(), from, to, null, newValue.getValue());
            ChartValuesTableSkin.this.control.getVarValuesChanges().add((Object)change);
            super.set((Object)newCellData);
        }

        public VarTableCellData get() {
            return this.row.getColumnValues().get(this.column);
        }
    }
}

