/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.tables.skins;

import de.elpro.ewms.core.fx.tables.VarTableCellData;
import de.elpro.ewms.core.fx.tables.VarValuesColumn;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.virtualtime.ComplexRaster;
import de.elpro.ewms.core.virtualtime.VirtualRaster;
import de.elpro.ewms.core.virtualtime.VirtualZone;
import de.elpro.ui.formats.TimeFormatType;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAccessor;
import java.util.HashMap;
import java.util.Map;

public class FlatVarValuesRow
implements Comparable<Object> {
    private final Instant intervalBegin;
    private final Instant intervalEnd;
    private final ComplexRaster raster;
    private final RangeType rangeType;
    private final Map<VarValuesColumn, VarTableCellData> columnValue = new HashMap<VarValuesColumn, VarTableCellData>();

    public FlatVarValuesRow(Instant intervalBegin, Instant intervalEnd, ComplexRaster raster, RangeType rangeType) {
        this.intervalBegin = intervalBegin;
        this.intervalEnd = intervalEnd;
        this.raster = raster;
        this.rangeType = rangeType;
    }

    public Instant getIntervalEnd() {
        return this.intervalEnd;
    }

    public Instant getIntervalBegin() {
        return this.intervalBegin;
    }

    public ComplexRaster getRaster() {
        return this.raster;
    }

    public Map<VarValuesColumn, VarTableCellData> getColumnValues() {
        return this.columnValue;
    }

    @Override
    public int compareTo(Object o) {
        if (!(o instanceof FlatVarValuesRow)) {
            return -1;
        }
        return this.intervalEnd.compareTo(((FlatVarValuesRow)o).intervalEnd);
    }

    public String getRasterLabel() {
        Raster fixedRaster = this.raster.getRaster();
        if (this.rangeType == RangeType.TimeRange) {
            if (this.raster.getVirtualRaster() != null) {
                virtualRaster = this.raster.getVirtualRaster();
                if (virtualRaster != VirtualRaster.Hour) {
                    return virtualRaster.getSubIndexLabelWithinParentRaster(this.getIntervalEnd());
                }
                fixedRaster = Raster.Hour;
            }
        } else if (this.raster.getVirtualRaster() != null) {
            virtualRaster = this.raster.getVirtualRaster();
            if (virtualRaster != VirtualRaster.Hour) {
                OffsetDateTime offsetDateTime = VirtualZone.INSTANCE.getOffsetDateTime(this.getIntervalBegin());
                return TimeFormatType.Date.format((TemporalAccessor)offsetDateTime);
            }
            fixedRaster = Raster.Hour;
        }
        LocalDateTime localtimeBegin = LocalDateTime.ofInstant(this.getIntervalBegin(), ZoneId.systemDefault());
        LocalDateTime localtimeEnd = LocalDateTime.ofInstant(this.getIntervalEnd(), ZoneId.systemDefault());
        TimeFormatType timeFormat = fixedRaster.ordinal() < Raster.Second_1.ordinal() ? TimeFormatType.TimeHMsMs : (fixedRaster.ordinal() < Raster.Minute_1.ordinal() ? TimeFormatType.TimeHMs : TimeFormatType.TimeHM);
        return String.format("%s to %s", timeFormat.format((TemporalAccessor)localtimeBegin), timeFormat.format((TemporalAccessor)localtimeEnd));
    }

    public String toString() {
        LocalDateTime localtimeEnd = LocalDateTime.ofInstant(this.getIntervalEnd(), ZoneId.systemDefault());
        return TimeFormatType.DateTimeHMs.format((TemporalAccessor)localtimeEnd);
    }

    public static enum RangeType {
        Realtime,
        TimeRange;

    }
}

