/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.tables.skins;

import de.elpro.ewms.core.fx.cells.CheckBoxSwitchTableCell;
import de.elpro.ewms.core.fx.tables.VarTableCellData;
import de.elpro.ewms.core.fx.tables.VarTableRow;
import de.elpro.ewms.core.units.Aggregation;
import de.elpro.ewms.core.units.MeasuringUnitFormats;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.SupplementValue;
import java.time.Instant;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;

public class VarTableCheckBoxSwitchBoolCell
extends CheckBoxSwitchTableCell<VarTableRow, VarTableCellData> {
    private final List<String> defaultClasses;

    public VarTableCheckBoxSwitchBoolCell(TableColumn<VarTableRow, VarTableCellData> columnView) {
        super((Callback<Integer, ObservableValue<Boolean>>)((Callback)i -> {
            ObjectProperty valueProp = (ObjectProperty)columnView.getCellObservableValue(i.intValue());
            VarTableCellData cellData = (VarTableCellData)valueProp.getValue();
            if (cellData == null) {
                return null;
            }
            Boolean value = cellData.getVarValue() != null && cellData.getVarValue().isValid() && cellData.getVarValue().getValue() > 0.0 ? (cellData.getVarValue().getValue() == 1.0 && cellData.getVarValue().getQuality() == 1.0 ? Boolean.valueOf(true) : null) : Boolean.valueOf(false);
            SimpleObjectProperty boolProp = new SimpleObjectProperty((Object)value);
            boolProp.addListener((o, ov, nv) -> valueProp.set((Object)new VarTableCellData(cellData.getInstance(), null, MeasuringUnitFormats.SIMPLE, (Object)new SupplementValue(0L, 0L, nv != false ? 1.0 : 0.0, Instant.now().toEpochMilli(), 0), cellData.isLockedCell())));
            return boolProp;
        }));
        this.getStyleClass().add((Object)"bool-cell");
        this.getCheckBox().setShowDescriptions(true);
        this.defaultClasses = new LinkedList<String>((Collection<String>)this.getStyleClass());
    }

    @Override
    public void updateItem(VarTableCellData item, boolean empty) {
        super.updateItem(item, empty);
        LinkedList<String> classes = new LinkedList<String>();
        if (!this.isEmpty()) {
            if (item != null && item.getObject() != null) {
                Object object;
                if (((VarTableCellData)this.getItem()).isSummary()) {
                    classes.add("summary");
                }
                if ((object = item.getObject()) instanceof IVarValue) {
                    classes.add("var-value");
                    IVarValue val = (IVarValue)object;
                    if (!val.isValid()) {
                        classes.add("invalid");
                    }
                    if (val instanceof SupplementValue) {
                        classes.add("supplement");
                    }
                } else if (object instanceof Aggregation) {
                    classes.add("aggregation");
                } else if (object instanceof Number) {
                    classes.add("number");
                } else {
                    classes.add("text");
                }
                classes.addAll(item.getCellStyleClasses());
            } else {
                classes.add("empty");
                this.setText(null);
            }
            classes.add(this.isEditableItem() ? (this.isLockedItem() ? "locked" : "editable") : "readonly");
        }
        this.setStyleClass(classes.toArray(new String[0]));
    }

    private void setStyleClass(String ... classNames) {
        LinkedList<String> defaultClasses = new LinkedList<String>(this.defaultClasses);
        if (classNames != null) {
            String[] stringArray = classNames;
            int n = classNames.length;
            int n2 = 0;
            while (n2 < n) {
                String className = stringArray[n2];
                defaultClasses.add(className);
                ++n2;
            }
        }
        this.getStyleClass().setAll(defaultClasses);
    }

    private boolean isEditableItem() {
        return this.isEditable() && this.getTableView().isEditable() && this.getTableColumn().isEditable() && this.getItem() != null && !((VarTableCellData)this.getItem()).isSummary() && ((VarTableCellData)this.getItem()).getInstance() != null && ((VarTableCellData)this.getItem()).getInstance().getSupplementValueStrategy() != null;
    }

    private boolean isLockedItem() {
        return ((VarTableCellData)this.getItem()).isLockedCell();
    }

    private boolean canEdit() {
        return this.isEditableItem() && !this.isLockedItem();
    }
}

