/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.tables.skins;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.elpro.ewms.core.fx.cells.VarTableEditorCell;
import de.elpro.ewms.core.fx.tables.VarTableCellData;
import de.elpro.ewms.core.fx.tables.skins.ChoiceOption;
import de.elpro.ewms.core.units.Aggregation;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.MeasuringUnitFormat;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.SupplementValue;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class VarTableChoiceCell<S>
extends VarTableEditorCell<S, ComboBox<ChoiceOption>> {
    private final RenderingProperties renderingProperties;
    private final Map<Double, ChoiceOption> options = new HashMap<Double, ChoiceOption>();

    public VarTableChoiceCell(RenderingProperties renderingProperties, MeasuringUnit valueUnit, MeasuringUnit displayUnit, MeasuringUnitFormat displayMUFormat, String ... defaultClasses) {
        super(valueUnit, displayUnit, displayMUFormat, defaultClasses);
        this.renderingProperties = renderingProperties;
    }

    public void startEdit() {
        if (!this.canEdit()) {
            return;
        }
        super.startEdit();
        if (this.isEditing()) {
            double val;
            this.escapePressed = false;
            ComboBox editor = (ComboBox)this.getEditor();
            IVarValue editableValue = ((VarTableCellData)this.getItem()).getVarValue();
            double d = val = editableValue != null ? editableValue.getValue() : Double.NaN;
            if (Double.isNaN(val)) {
                editor.setValue(null);
            } else {
                ChoiceOption option = this.options.get(val);
                editor.setValue((Object)option);
            }
            this.setTextFill((Paint)Color.BLACK);
            this.setText(null);
            this.setGraphic((Node)editor);
            editor.requestFocus();
            TableView table = this.getTableView();
            if (table != null) {
                this.editingCell = table.getEditingCell();
            }
        }
    }

    public void cancelEdit() {
        if (!this.escapePressed) {
            this.escapePressed = true;
            ComboBox nf = (ComboBox)this.getEditor();
            IVarValue prevItemVal = ((VarTableCellData)this.getItem()).getVarValue();
            Double prevVal = prevItemVal != null ? (Double.isNaN(prevItemVal.getValue()) ? null : Double.valueOf(prevItemVal.getValue())) : null;
            ChoiceOption newVal = (ChoiceOption)nf.getValue();
            if (newVal == null && prevVal != null || newVal != null && prevVal == null || newVal != null && !newVal.equals(prevVal)) {
                IVarValue newItemVal = this.createIVarValue(newVal.value);
                this.commitEdit(new VarTableCellData(((VarTableCellData)this.getItem()).getInstance(), this.displayMU, this.displayMUFormat, (Object)newItemVal, ((VarTableCellData)this.getItem()).isLockedCell()));
            }
        }
        super.cancelEdit();
        this.formatTextCell(((VarTableCellData)this.getItem()).getVarValue());
        this.setGraphic(null);
    }

    public void updateItem(VarTableCellData item, boolean empty) {
        super.updateItem((Object)item, empty);
        LinkedList<String> classes = new LinkedList<String>();
        if (this.isEmpty()) {
            this.setText(null);
            this.setGraphic(null);
            classes.add("empty");
        } else if (this.isEditing()) {
            this.setText(null);
            ComboBox editor = (ComboBox)this.getEditor();
            ChoiceOption option = this.options.get(item.getVarValue().getValue());
            editor.setValue((Object)option);
            this.setGraphic((Node)editor);
        } else {
            if (item != null && ((VarTableCellData)this.getItem()).isSummary()) {
                classes.add("summary");
            }
            if (item != null && item.getObject() != null) {
                Object object = item.getObject();
                if (object instanceof IVarValue) {
                    classes.add("var-value");
                    IVarValue val = (IVarValue)object;
                    if (!val.isValid()) {
                        classes.add("invalid");
                    }
                    if (val instanceof SupplementValue) {
                        classes.add("supplement");
                    }
                    this.formatTextCell(val);
                } else if (object instanceof Aggregation) {
                    this.setText(object.toString());
                    classes.add("aggregation");
                } else if (object instanceof Number) {
                    this.setText(this.displayMUFormat.getDefaultDecimalFormat().format(item.getDisplayDoubleValue()));
                    classes.add("number");
                } else {
                    this.setText(object.toString());
                    classes.add("text");
                }
                classes.addAll(item.getCellStyleClasses());
            } else {
                classes.add("empty");
                this.setText(null);
            }
            classes.add(this.isEditableItem() ? (this.isLockedItem() ? "locked" : "editable") : "readonly");
            this.setGraphic(null);
        }
        this.setStyleClass(classes.toArray(new String[0]));
    }

    @Override
    protected void formatTextCell(IVarValue varValue) {
        boolean boldFont = false;
        if (varValue != null && !Double.isNaN(varValue.getValue())) {
            double displayValue = this.displayMU.convert(varValue.getValue(), this.valueMU);
            String text = this.renderingProperties.valueMapping.get(displayValue);
            this.setText(text);
        } else {
            this.setText(null);
            this.setTooltip(null);
        }
        this.setStyle(boldFont ? "-fx-font-weight: bold;" : null);
    }

    @Override
    protected ComboBox<ChoiceOption> createEditor() {
        ObservableList options = FXCollections.observableArrayList();
        for (Map.Entry<Double, String> entry : this.renderingProperties.valueMapping.entrySet()) {
            ChoiceOption option = new ChoiceOption(entry.getKey(), entry.getValue());
            options.add((Object)option);
            this.options.put(entry.getKey(), option);
        }
        ComboBox editor = new ComboBox(options);
        editor.setOnAction(event -> {
            if (event.getTarget() instanceof Button) {
                return;
            }
            try {
                ChoiceOption option = (ChoiceOption)editor.getValue();
                Double value = option != null ? Double.valueOf(option.value) : null;
                IVarValue newItemVal = this.createIVarValue(value);
                this.commitEdit(new VarTableCellData(((VarTableCellData)this.getItem()).getInstance(), this.displayMU, this.displayMUFormat, (Object)newItemVal, ((VarTableCellData)this.getItem()).isLockedCell()));
            }
            catch (Exception exception) {
                this.escapePressed = true;
                this.cancelEdit();
            }
            this.requestFocus();
        });
        editor.setOnKeyPressed(t -> {
            this.escapePressed = t.getCode() == KeyCode.ESCAPE;
        });
        editor.setOnKeyReleased(t -> {
            if (t.getCode() == KeyCode.ESCAPE) {
                this.cancelEdit();
                t.consume();
            }
        });
        editor.focusedProperty().addListener((o, ov, nv) -> {
            if (ov.booleanValue() && !nv.booleanValue()) {
                Double newVal;
                IVarValue prevItemVal = ((VarTableCellData)this.getItem()).getVarValue();
                Double prevVal = prevItemVal != null ? (Double.isNaN(prevItemVal.getValue()) ? null : Double.valueOf(prevItemVal.getValue())) : null;
                ChoiceOption option = (ChoiceOption)editor.getValue();
                Double d = newVal = option != null ? Double.valueOf(option.value) : null;
                if (newVal == null && prevVal != null || newVal != null && prevVal == null || newVal != null && !((Object)newVal).equals(prevVal)) {
                    IVarValue newItemVal = this.createIVarValue(newVal);
                    this.commitEdit(new VarTableCellData(((VarTableCellData)this.getItem()).getInstance(), this.displayMU, this.displayMUFormat, (Object)newItemVal, ((VarTableCellData)this.getItem()).isLockedCell()));
                } else {
                    this.commitEdit((VarTableCellData)this.getItem());
                }
            }
        });
        return editor;
    }

    public static class RenderingProperties {
        private Map<Double, String> valueMapping = new TreeMap<Double, String>();
        private String defaultText = null;

        public static RenderingProperties parse(String propertiesText) {
            RenderingProperties properties = new RenderingProperties();
            if (propertiesText == null || propertiesText.isBlank()) {
                return properties;
            }
            JsonObject jsonObject = JsonParser.parseString((String)propertiesText).getAsJsonObject();
            JsonArray valueMapJson = jsonObject.get("valuesMap").getAsJsonArray();
            valueMapJson.forEach(e -> {
                JsonObject o = e.getAsJsonObject();
                double value = o.get("val").getAsDouble();
                String text = o.get("text").getAsString();
                renderingProperties.valueMapping.put(value, text);
            });
            JsonElement defTextE = jsonObject.get("defaultText");
            if (defTextE != null && defTextE.isJsonPrimitive() && !defTextE.isJsonNull()) {
                properties.defaultText = defTextE.getAsString();
            }
            return properties;
        }
    }
}

