/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.tables.skins;

import de.elpro.ewms.core.client.Transactions;
import de.elpro.ewms.core.client.preferences.ServerDAO;
import de.elpro.ewms.core.client.structure.StructureObjectDAO;
import de.elpro.ewms.core.client.tables.viewprefs.TableViewPrefsDAO;
import de.elpro.ewms.core.client.variable.VariableInstanceDAO;
import de.elpro.ewms.core.client.variable.VariableRoleDAO;
import de.elpro.ewms.core.db.DAOOperationException;
import de.elpro.ewms.core.db.Transaction;
import de.elpro.ewms.core.exceptions.IllegalConfigException;
import de.elpro.ewms.core.fx.Messages;
import de.elpro.ewms.core.fx.cells.VarValueTableCell;
import de.elpro.ewms.core.fx.cells.VarValueTableEditableTextCell;
import de.elpro.ewms.core.fx.model.DataSelection;
import de.elpro.ewms.core.fx.model.IDataSelection;
import de.elpro.ewms.core.fx.model.UIObjectState;
import de.elpro.ewms.core.fx.tables.TablePrefsDialog;
import de.elpro.ewms.core.fx.tables.VarTableCellData;
import de.elpro.ewms.core.fx.tables.VarTableRow;
import de.elpro.ewms.core.fx.tables.VarTableView;
import de.elpro.ewms.core.fx.tables.skins.VarTableCheckBoxBoolCell;
import de.elpro.ewms.core.fx.tables.skins.VarTableCheckBoxSwitchBoolCell;
import de.elpro.ewms.core.fx.tables.skins.VarTableChoiceCell;
import de.elpro.ewms.core.rawvalues.RawValuesViewType;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.tables.Column;
import de.elpro.ewms.core.tables.ColumnGroup;
import de.elpro.ewms.core.tables.ColumnType;
import de.elpro.ewms.core.tables.ColumnValueRenderingType;
import de.elpro.ewms.core.tables.Table;
import de.elpro.ewms.core.tables.TableType;
import de.elpro.ewms.core.tables.viewprefs.TableViewPrefs;
import de.elpro.ewms.core.time.Raster;
import de.elpro.ewms.core.units.DisplayUnitFormat;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.ewms.core.variable.VariableInstanceType;
import de.elpro.ewms.core.variable.value.SupplementValue;
import de.elpro.ewms.core.variable.value.ValueSource;
import de.elpro.ewms.core.variable.value.VarValue;
import de.elpro.resources.Icons;
import de.elpro.ui.fx.controls.CheckBoxDialog;
import de.elpro.ui.fx.layout.ProgressIndicatorPane;
import de.elpro.ui.fx.utils.ColumnsPersistedState;
import de.elpro.ui.model.UIModelElement;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.Future;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import org.controlsfx.dialog.ExceptionDialog;

public class VarTableViewSkin
extends SkinBase<VarTableView> {
    private final VarTableView control;
    private final Table tableConfig;
    private final StructureObject structureObject;
    private final TableView<VarTableRow> tableView;

    public VarTableViewSkin(VarTableView control) {
        super((Control)control);
        this.control = control;
        this.tableConfig = control.getConfig();
        this.structureObject = control.getStructureObject();
        control.getStyleClass().add((Object)"var-table");
        this.tableView = new TableView();
        this.tableView.setTableMenuButtonVisible(true);
        this.tableView.setContextMenu(this.createContextMenu());
        this.tableView.setOnKeyPressed((EventHandler)new TableKeyEventHandler());
        this.tableView.getSelectionModel().selectedItemProperty().addListener((o, ov, nv) -> {
            if (nv != null && ov != nv && nv.getIntervalEnd() != null) {
                SimpleObjectProperty prop = (SimpleObjectProperty)control.dataSelectionProperty();
                if (prop.get() != null) {
                    Instant oldTimestamp = ((IDataSelection)prop.get()).getEndTimestamp();
                    if (nv.getIntervalEnd() != null && nv.getIntervalEnd().equals(oldTimestamp)) {
                        return;
                    }
                    if (nv.getIntervalBegin() != null && nv.getIntervalEnd() != null && nv.getIntervalBegin().isBefore(oldTimestamp) && !nv.getIntervalEnd().isBefore(oldTimestamp)) {
                        return;
                    }
                }
                prop.set((Object)new DataSelection(nv.getIntervalEnd(), nv.getStructureObject()));
            }
        });
        Transaction trx = Transactions.begin();
        try {
            try {
                for (UIModelElement element : this.tableConfig.getRootChildren()) {
                    this.tableView.getColumns().addAll(this.createColumnRecursive(trx, this.structureObject, element));
                }
            }
            catch (IllegalConfigException exc) {
                ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                dlg.initOwner(control.getScene().getWindow());
                dlg.show();
                Transactions.close((Transaction)trx);
                return;
            }
        }
        finally {
            Transactions.close((Transaction)trx);
        }
        control.getRows().addListener(il -> this.tableView.getItems().setAll(control.getRows()));
        String title = this.tableConfig.getLocalTitle();
        TableView<VarTableRow> viewNode = this.tableView;
        if (title != null && !title.trim().isEmpty()) {
            title = title.replaceAll("\\{object\\}", this.structureObject.toString());
            LinkedList columns = new LinkedList(this.tableView.getColumns());
            TableColumn titleColumn = new TableColumn(title);
            titleColumn.setId(String.format("titlecolumns_%d", this.tableConfig.getId()));
            titleColumn.getColumns().addAll(columns);
            this.tableView.getColumns().setAll((Object[])new TableColumn[]{titleColumn});
        }
        ProgressIndicatorPane progressIndicatorPane = new ProgressIndicatorPane(viewNode);
        control.stateProperty().addListener((o, ov, nv) -> progressIndicatorPane.showIndicator(control.getState() == UIObjectState.Loading));
        progressIndicatorPane.showIndicator(control.getState() == UIObjectState.Loading);
        this.getChildren().add((Object)progressIndicatorPane);
    }

    private ContextMenu createContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem adjustItem = new MenuItem(Messages.tables_skins_VarTableViewSkin_Adjust);
        adjustItem.setOnAction(e -> {
            TableViewPrefs prefs = this.control.getViewPrefs();
            ColumnsPersistedState state = new ColumnsPersistedState();
            state.persistColumns(this.getTableView().getColumns());
            prefs.setColumnsPersistedState(state.toString());
            Raster minRaster = ServerDAO.getRawValuesViewRaster((RawValuesViewType)this.control.getLastTimeRangeFilter().getType().toRawValueViewType(), (Integer)this.control.getLastTimeRangeFilter().getCustomViewIndex());
            TablePrefsDialog dialog = new TablePrefsDialog(this.control.getWindow(), prefs, this.control.getLastTimeRangeFilter().getType(), this.control.getLastTimeRangeFilter().getCustomViewIndex(), minRaster);
            dialog.showAndWait().ifPresent(bt -> {
                if (bt == ButtonType.OK) {
                    if (this.tableConfig.getId() != null && this.control.getFixedVirtualRaster() == null) {
                        dialog.persist();
                    }
                    this.control.reloadData();
                }
            });
        });
        MenuItem refreshItem = new MenuItem(Messages.tables_skins_VarTableViewSkin_Refresh, (Node)new ImageView(Icons.REFRESH_ITEM_URL.toString()));
        refreshItem.setOnAction(e -> {
            Future<?> future = this.control.reloadData();
        });
        MenuItem clearViewPreferencesItem = new MenuItem(Messages.tables_skins_VarTableViewSkin_Clear_Preferences);
        clearViewPreferencesItem.setOnAction(e -> {
            CheckBoxDialog dialog = new CheckBoxDialog(false);
            dialog.initOwner(((VarTableView)this.getSkinnable()).getScene().getWindow());
            dialog.setContentText(Messages.tables_skins_VarTableViewSkin_Clear_preferences_at_similar_tables);
            dialog.showAndWait().ifPresent(result -> {
                if (this.tableConfig.getId() == null) {
                    return;
                }
                Transaction trx = Transactions.begin();
                try {
                    try {
                        if (result.booleanValue()) {
                            TableViewPrefsDAO.delete((Transaction)trx, (Table)this.tableConfig);
                        } else {
                            TableViewPrefsDAO.delete((Transaction)trx, (Table)this.tableConfig, (StructureObject)this.structureObject);
                        }
                        Transactions.commitSync((Transaction)trx);
                        this.control.restoreColumnsPersistedState();
                        this.control.reloadData();
                    }
                    catch (DAOOperationException exc) {
                        Transactions.rollback((Transaction)trx);
                        ExceptionDialog dlg = new ExceptionDialog((Throwable)exc);
                        dlg.setContentText(Messages.tables_skins_VarTableViewSkin_Error_clearing_view_perspective);
                        dlg.show();
                        Transactions.close((Transaction)trx);
                    }
                }
                finally {
                    Transactions.close((Transaction)trx);
                }
            });
        });
        contextMenu.getItems().add((Object)adjustItem);
        contextMenu.getItems().add((Object)refreshItem);
        if (this.control.getFixedVirtualRaster() == null) {
            contextMenu.getItems().add((Object)clearViewPreferencesItem);
        }
        return contextMenu;
    }

    private Collection<TableColumn<VarTableRow, ?>> createColumnRecursive(Transaction trx, StructureObject structureObject, UIModelElement element) throws IllegalConfigException {
        LinkedList tableColumns = new LinkedList();
        if (element instanceof Column) {
            TableColumn tableColumn;
            Column column = (Column)element;
            if (!column.isVisible()) {
                return tableColumns;
            }
            MeasuringUnit valueMU = column.getResultValueMeasuringUnit();
            MeasuringUnit displayMU = column.getResultDisplayMeasuringUnit();
            if (column.getType() == ColumnType.Variable || column.getType() == ColumnType.VariableRole || column.getType() == ColumnType.AssignedText) {
                Variable variable = column.getVariable();
                VariableInstance variableInstance = column.getVariableInstance();
                if (column.getType() == ColumnType.VariableRole) {
                    variable = VariableRoleDAO.getUniqueVariable((Transaction)trx, (String)column.getVariableRoleId());
                    variableInstance = null;
                    if (variable != null) {
                        valueMU = variable.getMeasuringUnit();
                        MeasuringUnit measuringUnit = displayMU = column.getMeasuringUnit() != null && column.getMeasuringUnit().getPhysicalUnit().equals((Object)valueMU.getPhysicalUnit()) ? column.getMeasuringUnit() : valueMU;
                    }
                }
                if (variable == null) {
                    return tableColumns;
                }
                if (this.tableConfig.getType() == TableType.Time) {
                    VariableInstance instance = variableInstance;
                    if (instance == null) {
                        instance = VariableInstanceDAO.get((Transaction)trx, (Variable)variable, (StructureObject)structureObject);
                    }
                    if (instance == null || instance.getType() == VariableInstanceType.None && instance.getSupplementValueStrategy() == null) {
                        return tableColumns;
                    }
                }
            }
            TableColumn tcFF = tableColumn = new TableColumn();
            if (column.getColumnStyleClass() != null && !column.getColumnStyleClass().isBlank()) {
                String[] stringArray = column.getColumnStyleClass().replaceAll(",", " ").split(" ");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String styleClass = stringArray[n2];
                    if (!styleClass.isEmpty()) {
                        tableColumn.getStyleClass().add((Object)styleClass);
                    }
                    ++n2;
                }
            }
            MeasuringUnit finalVMU = valueMU;
            MeasuringUnit finalDMU = displayMU;
            VarTableChoiceCell.RenderingProperties choiceCellRenderingProperties = column.getRenderingType() == ColumnValueRenderingType.ChoiceValue ? VarTableChoiceCell.RenderingProperties.parse(column.getRendererProperties()) : null;
            tableColumn.setCellFactory(cf -> {
                switch (column.getType()) {
                    case AssignedText: {
                        return new VarValueTableEditableTextCell();
                    }
                }
                switch (column.getRenderingType()) {
                    case CheckBoxBoolVarValue: {
                        return new VarTableCheckBoxBoolCell((TableColumn<VarTableRow, VarTableCellData>)tcFF);
                    }
                    case CheckBoxSwitchBoolVarValue: {
                        return new VarTableCheckBoxSwitchBoolCell((TableColumn<VarTableRow, VarTableCellData>)tcFF);
                    }
                    case ChoiceValue: {
                        return new VarTableChoiceCell(choiceCellRenderingProperties, finalVMU, finalDMU, column.getMeasuringUnitFormat(), new String[0]);
                    }
                }
                return new VarValueTableCell(finalVMU, finalDMU, column.getMeasuringUnitFormat(), new String[0]);
            });
            tableColumn.setCellValueFactory(cf -> ((VarTableRow)cf.getValue()).getColumnValueProperty(column, structureObject));
            if (column.isEditable()) {
                this.tableView.setEditable(true);
                if (!this.control.getStyleClass().contains((Object)"editable")) {
                    this.control.getStyleClass().add((Object)"editable");
                }
            }
            tableColumn.setEditable(column.isEditable());
            if (column.getPrefWidth() != null) {
                tableColumn.setPrefWidth((double)column.getPrefWidth().intValue());
            }
            if (!column.getHideMU()) {
                String label;
                tableColumn.getStyleClass().add((Object)"var-table-datacolumn");
                if (displayMU != null && (label = displayMU.getDisplayUnitText(DisplayUnitFormat.SIMPLE)) != null && !label.isEmpty()) {
                    tableColumn.setText(String.format("[%s]", displayMU.getDisplayUnitText(DisplayUnitFormat.SIMPLE)));
                }
                if (!column.getHideName()) {
                    TableColumn nameHolderColumn = new TableColumn(column.getLocalName());
                    nameHolderColumn.getColumns().add((Object)tableColumn);
                    tableColumn = nameHolderColumn;
                    tableColumn.getStyleClass().add((Object)"var-table-textcolumn");
                    if (column.getColumnStyleClass() != null && !column.getColumnStyleClass().isEmpty()) {
                        String[] stringArray = column.getColumnStyleClass().replaceAll(",", " ").split(" ");
                        int n = stringArray.length;
                        int n3 = 0;
                        while (n3 < n) {
                            String styleClass = stringArray[n3];
                            if (!styleClass.isEmpty()) {
                                tableColumn.getStyleClass().add((Object)styleClass);
                            }
                            ++n3;
                        }
                    }
                }
            } else if (!column.getHideName()) {
                tableColumn.setText(column.getLocalName());
                tableColumn.getStyleClass().add((Object)"var-table-textcolumn");
            }
            String columnId = structureObject.equals((Object)this.structureObject) ? String.format("column_%d", column.getId()) : String.format("column_%d__object_%d", column.getId(), structureObject.getId());
            tableColumn.setId(columnId);
            tableColumns.add(tableColumn);
        } else if (element instanceof ColumnGroup) {
            ColumnGroup columnGroup = (ColumnGroup)element;
            LinkedList<StructureObject> objects = new LinkedList<StructureObject>();
            if (columnGroup.getObjectClass() == null) {
                objects.add(structureObject);
            } else {
                SearchPolicy searchPolicy = columnGroup.getObjectSearchPolicy() != null ? columnGroup.getObjectSearchPolicy() : this.tableConfig.getObjectSearchPolicy();
                objects.addAll(Arrays.asList(StructureObjectDAO.findObjects((Transaction)trx, (StructureObject)structureObject, (StructureClass)columnGroup.getObjectClass(), (SearchPolicy)searchPolicy)));
            }
            for (StructureObject object : objects) {
                String name = columnGroup.getLocalName();
                if (name != null) {
                    name = name.replaceAll("\\{object\\}", object.toString());
                }
                TableColumn tableColumn = new TableColumn(name);
                if (columnGroup.getColumnStyleClass() != null && !columnGroup.getColumnStyleClass().isBlank()) {
                    String[] stringArray = columnGroup.getColumnStyleClass().replaceAll(",", " ").split(" ");
                    int n = stringArray.length;
                    int choiceCellRenderingProperties = 0;
                    while (choiceCellRenderingProperties < n) {
                        String styleClass = stringArray[choiceCellRenderingProperties];
                        if (!styleClass.isEmpty()) {
                            tableColumn.getStyleClass().add((Object)styleClass);
                        }
                        ++choiceCellRenderingProperties;
                    }
                }
                String columnId = object.equals((Object)this.structureObject) ? String.format("columngroup_%d", columnGroup.getId()) : String.format("columngroup_%d__object_%d", columnGroup.getId(), object.getId());
                tableColumn.setId(columnId);
                if (columnGroup.getPrefWidth() != null) {
                    tableColumn.setPrefWidth((double)columnGroup.getPrefWidth().intValue());
                }
                for (UIModelElement childElement : columnGroup.getChildrenNormalized()) {
                    tableColumn.getColumns().addAll(this.createColumnRecursive(trx, object, childElement));
                }
                tableColumn.getStyleClass().add((Object)"var-table-textcolumn");
                tableColumns.add(tableColumn);
            }
        }
        return tableColumns;
    }

    public static void pasteFromClipboard(TableView<VarTableRow> table) {
        if (table.getSelectionModel().getSelectedCells().size() == 0) {
            return;
        }
        TablePosition pasteCellPosition = (TablePosition)table.getSelectionModel().getSelectedCells().get(0);
        String pasteString = Clipboard.getSystemClipboard().getString();
        if (pasteString == null || pasteString.isBlank()) {
            return;
        }
        int rowClipboard = -1;
        new HashMap();
        StringTokenizer rowTokenizer = new StringTokenizer(pasteString, "\n");
        while (rowTokenizer.hasMoreTokens()) {
            ++rowClipboard;
            String rowString = rowTokenizer.nextToken();
            StringTokenizer columnTokenizer = new StringTokenizer(rowString, "\t");
            int colClipboard = -1;
            while (columnTokenizer.hasMoreTokens()) {
                ObservableValue observableValue;
                TableColumn<VarTableRow, ?> tableColumn;
                ++colClipboard;
                String clipboardCellContent = columnTokenizer.nextToken();
                if (clipboardCellContent == null) continue;
                if ((clipboardCellContent = clipboardCellContent.replace("\r", "").trim()).contains(",")) {
                    clipboardCellContent = clipboardCellContent.replace(".", "").replace(",", ".");
                }
                int rowTable = pasteCellPosition.getRow() + rowClipboard;
                int colTable = pasteCellPosition.getColumn() + colClipboard;
                if (rowTable >= table.getItems().size() || (tableColumn = VarTableViewSkin.getTableColumn(table.getColumns(), colTable)) == null || !((observableValue = tableColumn.getCellObservableValue(rowTable)) instanceof ObjectProperty)) continue;
                ObjectProperty objectProperty = (ObjectProperty)observableValue;
                Object o = objectProperty.get();
                Double n = null;
                try {
                    n = Double.parseDouble(clipboardCellContent);
                }
                catch (NumberFormatException numberFormatException) {}
                if (!(o instanceof VarTableCellData)) continue;
                VarTableCellData cellData = (VarTableCellData)o;
                if (!tableColumn.isEditable() || cellData.isLockedCell() || cellData.isSummary() || cellData.getInstance() == null || cellData.getInstance().getSupplementValueStrategy() == null) continue;
                Object newItem = n != null && Double.isFinite(n) ? new SupplementValue(0L, 0L, cellData.getValueUnit().convert(n.doubleValue(), cellData.getDisplayUnit()), Instant.now().toEpochMilli(), 0) : new VarValue(0L, Double.NaN, 0.0, ValueSource.NaN);
                VarTableCellData newCellData = new VarTableCellData(cellData.getInstance(), cellData.getDisplayUnit(), cellData.getDisplayUnitFormat(), newItem, cellData.isLockedCell());
                objectProperty.set((Object)newCellData);
            }
        }
    }

    private static TableColumn<VarTableRow, ?> getTableColumn(List<TableColumn<VarTableRow, ?>> columns, int index) {
        LinkedList candidates = new LinkedList(columns);
        int currentIndex = 0;
        while (!candidates.isEmpty()) {
            TableColumn<VarTableRow, ?> candidate = candidates.removeFirst();
            if (candidate.getColumns().isEmpty()) {
                if (currentIndex == index) {
                    return candidate;
                }
                ++currentIndex;
                continue;
            }
            int pos = 0;
            for (TableColumn c : candidate.getColumns()) {
                candidates.add(pos++, c);
            }
        }
        return null;
    }

    public TableView<VarTableRow> getTableView() {
        return this.tableView;
    }

    public void dispose() {
        this.getChildren().clear();
        super.dispose();
    }

    public static class TableKeyEventHandler
    implements EventHandler<KeyEvent> {
        KeyCodeCombination pasteKeyCodeCompination = new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCombination.CONTROL_ANY});

        public void handle(KeyEvent keyEvent) {
            if (this.pasteKeyCodeCompination.match(keyEvent) && keyEvent.getSource() instanceof TableView) {
                VarTableViewSkin.pasteFromClipboard((TableView<VarTableRow>)((TableView)keyEvent.getSource()));
                keyEvent.consume();
            }
        }
    }
}

