/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.fx.tables.skins;

import de.elpro.ewms.core.fx.tables.VarTableCellData;
import de.elpro.ewms.core.tables.Column;
import de.elpro.ewms.core.units.Aggregation;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.MeasuringUnitFormat;
import de.elpro.ewms.core.units.MeasuringUnitFormats;
import de.elpro.ewms.core.variable.value.IStoredVarValue;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.SupplementValue;
import de.elpro.ewms.core.variable.value.ValueSource;
import de.elpro.ewms.core.variable.value.VarValue;
import de.elpro.ui.formats.TimeFormatType;
import de.elpro.ui.fx.controls.NumericField;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTablePosition;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.KeyCode;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class VarTreeTableCell<S>
extends TreeTableCell<S, VarTableCellData> {
    protected NumericField numberField;
    private boolean escapePressed = false;
    private final MeasuringUnit valueMU;
    private final MeasuringUnit displayMU;
    private final MeasuringUnitFormat displayMUFormat;
    private TreeTablePosition<S, ?> editingCell = null;
    private final List<String> defaultClasses = new LinkedList<String>((Collection<String>)this.getStyleClass());

    public VarTreeTableCell(Column column) {
        this.valueMU = column.getResultValueMeasuringUnit();
        this.displayMU = column.getResultDisplayMeasuringUnit();
        this.displayMUFormat = column.getMeasuringUnitFormat() != null ? column.getMeasuringUnitFormat() : MeasuringUnitFormats.TABLE;
    }

    public VarTreeTableCell(MeasuringUnit valueUnit, MeasuringUnit displayUnit) {
        this(valueUnit, displayUnit, null);
    }

    public VarTreeTableCell(MeasuringUnit valueUnit, MeasuringUnit displayUnit, MeasuringUnitFormat displayMUFormat) {
        this.valueMU = valueUnit;
        this.displayMU = displayUnit;
        this.displayMUFormat = displayMUFormat != null ? displayMUFormat : MeasuringUnitFormats.TABLE;
    }

    public void startEdit() {
        if (!this.canEdit()) {
            return;
        }
        super.startEdit();
        if (this.isEditing()) {
            double val;
            this.escapePressed = false;
            NumericField numberField = this.getNumberField();
            IVarValue editableValue = ((VarTableCellData)this.getItem()).getVarValue();
            double d = val = editableValue != null ? editableValue.getValue() : Double.NaN;
            if (Double.isNaN(val)) {
                numberField.setValue(null);
            } else {
                numberField.setValue((Number)this.displayMU.convert(val, this.valueMU));
            }
            this.setTextFill((Paint)Color.BLACK);
            this.setText(null);
            this.setGraphic((Node)numberField);
            numberField.selectAll();
            numberField.requestFocus();
            TreeTableView table = this.getTreeTableView();
            if (table != null) {
                this.editingCell = table.getEditingCell();
            }
        }
    }

    public void commitEdit(VarTableCellData newValue) {
        if (!this.isEditing()) {
            this.escapePressed = true;
            return;
        }
        TreeTableView table = this.getTreeTableView();
        TreeTablePosition<S, ?> cell = null;
        if (table != null && (cell = table.getEditingCell()) == null && this.editingCell != null) {
            cell = this.editingCell;
            this.editingCell = null;
            table.edit(cell.getRow(), cell.getTableColumn());
        }
        if (cell != null) {
            this.escapePressed = true;
            super.commitEdit((Object)newValue);
        }
    }

    public void cancelEdit() {
        if (!this.escapePressed) {
            this.escapePressed = true;
            NumericField nf = this.getNumberField();
            IVarValue prevItemVal = ((VarTableCellData)this.getItem()).getVarValue();
            Double prevVal = prevItemVal != null ? (Double.isNaN(prevItemVal.getValue()) ? null : Double.valueOf(prevItemVal.getValue())) : null;
            Number newVal = nf.getValue();
            if (newVal == null && prevVal != null || newVal != null && prevVal == null || newVal != null && !newVal.equals(prevVal)) {
                IVarValue newItemVal = this.createIVarValue(newVal);
                this.commitEdit(new VarTableCellData(((VarTableCellData)this.getItem()).getInstance(), this.displayMU, this.displayMUFormat, (Object)newItemVal, ((VarTableCellData)this.getItem()).isLockedCell()));
            }
        }
        super.cancelEdit();
        this.formatTextCell(((VarTableCellData)this.getItem()).getVarValue());
        this.setGraphic(null);
    }

    private void formatTextCell(IVarValue varValue) {
        boolean boldFont = false;
        if (varValue != null && !Double.isNaN(varValue.getValue())) {
            double displayValue = this.displayMU.convert(varValue.getValue(), this.valueMU);
            String valueText = this.displayMU.getValueFormat(this.displayMUFormat).format(displayValue);
            this.setText(valueText);
            this.setTooltip(new Tooltip(this.createTooltipText(varValue, valueText)));
        } else {
            this.setText(null);
            this.setTooltip(null);
        }
        this.setStyle(boldFont ? "-fx-font-weight: bold;" : null);
    }

    private String createTooltipText(IVarValue value, String valuetext) {
        StringBuilder txt = new StringBuilder();
        txt.append(String.format("Type:\t\t\t%s\r\n", value.getClass().getSimpleName()));
        if (value instanceof IStoredVarValue) {
            IStoredVarValue storedValue = (IStoredVarValue)value;
            txt.append(String.format("Start Timestamp:\t%s\r\n", TimeFormatType.DateTimeHMsMs.format((TemporalAccessor)Instant.ofEpochMilli(storedValue.getStartTimestamp()).atZone(ZoneOffset.systemDefault()))));
        }
        txt.append(String.format("End Timestamp:\t%s\r\n", TimeFormatType.DateTimeHMsMs.format((TemporalAccessor)Instant.ofEpochMilli(value.getEndTimestamp()).atZone(ZoneOffset.systemDefault()))));
        txt.append(String.format("Value:\t\t\t%s\r\n", valuetext));
        txt.append(String.format("Quality:\t\t\t%.2f", value.getQuality()));
        return txt.toString();
    }

    public void updateItem(VarTableCellData item, boolean empty) {
        super.updateItem((Object)item, empty);
        LinkedList<String> classes = new LinkedList<String>();
        if (this.isEmpty()) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            this.setText(null);
            NumericField nf = this.getNumberField();
            nf.setValue((Number)item.getVarValue().getValue());
            this.setGraphic((Node)nf);
        } else {
            if (item != null && item.getObject() != null) {
                Object object;
                if (((VarTableCellData)this.getItem()).isSummary()) {
                    classes.add("summary");
                }
                if ((object = item.getVarValue()) == null) {
                    object = item.getObject();
                }
                this.setTooltip(null);
                if (object instanceof IVarValue) {
                    classes.add("var-value");
                    Object val = object;
                    if (!val.isValid()) {
                        classes.add("invalid");
                    }
                    if (val instanceof SupplementValue) {
                        classes.add("supplement");
                    }
                    this.formatTextCell((IVarValue)val);
                } else if (object instanceof Aggregation) {
                    this.setText(object.toString());
                    classes.add("aggregation");
                } else if (object instanceof Number) {
                    Number number = (Number)object;
                    this.setText(Integer.toString(number.intValue()));
                    classes.add("number");
                } else {
                    this.setText(object.toString());
                    classes.add("text");
                }
            } else {
                classes.add("empty");
                this.setText(null);
            }
            classes.add(this.isEditableItem() ? (this.isLockedItem() ? "locked" : "editable") : "readonly");
            this.setGraphic(null);
        }
        this.setStyleClass(classes.toArray(new String[0]));
    }

    protected NumericField getNumberField() {
        if (this.numberField == null) {
            this.numberField = this.createNumericField();
        }
        return this.numberField;
    }

    protected NumericField createNumericField() {
        NumericField numberField = new NumericField(Double.class, this.displayMU.getValueFormat(this.displayMUFormat));
        numberField.setShowAllFractionDigits(true);
        numberField.setOnAction(event -> {
            if (event.getTarget() instanceof Button) {
                return;
            }
            try {
                Number value = numberField.getValue();
                IVarValue newItemVal = this.createIVarValue(value);
                this.commitEdit(new VarTableCellData(((VarTableCellData)this.getItem()).getInstance(), this.displayMU, this.displayMUFormat, (Object)newItemVal, ((VarTableCellData)this.getItem()).isLockedCell()));
            }
            catch (Exception exception) {
                this.escapePressed = true;
                this.cancelEdit();
            }
            this.requestFocus();
        });
        numberField.setOnKeyPressed(t -> {
            this.escapePressed = t.getCode() == KeyCode.ESCAPE;
        });
        numberField.setOnKeyReleased(t -> {
            if (t.getCode() == KeyCode.ESCAPE) {
                this.cancelEdit();
                t.consume();
            }
        });
        numberField.focusedProperty().addListener((o, ov, nv) -> {
            if (ov.booleanValue() && !nv.booleanValue()) {
                IVarValue prevItemVal = ((VarTableCellData)this.getItem()).getVarValue();
                Double prevVal = prevItemVal != null ? (Double.isNaN(prevItemVal.getValue()) ? null : Double.valueOf(prevItemVal.getValue())) : null;
                Number newVal = numberField.getValue();
                if (newVal == null && prevVal != null || newVal != null && prevVal == null || newVal != null && !newVal.equals(prevVal)) {
                    IVarValue newItemVal = this.createIVarValue(newVal);
                    this.commitEdit(new VarTableCellData(((VarTableCellData)this.getItem()).getInstance(), this.displayMU, this.displayMUFormat, (Object)newItemVal, ((VarTableCellData)this.getItem()).isLockedCell()));
                } else {
                    this.commitEdit((VarTableCellData)this.getItem());
                }
            }
        });
        return numberField;
    }

    protected IVarValue createIVarValue(Number displayValue) {
        if (displayValue == null) {
            return new VarValue(0L, Double.NaN, 0.0, ValueSource.NaN);
        }
        double value = this.valueMU.convert(displayValue.doubleValue(), this.displayMU);
        return new SupplementValue(0L, 0L, value, Instant.now().toEpochMilli(), 0);
    }

    private void setStyleClass(String ... classNames) {
        LinkedList<String> defaultClasses = new LinkedList<String>(this.defaultClasses);
        if (classNames != null) {
            String[] stringArray = classNames;
            int n = classNames.length;
            int n2 = 0;
            while (n2 < n) {
                String className = stringArray[n2];
                defaultClasses.add(className);
                ++n2;
            }
        }
        this.getStyleClass().setAll(defaultClasses);
    }

    private boolean isEditableItem() {
        return this.isEditable() && this.getTreeTableView().isEditable() && this.getTableColumn().isEditable() && this.getItem() != null && !((VarTableCellData)this.getItem()).isSummary() && ((VarTableCellData)this.getItem()).getInstance() != null && ((VarTableCellData)this.getItem()).getInstance().getSupplementValueStrategy() != null;
    }

    private boolean isLockedItem() {
        return ((VarTableCellData)this.getItem()).isLockedCell();
    }

    private boolean canEdit() {
        return this.isEditableItem() && !this.isLockedItem();
    }
}

