/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.lang;

import de.elpro.ewms.core.lang.model.AnalysisError;
import de.elpro.ewms.core.lang.script.ScriptTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Script {
    private final ScriptTree tree;
    private final List<AnalysisError> lexerErrors = new ArrayList<AnalysisError>();
    private final List<AnalysisError> parserErrors = new ArrayList<AnalysisError>();

    public Script(ScriptTree tree) {
        this.tree = tree;
    }

    public ScriptTree getTree() {
        return this.tree;
    }

    public List<AnalysisError> getLexerErrors() {
        return Collections.unmodifiableList(this.lexerErrors);
    }

    public List<AnalysisError> getParserErrors() {
        return Collections.unmodifiableList(this.parserErrors);
    }

    void addLexerErrors(List<AnalysisError> exceptions) {
        this.lexerErrors.addAll(exceptions);
    }

    void addParserErrors(List<AnalysisError> exceptions) {
        this.parserErrors.addAll(exceptions);
    }

    public List<AnalysisError> getErrors() {
        ArrayList<AnalysisError> errors = new ArrayList<AnalysisError>();
        errors.addAll(this.lexerErrors);
        errors.addAll(this.parserErrors);
        return Collections.unmodifiableList(errors);
    }
}

