/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.lang;

import de.elpro.ewms.core.lang.Script;
import de.elpro.ewms.core.lang.bundle.Activator;
import de.elpro.ewms.core.lang.def.EOSExErrorStrategy;
import de.elpro.ewms.core.lang.def.EOSExLexer;
import de.elpro.ewms.core.lang.def.EOSExLexerErrorListener;
import de.elpro.ewms.core.lang.def.EOSExParser;
import de.elpro.ewms.core.lang.def.EOSExScriptVisitor;
import de.elpro.ewms.core.lang.model.AnalysisError;
import de.elpro.ewms.core.lang.model.AnalysisErrorSeverity;
import de.elpro.ewms.core.lang.script.ScriptTree;
import de.elpro.ewms.core.variable.calculated.FormulaNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.fx.core.log.Logger;

public class ScriptParser {
    public static final Logger logger = Activator.getLoggerFactory() != null ? Activator.getLoggerFactory().createLogger(ScriptParser.class.getName()) : null;
    private static final Map<String, FormulaNode> CACHE = new HashMap<String, FormulaNode>();
    private static final FormulaNode ERROR_NODE = new FormulaNode(null);

    public static Script parse(String scriptString) {
        if (scriptString == null || scriptString.trim().isEmpty()) {
            return null;
        }
        CodePointCharStream inputStream = CharStreams.fromString((String)scriptString);
        EOSExLexer markupLexer = new EOSExLexer((CharStream)inputStream);
        EOSExLexerErrorListener lexerErrorListener = new EOSExLexerErrorListener();
        markupLexer.removeErrorListeners();
        markupLexer.addErrorListener((ANTLRErrorListener)lexerErrorListener);
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)markupLexer);
        EOSExParser markupParser = new EOSExParser((TokenStream)commonTokenStream);
        EOSExLexerErrorListener parserErrorListener = new EOSExLexerErrorListener();
        markupParser.removeErrorListeners();
        markupParser.addErrorListener((ANTLRErrorListener)parserErrorListener);
        EOSExErrorStrategy errorStrategy = new EOSExErrorStrategy();
        markupParser.setErrorHandler((ANTLRErrorStrategy)errorStrategy);
        EOSExScriptVisitor visitor = new EOSExScriptVisitor();
        EOSExParser.CalculationScriptContext context = markupParser.calculationScript();
        Script script = new Script((ScriptTree)visitor.visit((ParseTree)context));
        script.addLexerErrors(lexerErrorListener.getErrors());
        script.addParserErrors(parserErrorListener.getErrors());
        script.addParserErrors(errorStrategy.getErrors());
        return script;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static FormulaNode parseFormula(String formula) {
        if (formula == null || formula.trim().isEmpty()) {
            return null;
        }
        formula = formula.trim();
        Map<String, FormulaNode> map = CACHE;
        synchronized (map) {
            FormulaNode cachedNode = CACHE.get(formula);
            if (cachedNode != null) {
                if (cachedNode == ERROR_NODE) {
                    return null;
                }
                return cachedNode;
            }
        }
        try {
            Script script = ScriptParser.parse(formula);
            List<AnalysisError> errors = script.getErrors();
            for (AnalysisError error : errors) {
                if (error.getSeverity() != AnalysisErrorSeverity.ERROR) continue;
                StringBuilder builder = new StringBuilder();
                builder.append("Error parsing calculation script:\r\n");
                String[] lines = formula.split("\\r?\\n");
                int i = 0;
                while (i < lines.length) {
                    builder.append(lines[i]);
                    int numTabs = lines[i].split("\\t").length - 1;
                    if (error.getLocation().getStartLine() == i + 1) {
                        builder.append("\r\n");
                        if (numTabs > 0) {
                            int t = 0;
                            while (t < numTabs) {
                                builder.append("-------");
                                ++t;
                            }
                        }
                        int c = 0;
                        while (c < error.getLocation().getStartColumn()) {
                            builder.append('-');
                            ++c;
                        }
                        builder.append("^ - ");
                        builder.append(error.getMessage());
                    }
                    builder.append("\r\n");
                    ++i;
                }
                logger.error(builder.toString());
                Map<String, FormulaNode> map2 = CACHE;
                synchronized (map2) {
                    CACHE.put(formula, ERROR_NODE);
                }
                return null;
            }
            ScriptTree tree = script.getTree();
            tree.normalize();
            tree.reduce();
            FormulaNode node = tree.toFormula();
            Map<String, FormulaNode> map3 = CACHE;
            synchronized (map3) {
                CACHE.put(formula, node);
            }
            return node;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void main(String[] args) {
        String text = "var dv = Delta($K_in.SGas.p_minsky.vc->Auto); //Druck\u00e4nderung (Kavernen-Innendruck) innerhalb der Zeitfensters\r\nvar dt_dv = $K_in.SGas.T/p_minsky.vp->Auto; //Temperaturver\u00e4nderung pro [bar] (Konstantwert)\r\nvar dt = dt_dv * dv; //Temperaturver\u00e4nderung\r\nreturn ReBound(dt, 0.0006 @ Raster = Hour);";
        System.out.println("\nNow testing: " + text + "\n");
        Script script = ScriptParser.parse(text);
        System.err.println(script.getErrors());
        FormulaNode formula = ScriptParser.parseFormula(text);
        System.out.println(formula);
        System.out.println(formula.containsCumulativeOperation());
        text = "-1E-10 - Sum(1, 2E-10 + 2)";
        script = ScriptParser.parse(text);
        System.err.println(script.getErrors());
        formula = ScriptParser.parseFormula(text);
        System.out.println(formula);
        System.out.println(formula.containsCumulativeOperation());
        formula = ScriptParser.parseFormula("EndTimestamp(1)");
        System.out.println(formula);
    }
}

