/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.lang.def;

import de.elpro.ewms.core.lang.model.AnalysisError;
import de.elpro.ewms.core.lang.model.AnalysisErrorSeverity;
import de.elpro.ewms.core.lang.model.Location;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.FailedPredicateException;
import org.antlr.v4.runtime.InputMismatchException;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;

public class EOSExErrorStrategy
extends DefaultErrorStrategy {
    private ArrayList<AnalysisError> errors = new ArrayList();

    public void reportError(Parser recognizer, RecognitionException e) {
        if (this.inErrorRecoveryMode(recognizer)) {
            return;
        }
        this.beginErrorCondition(recognizer);
        Token offendingToken = e.getOffendingToken();
        Location location = new Location();
        location.setOffset(offendingToken.getStartIndex());
        location.setLength(offendingToken.getStopIndex() - offendingToken.getStartIndex() + 1);
        location.setStartLine(offendingToken.getLine());
        location.setStartColumn(offendingToken.getCharPositionInLine());
        AnalysisError error = new AnalysisError();
        error.setLocation(location);
        error.setSeverity(AnalysisErrorSeverity.ERROR);
        if (e instanceof NoViableAltException) {
            NoViableAltException nve = (NoViableAltException)e;
            TokenStream tokens = recognizer.getInputStream();
            String input = tokens != null ? (nve.getStartToken().getType() == -1 ? "<EOF>" : tokens.getText(nve.getStartToken(), e.getOffendingToken())) : "<unknown input>";
            String msg = "no viable alternative at input " + this.escapeWSAndQuote(input);
            error.setMessage(msg);
        } else if (e instanceof InputMismatchException) {
            String msg = "mismatched input " + this.getTokenErrorDisplay(e.getOffendingToken()) + " expecting " + e.getExpectedTokens().toString(recognizer.getVocabulary());
            error.setMessage(msg);
        } else if (e instanceof FailedPredicateException) {
            String ruleName = recognizer.getRuleNames()[recognizer.getRuleContext().getRuleIndex()];
            String msg = "rule " + ruleName + " " + e.getMessage();
            error.setMessage(msg);
        } else {
            error.setMessage("unknown recognition error type: " + e.getClass().getName());
        }
        this.errors.add(error);
    }

    public List<AnalysisError> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    protected void reportNoViableAlternative(Parser recognizer, NoViableAltException e) {
        super.reportNoViableAlternative(recognizer, e);
    }

    protected void reportInputMismatch(Parser recognizer, InputMismatchException e) {
        super.reportInputMismatch(recognizer, e);
    }

    protected void reportFailedPredicate(Parser recognizer, FailedPredicateException e) {
        super.reportFailedPredicate(recognizer, e);
    }

    public void reset(Parser recognizer) {
        super.reset(recognizer);
    }
}

