/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.lang.def;

import de.elpro.ewms.core.lang.model.AnalysisError;
import de.elpro.ewms.core.lang.model.AnalysisErrorSeverity;
import de.elpro.ewms.core.lang.model.Location;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.LexerNoViableAltException;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;

public class EOSExLexerErrorListener
extends BaseErrorListener {
    private ArrayList<AnalysisError> errors = new ArrayList();

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        Location location = new Location();
        if (offendingSymbol instanceof Token) {
            Token token = (Token)offendingSymbol;
            location.setOffset(token.getStartIndex());
            location.setLength(token.getStopIndex() - token.getStartIndex() + 1);
            location.setStartLine(token.getLine());
            location.setStartColumn(token.getCharPositionInLine());
        } else {
            if (e instanceof LexerNoViableAltException) {
                LexerNoViableAltException nve = (LexerNoViableAltException)e;
                location.setOffset(nve.getStartIndex());
                location.setLength(1);
            }
            location.setStartLine(line);
            location.setStartColumn(charPositionInLine);
        }
        AnalysisError error = new AnalysisError();
        error.setLocation(location);
        error.setSeverity(AnalysisErrorSeverity.ERROR);
        error.setMessage(msg);
        this.errors.add(error);
    }

    public List<AnalysisError> getErrors() {
        return Collections.unmodifiableList(this.errors);
    }
}

