/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.lang.def;

import de.elpro.ewms.core.lang.def.EOSExBaseVisitor;
import de.elpro.ewms.core.lang.def.EOSExParser;
import de.elpro.ewms.core.lang.script.CalculationExpressionRootNode;
import de.elpro.ewms.core.lang.script.CalculationScriptRootNode;
import de.elpro.ewms.core.lang.script.Characteristic2DInstanceReferenceNode;
import de.elpro.ewms.core.lang.script.Characteristic2DReferenceNode;
import de.elpro.ewms.core.lang.script.Characteristic3DExtremeLineInstanceReferenceNode;
import de.elpro.ewms.core.lang.script.Characteristic3DExtremeLineReferenceNode;
import de.elpro.ewms.core.lang.script.Characteristic3DInstanceReferenceNode;
import de.elpro.ewms.core.lang.script.Characteristic3DReferenceNode;
import de.elpro.ewms.core.lang.script.ConstantNode;
import de.elpro.ewms.core.lang.script.FunctionNode;
import de.elpro.ewms.core.lang.script.FunctionParameterNode;
import de.elpro.ewms.core.lang.script.FunctionParameterValue;
import de.elpro.ewms.core.lang.script.FunctionParametersNode;
import de.elpro.ewms.core.lang.script.NaNNode;
import de.elpro.ewms.core.lang.script.NumberNode;
import de.elpro.ewms.core.lang.script.PropertyInstanceReferenceNode;
import de.elpro.ewms.core.lang.script.PropertyReferenceNode;
import de.elpro.ewms.core.lang.script.ReturnNode;
import de.elpro.ewms.core.lang.script.ScriptTree;
import de.elpro.ewms.core.lang.script.TextNode;
import de.elpro.ewms.core.lang.script.UnrecodnizedFunctionNode;
import de.elpro.ewms.core.lang.script.VariableDefinitionNode;
import de.elpro.ewms.core.lang.script.VariableInstanceReferenceNode;
import de.elpro.ewms.core.lang.script.VariableNameNode;
import de.elpro.ewms.core.lang.script.VariableReferenceNode;
import de.elpro.ewms.core.structure.Property;
import de.elpro.ewms.core.structure.PropertyGroup;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.variable.calculated.Characteristic2DInstanceReference;
import de.elpro.ewms.core.variable.calculated.Characteristic2DReference;
import de.elpro.ewms.core.variable.calculated.Characteristic3DExtremeLineInstanceReference;
import de.elpro.ewms.core.variable.calculated.Characteristic3DExtremeLineReference;
import de.elpro.ewms.core.variable.calculated.Characteristic3DInstanceReference;
import de.elpro.ewms.core.variable.calculated.Characteristic3DReference;
import de.elpro.ewms.core.variable.calculated.FormulaOperation;
import de.elpro.ewms.core.variable.calculated.PropertyInstanceReference;
import de.elpro.ewms.core.variable.calculated.PropertyReference;
import de.elpro.ewms.core.variable.calculated.VariableInstanceReference;
import de.elpro.ewms.core.variable.calculated.VariableReference;
import org.antlr.v4.runtime.ParserRuleContext;

public class EOSExScriptVisitor
extends EOSExBaseVisitor<ScriptTree> {
    protected ScriptTree defaultResult() {
        return new ScriptTree();
    }

    protected ScriptTree aggregateResult(ScriptTree aggregate, ScriptTree nextResult) {
        if (nextResult.getNode() != null) {
            aggregate.getSubTrees().add(nextResult);
        } else if (!nextResult.getSubTrees().isEmpty()) {
            aggregate.getSubTrees().addAll(nextResult.getSubTrees());
        }
        return aggregate;
    }

    @Override
    public ScriptTree visitVariableNameExpr(EOSExParser.VariableNameExprContext ctx) {
        ScriptTree result = (ScriptTree)super.visitVariableNameExpr(ctx);
        result.setNode(new VariableNameNode(ctx.getText(), (ParserRuleContext)ctx));
        return result;
    }

    @Override
    public ScriptTree visitNumberExpr(EOSExParser.NumberExprContext ctx) {
        ScriptTree result = (ScriptTree)super.visitNumberExpr(ctx);
        double number = Double.parseDouble(ctx.NUMBER().getText());
        result.setNode(new NumberNode(number, (ParserRuleContext)ctx));
        return result;
    }

    @Override
    public ScriptTree visitConstantExpr(EOSExParser.ConstantExprContext ctx) {
        ScriptTree result = (ScriptTree)super.visitConstantExpr(ctx);
        result.setNode(new ConstantNode(ctx.CONSTANT().getText(), (ParserRuleContext)ctx));
        return result;
    }

    @Override
    public ScriptTree visitTextExpr(EOSExParser.TextExprContext ctx) {
        ScriptTree result = (ScriptTree)super.visitTextExpr(ctx);
        String quotedText = ctx.TEXT().getText();
        String textContent = quotedText.substring(1, quotedText.length() - 1);
        result.setNode(new TextNode(textContent, (ParserRuleContext)ctx));
        return result;
    }

    @Override
    public ScriptTree visitNanExpr(EOSExParser.NanExprContext ctx) {
        ScriptTree result = (ScriptTree)super.visitNanExpr(ctx);
        result.setNode(new NaNNode(ctx));
        return result;
    }

    @Override
    public ScriptTree visitNotExpr(EOSExParser.NotExprContext ctx) {
        ScriptTree result = (ScriptTree)super.visitNotExpr(ctx);
        result.setNode(new FunctionNode(FormulaOperation.Not, (ParserRuleContext)ctx));
        return result;
    }

    @Override
    public ScriptTree visitPowerExpr(EOSExParser.PowerExprContext ctx) {
        ScriptTree result = (ScriptTree)super.visitPowerExpr(ctx);
        result.setNode(new FunctionNode(FormulaOperation.Power, (ParserRuleContext)ctx));
        return result;
    }

    @Override
    public ScriptTree visitIfThenElse(EOSExParser.IfThenElseContext ctx) {
        ScriptTree result = (ScriptTree)super.visitIfThenElse(ctx);
        result.setNode(new FunctionNode(FormulaOperation.If, (ParserRuleContext)ctx));
        return result;
    }

    @Override
    public ScriptTree visitMulDivExpr(EOSExParser.MulDivExprContext ctx) {
        ScriptTree result = (ScriptTree)super.visitMulDivExpr(ctx);
        if (ctx.operand.getType() == 30) {
            result.setNode(new FunctionNode(FormulaOperation.Mult, (ParserRuleContext)ctx));
        } else {
            result.setNode(new FunctionNode(FormulaOperation.Div, (ParserRuleContext)ctx));
        }
        return result;
    }

    @Override
    public ScriptTree visitAddSubExpr(EOSExParser.AddSubExprContext ctx) {
        ScriptTree result = (ScriptTree)super.visitAddSubExpr(ctx);
        if (ctx.operand.getType() == 32) {
            result.setNode(new FunctionNode(FormulaOperation.Sum, (ParserRuleContext)ctx));
        } else {
            result.setNode(new FunctionNode(FormulaOperation.Diff, (ParserRuleContext)ctx));
        }
        return result;
    }

    @Override
    public ScriptTree visitCompareGtLtExpr(EOSExParser.CompareGtLtExprContext ctx) {
        ScriptTree result = (ScriptTree)super.visitCompareGtLtExpr(ctx);
        if (ctx.operand.getType() == 34) {
            result.setNode(new FunctionNode(FormulaOperation.Ge, (ParserRuleContext)ctx));
        } else if (ctx.operand.getType() == 35) {
            result.setNode(new FunctionNode(FormulaOperation.Gt, (ParserRuleContext)ctx));
        } else if (ctx.operand.getType() == 36) {
            result.setNode(new FunctionNode(FormulaOperation.Le, (ParserRuleContext)ctx));
        } else {
            result.setNode(new FunctionNode(FormulaOperation.Lt, (ParserRuleContext)ctx));
        }
        return result;
    }

    @Override
    public ScriptTree visitCompareEqNeqExpr(EOSExParser.CompareEqNeqExprContext ctx) {
        ScriptTree result = (ScriptTree)super.visitCompareEqNeqExpr(ctx);
        if (ctx.operand.getType() == 38) {
            result.setNode(new FunctionNode(FormulaOperation.Eq, (ParserRuleContext)ctx));
        } else {
            result.setNode(new FunctionNode(FormulaOperation.NotEq, (ParserRuleContext)ctx));
        }
        return result;
    }

    @Override
    public ScriptTree visitBitAndOrExpr(EOSExParser.BitAndOrExprContext ctx) {
        ScriptTree result = (ScriptTree)super.visitBitAndOrExpr(ctx);
        if (ctx.operand.getType() == 42) {
            result.setNode(new FunctionNode(FormulaOperation.BitAnd, (ParserRuleContext)ctx));
        } else {
            result.setNode(new FunctionNode(FormulaOperation.BitOr, (ParserRuleContext)ctx));
        }
        return result;
    }

    @Override
    public ScriptTree visitLogicalAndOrExpr(EOSExParser.LogicalAndOrExprContext ctx) {
        ScriptTree result = (ScriptTree)super.visitLogicalAndOrExpr(ctx);
        if (ctx.operand.getType() == 40) {
            result.setNode(new FunctionNode(FormulaOperation.And, (ParserRuleContext)ctx));
        } else {
            result.setNode(new FunctionNode(FormulaOperation.Or, (ParserRuleContext)ctx));
        }
        return result;
    }

    @Override
    public ScriptTree visitFunction(EOSExParser.FunctionContext ctx) {
        ScriptTree result = (ScriptTree)super.visitFunction(ctx);
        String functionName = ctx.getChild(0).getText();
        try {
            FormulaOperation operation = Enum.valueOf(FormulaOperation.class, functionName);
            result.setNode(new FunctionNode(operation, (ParserRuleContext)ctx));
        }
        catch (Exception exception) {
            result.setNode(new UnrecodnizedFunctionNode(functionName, (ParserRuleContext)ctx));
        }
        return result;
    }

    @Override
    public ScriptTree visitFunctionArguments(EOSExParser.FunctionArgumentsContext ctx) {
        ScriptTree result = (ScriptTree)super.visitFunctionArguments(ctx);
        return result;
    }

    @Override
    public ScriptTree visitFunctionParameters(EOSExParser.FunctionParametersContext ctx) {
        ScriptTree result = (ScriptTree)super.visitFunctionParameters(ctx);
        result.setNode(new FunctionParametersNode(ctx));
        return result;
    }

    @Override
    public ScriptTree visitFunctionParameter(EOSExParser.FunctionParameterContext ctx) {
        ScriptTree result = (ScriptTree)super.visitFunctionParameter(ctx);
        if (ctx.functionParameterName() != null && ctx.functionParameterName().UW() != null) {
            result.setNode(new FunctionParameterNode(ctx.functionParameterName().UW().getText(), (ParserRuleContext)ctx));
        }
        return result;
    }

    @Override
    public ScriptTree visitFunctionParameterValue(EOSExParser.FunctionParameterValueContext ctx) {
        ScriptTree result = (ScriptTree)super.visitFunctionParameterValue(ctx);
        result.setNode(new FunctionParameterValue(ctx.getText(), (ParserRuleContext)ctx));
        return result;
    }

    @Override
    public ScriptTree visitPropertyRef(EOSExParser.PropertyRefContext ctx) {
        ScriptTree result = (ScriptTree)super.visitPropertyRef(ctx);
        String propertyKey = ctx.PROPERTY().getText();
        String[] parts = propertyKey.split("\\.");
        Property prop = new Property(new PropertyGroup(null, parts[0]), parts[1], null);
        if (ctx.SEARCH_POLICY() != null) {
            SearchPolicy searchPolicy = Enum.valueOf(SearchPolicy.class, ctx.SEARCH_POLICY().getText());
            PropertyReference pr = new PropertyReference(prop, searchPolicy);
            result.setNode(new PropertyReferenceNode(pr, (ParserRuleContext)ctx));
        } else if (ctx.LW() != null) {
            String structureObjectKey = ctx.LW().getText();
            PropertyInstanceReference pri = new PropertyInstanceReference(prop, structureObjectKey);
            result.setNode(new PropertyInstanceReferenceNode(pri, (ParserRuleContext)ctx));
        }
        return result;
    }

    @Override
    public ScriptTree visitVariableRef(EOSExParser.VariableRefContext ctx) {
        ScriptTree result = (ScriptTree)super.visitVariableRef(ctx);
        String variableName = ctx.VARIABLE().getText();
        if (ctx.SEARCH_POLICY() != null) {
            SearchPolicy searchPolicy = Enum.valueOf(SearchPolicy.class, ctx.SEARCH_POLICY().getText());
            VariableReference varRef = new VariableReference(variableName, searchPolicy);
            result.setNode(new VariableReferenceNode(varRef, (ParserRuleContext)ctx));
        } else if (ctx.LW() != null) {
            String structureObjectKey = ctx.LW().getText();
            VariableInstanceReference varInstRef = new VariableInstanceReference(variableName, structureObjectKey);
            result.setNode(new VariableInstanceReferenceNode(varInstRef, (ParserRuleContext)ctx));
        }
        return result;
    }

    @Override
    public ScriptTree visitCharacteristic2DRef(EOSExParser.Characteristic2DRefContext ctx) {
        ScriptTree result = (ScriptTree)super.visitCharacteristic2DRef(ctx);
        String characteristicName = ctx.CHARACTERISTIC_2D().getText();
        if (ctx.SEARCH_POLICY() != null) {
            SearchPolicy searchPolicy = Enum.valueOf(SearchPolicy.class, ctx.SEARCH_POLICY().getText());
            Characteristic2DReference characteristicRef = new Characteristic2DReference(characteristicName, searchPolicy);
            result.setNode(new Characteristic2DReferenceNode(characteristicRef, (ParserRuleContext)ctx));
        } else if (ctx.LW() != null) {
            String structureObjectKey = ctx.LW().getText();
            Characteristic2DInstanceReference characteristicRef = new Characteristic2DInstanceReference(characteristicName, structureObjectKey);
            result.setNode(new Characteristic2DInstanceReferenceNode(characteristicRef, (ParserRuleContext)ctx));
        }
        return result;
    }

    @Override
    public ScriptTree visitCharacteristic3DRef(EOSExParser.Characteristic3DRefContext ctx) {
        ScriptTree result = (ScriptTree)super.visitCharacteristic3DRef(ctx);
        String characteristicName = ctx.CHARACTERISTIC_3D().getText();
        String zwSelection = "z";
        if (ctx.ZW_SELECTION() != null) {
            zwSelection = ctx.ZW_SELECTION().getText().substring(1, 2).toLowerCase();
        }
        if (ctx.SEARCH_POLICY() != null) {
            SearchPolicy searchPolicy = Enum.valueOf(SearchPolicy.class, ctx.SEARCH_POLICY().getText());
            Characteristic3DReference characteristicRef = new Characteristic3DReference(characteristicName, searchPolicy, zwSelection);
            result.setNode(new Characteristic3DReferenceNode(characteristicRef, (ParserRuleContext)ctx));
        } else if (ctx.LW() != null) {
            String structureObjectKey = ctx.LW().getText();
            Characteristic3DInstanceReference characteristicRef = new Characteristic3DInstanceReference(characteristicName, structureObjectKey, zwSelection);
            result.setNode(new Characteristic3DInstanceReferenceNode(characteristicRef, (ParserRuleContext)ctx));
        }
        return result;
    }

    @Override
    public ScriptTree visitCharacteristic3DExtremeLineRef(EOSExParser.Characteristic3DExtremeLineRefContext ctx) {
        ScriptTree result = (ScriptTree)super.visitCharacteristic3DExtremeLineRef(ctx);
        String characteristicName = ctx.CHARACTERISTIC_3D().getText();
        String extremeLineXYSelection = ctx.EXTREME_LINE_XY_SELECTION().getText();
        String xySelection = extremeLineXYSelection.substring(1, 2).toLowerCase();
        String minMaxSelection = extremeLineXYSelection.substring(6, 9).toLowerCase();
        String zwSelection = extremeLineXYSelection.substring(9, 10).toLowerCase();
        boolean searchForX = xySelection.equals("x");
        boolean searchForMinimum = minMaxSelection.equals("min");
        boolean searchForZ = zwSelection.equals("z");
        if (ctx.SEARCH_POLICY() != null) {
            SearchPolicy searchPolicy = Enum.valueOf(SearchPolicy.class, ctx.SEARCH_POLICY().getText());
            Characteristic3DExtremeLineReference characteristicExtremeLineRef = new Characteristic3DExtremeLineReference(characteristicName, searchPolicy, searchForX, searchForMinimum, searchForZ);
            result.setNode(new Characteristic3DExtremeLineReferenceNode(characteristicExtremeLineRef, (ParserRuleContext)ctx));
        } else if (ctx.LW() != null) {
            String structureObjectKey = ctx.LW().getText();
            Characteristic3DExtremeLineInstanceReference characteristicExtremeLineRef = new Characteristic3DExtremeLineInstanceReference(characteristicName, structureObjectKey, searchForX, searchForMinimum, searchForZ);
            result.setNode(new Characteristic3DExtremeLineInstanceReferenceNode(characteristicExtremeLineRef, (ParserRuleContext)ctx));
        }
        return result;
    }

    @Override
    public ScriptTree visitCalculationScript(EOSExParser.CalculationScriptContext ctx) {
        ScriptTree result = (ScriptTree)super.visitCalculationScript(ctx);
        if (ctx.expression() != null) {
            result.setNode(new CalculationExpressionRootNode(ctx));
        } else {
            result.setNode(new CalculationScriptRootNode(ctx));
        }
        return result;
    }

    @Override
    public ScriptTree visitVariableDefinition(EOSExParser.VariableDefinitionContext ctx) {
        ScriptTree result = (ScriptTree)super.visitVariableDefinition(ctx);
        if (ctx.LW() != null) {
            result.setNode(new VariableDefinitionNode(ctx.LW().getText(), (ParserRuleContext)ctx));
        }
        return result;
    }

    @Override
    public ScriptTree visitReturnResult(EOSExParser.ReturnResultContext ctx) {
        ScriptTree result = (ScriptTree)super.visitReturnResult(ctx);
        result.setNode(new ReturnNode(ctx));
        return result;
    }
}

