/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.auth;

import de.elpro.ewms.core.auth.GroupVariableRestriction;
import de.elpro.ewms.core.auth.User;
import de.elpro.resources.Icons;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleText;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ewms_auth_group")
@Access(value=AccessType.PROPERTY)
public class Group
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "auth/group";
    public static final URL DEFAULT_ICON = Icons.USER_GROUP_ITEM_URL;
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final StringProperty name = new SimpleStringProperty();
    private Set<User> users = new LinkedHashSet<User>();
    private Set<GroupVariableRestriction> variableRestrictions = new LinkedHashSet<GroupVariableRestriction>();

    public Group() {
    }

    public Group(int id) {
        this();
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_auth_group_sequence")
    @SequenceGenerator(name="ewms_auth_group_sequence", sequenceName="ewms_auth_group_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    protected void setId(int id) {
        this.id.set((Object)id);
    }

    public ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @Column(name="name", nullable=false, columnDefinition="TEXT")
    public String getName() {
        return (String)this.name.get();
    }

    @Transient
    public String getLocalName() {
        return LocaleText.tryParse((String)this.getName()).getTextOrDefault();
    }

    public void setName(String displayName) {
        this.name.set((Object)displayName);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    public Set<User> getUsers() {
        return this.users;
    }

    protected void setUsers(Set<User> users) {
        this.users = users;
    }

    public Set<GroupVariableRestriction> getVariableRestrictions() {
        return this.variableRestrictions;
    }

    protected void setVariableRestrictions(Set<GroupVariableRestriction> variableRestrictions) {
        this.variableRestrictions = variableRestrictions;
    }

    public String toString() {
        return this.getLocalName();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Group) {
            if (this.getId() == null) {
                return super.equals(obj);
            }
            if (this.getId().equals(((Group)obj).getId())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return Group.class.hashCode() + 17 * (Integer)this.id.get();
    }

    @Transient
    public String getIconUri() {
        return DEFAULT_ICON.toString();
    }
}

