/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LoginCredentialsValidator {
    public static final char[] SPECIAL_CHARS = new char[]{'\u00b0', '^', '!', '\u00a7', '$', '%', '&', '(', ')', '=', '?', '`', '\u00b4', '{', '}', '[', ']', '*', '\\', '/', '+', ',', '#', '\'', '~', '@', '\"'};

    public static List<String> checkLoginToken(String token, boolean notEmpty) {
        if (!notEmpty && token == null) {
            return null;
        }
        ArrayList<String> errors = null;
        if (notEmpty && (token == null || token.isBlank())) {
            return Collections.singletonList("Blank token");
        }
        if (token.contains(" ") || token.contains("\r") || token.contains("\n")) {
            errors = new ArrayList<String>();
            errors.add("Token should contain no empty or new line characters.");
        }
        ArrayList<Character> forbiddenCharacters = null;
        int i = 0;
        while (i < SPECIAL_CHARS.length) {
            if (token.indexOf(SPECIAL_CHARS[i]) >= 0) {
                if (forbiddenCharacters == null) {
                    forbiddenCharacters = new ArrayList<Character>();
                }
                forbiddenCharacters.add(Character.valueOf(SPECIAL_CHARS[i]));
            }
            ++i;
        }
        if (forbiddenCharacters != null) {
            if (errors == null) {
                errors = new ArrayList();
            }
            StringBuilder sb = new StringBuilder();
            for (Character c : forbiddenCharacters) {
                if (!sb.isEmpty()) {
                    sb.append(" ");
                }
                sb.append(c);
            }
            errors.add(String.format("Token should contain none of special characters: %s", sb));
        }
        return errors;
    }
}

