/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.auth;

import de.elpro.ewms.core.json.Exclude;
import de.elpro.resources.Icons;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import java.net.URL;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="ewms_auth_user", uniqueConstraints={@UniqueConstraint(columnNames={"domain", "login"})})
@Access(value=AccessType.PROPERTY)
public class User
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "auth/user";
    public static final URL DEFAULT_ICON = Icons.USER_ITEM_URL;
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final StringProperty domain = new SimpleStringProperty();
    private final StringProperty login = new SimpleStringProperty();
    private final StringProperty firstName = new SimpleStringProperty();
    private final StringProperty lastName = new SimpleStringProperty();
    private final StringProperty email = new SimpleStringProperty();
    @Exclude
    private final StringProperty encryptedPassword = new SimpleStringProperty();
    private final BooleanProperty active = new SimpleBooleanProperty(false);
    private final BooleanProperty admin = new SimpleBooleanProperty(false);
    private final BooleanProperty isWebUser = new SimpleBooleanProperty(false);

    public User() {
    }

    public User(int id) {
        this();
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_auth_user_sequence")
    @SequenceGenerator(name="ewms_auth_user_sequence", sequenceName="ewms_auth_user_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    protected void setId(int id) {
        this.id.set((Object)id);
    }

    public ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @Column(name="domain")
    public String getDomain() {
        return (String)this.domain.get();
    }

    public void setDomain(String domain) {
        this.domain.set((Object)domain);
    }

    public StringProperty domainProperty() {
        return this.domain;
    }

    @Column(name="login", nullable=false)
    public String getLogin() {
        return (String)this.login.get();
    }

    public void setLogin(String login) {
        this.login.set((Object)login);
    }

    public StringProperty loginProperty() {
        return this.login;
    }

    @Transient
    public String getLoginPhrase() {
        String domain = this.getDomain();
        if (domain != null) {
            domain = domain.trim();
        }
        if (domain != null && !domain.isBlank()) {
            return String.format("%s\\%s", domain, this.getLogin().trim());
        }
        return this.getLogin() != null ? this.getLogin().trim() : null;
    }

    @Column(name="first_name")
    public String getFirstName() {
        return (String)this.firstName.get();
    }

    public void setFirstName(String firstName) {
        this.firstName.set((Object)firstName);
    }

    public StringProperty firstNameProperty() {
        return this.firstName;
    }

    @Column(name="last_name")
    public String getLastName() {
        return (String)this.lastName.get();
    }

    public void setLastName(String lastName) {
        this.lastName.set((Object)lastName);
    }

    public StringProperty lastNameProperty() {
        return this.lastName;
    }

    @Column(name="email")
    public String getEmail() {
        return (String)this.email.get();
    }

    public void setEmail(String email) {
        this.email.set((Object)email);
    }

    public StringProperty emailProperty() {
        return this.email;
    }

    @Column(name="encrypted_password", columnDefinition="TEXT")
    public String getEncryptedPassword() {
        return (String)this.encryptedPassword.get();
    }

    public void setEncryptedPassword(String encryptedPassword) {
        this.encryptedPassword.set((Object)encryptedPassword);
    }

    public StringProperty encryptedPasswordProperty() {
        return this.encryptedPassword;
    }

    public boolean isActive() {
        return this.active.get();
    }

    public void setActive(boolean active) {
        this.active.set(active);
    }

    public BooleanProperty activeProperty() {
        return this.active;
    }

    public boolean isAdmin() {
        return this.admin.get();
    }

    public void setAdmin(boolean admin) {
        this.admin.set(admin);
    }

    public BooleanProperty adminProperty() {
        return this.admin;
    }

    @Transient
    public BooleanProperty isWebUserProperty() {
        return this.isWebUser;
    }

    @Transient
    public boolean isIsWebUser() {
        return this.isWebUserProperty().get();
    }

    public void setIsWebUser(boolean isWebUser) {
        this.isWebUserProperty().set(isWebUser);
    }

    public String toString() {
        if (this.getLastName() != null && !this.getLastName().isEmpty() && this.getFirstName() != null && !this.getFirstName().isEmpty()) {
            return String.format("%s, %s", this.getLastName(), this.getFirstName());
        }
        if (this.getLastName() != null && !this.getLastName().isEmpty()) {
            return this.getLastName();
        }
        if (this.getDomain() != null) {
            return String.format("%s\\%s", this.getDomain(), this.getLogin());
        }
        return this.getLogin();
    }

    public boolean equals(Object obj) {
        if (obj instanceof User) {
            if (this.getId() == null) {
                return super.equals(obj);
            }
            if (this.getId().equals(((User)obj).getId())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return User.class.hashCode() + 17 * (Integer)this.id.get();
    }

    @Transient
    public String getIconUri() {
        return DEFAULT_ICON.toString();
    }
}

