/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.characteristic;

import de.elpro.ewms.core.characteristic.Characteristic2DInstance;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.PhysicalUnit;
import de.elpro.ewms.core.variable.Location;
import de.elpro.ewms.core.variable.Medium;
import de.elpro.ewms.core.variable.Specialization;
import de.elpro.ewms.core.variable.ValuesBounds;
import de.elpro.resources.Resources;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="ewms_characteristic_2d", uniqueConstraints={@UniqueConstraint(columnNames={"structure_class", "location", "medium", "input_pu_id", "output_pu_id", "specialization"})})
@Access(value=AccessType.PROPERTY)
public class Characteristic2D
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "characteristic/2d";
    public static final URL DEFAULT_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/characteristic2D.png");
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final StringProperty key = new SimpleStringProperty();
    private final ObjectProperty<StructureClass> structureClass = new SimpleObjectProperty();
    private final ObjectProperty<Location> location = new SimpleObjectProperty();
    private final ObjectProperty<Medium> medium = new SimpleObjectProperty();
    private final ObjectProperty<PhysicalUnit> inputPhysicalUnit = new SimpleObjectProperty();
    private final ObjectProperty<MeasuringUnit> inputMeasuringUnit = new SimpleObjectProperty();
    private final ObjectProperty<PhysicalUnit> outputPhysicalUnit = new SimpleObjectProperty();
    private final ObjectProperty<MeasuringUnit> outputMeasuringUnit = new SimpleObjectProperty();
    private final ObjectProperty<Specialization> specialization = new SimpleObjectProperty();
    private final ObjectProperty<Specialization> specialization2 = new SimpleObjectProperty();
    private final StringProperty description = new SimpleStringProperty();
    private final ObjectProperty<ValuesBounds> inputValuesBounds = new SimpleObjectProperty();
    private final ObjectProperty<ValuesBounds> outputValuesBounds = new SimpleObjectProperty();
    private Set<String> roleIds = new LinkedHashSet<String>();
    private Set<Characteristic2DInstance> instances = new LinkedHashSet<Characteristic2DInstance>();
    private final StringProperty structureClassToken = new SimpleStringProperty();

    public Characteristic2D() {
    }

    public Characteristic2D(int id) {
        this();
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_characteristic_2d_sequence")
    @SequenceGenerator(name="ewms_characteristic_2d_sequence", sequenceName="ewms_characteristic_2d_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    protected void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @Column(name="key", unique=true, nullable=true)
    public String getKey() {
        return (String)this.keyProperty().get();
    }

    public void setKey(String key) {
        this.keyProperty().set((Object)key);
    }

    public final StringProperty keyProperty() {
        return this.key;
    }

    @ManyToOne
    @JoinColumn(name="structure_class", nullable=false)
    public StructureClass getStructureClass() {
        return (StructureClass)this.structureClass.get();
    }

    public void setStructureClass(StructureClass structureClass) {
        this.structureClass.set((Object)structureClass);
    }

    public final ObjectProperty<StructureClass> structureClassProperty() {
        return this.structureClass;
    }

    @Transient
    public String getStructureResultClassToken() {
        if (this.structureClassToken.get() == null) {
            if (this.getStructureClass() != null) {
                this.structureClassToken.set((Object)this.getStructureClass().getResultToken());
            } else {
                this.structureClassToken.set((Object)"unknown");
            }
        }
        return (String)this.structureClassToken.get();
    }

    public void setStructureClassResultToken(String token) {
        this.structureClassToken.set((Object)token);
    }

    @ManyToOne
    @JoinColumn(name="location")
    public Location getLocation() {
        return (Location)this.location.get();
    }

    public void setLocation(Location location) {
        this.location.set((Object)location);
    }

    public final ObjectProperty<Location> locationProperty() {
        return this.location;
    }

    @ManyToOne
    @JoinColumn(name="medium", nullable=false)
    public Medium getMedium() {
        return (Medium)this.medium.get();
    }

    public void setMedium(Medium medium) {
        this.medium.set((Object)medium);
    }

    public final ObjectProperty<Medium> mediumProperty() {
        return this.medium;
    }

    @Column(name="input_pu_id", nullable=false)
    public PhysicalUnit getInputPhysicalUnit() {
        return (PhysicalUnit)this.inputPhysicalUnit.get();
    }

    public void setInputPhysicalUnit(PhysicalUnit physicalUnit) {
        this.inputPhysicalUnit.set((Object)physicalUnit);
    }

    public final ObjectProperty<PhysicalUnit> inputPhysicalUnitProperty() {
        return this.inputPhysicalUnit;
    }

    @Column(name="input_mu_id", nullable=false)
    public MeasuringUnit getInputMeasuringUnit() {
        return (MeasuringUnit)this.inputMeasuringUnit.get();
    }

    public void setInputMeasuringUnit(MeasuringUnit measuringUnit) {
        this.inputMeasuringUnit.set((Object)measuringUnit);
    }

    public final ObjectProperty<MeasuringUnit> inputMeasuringUnitProperty() {
        return this.inputMeasuringUnit;
    }

    @Column(name="output_pu_id", nullable=false)
    public PhysicalUnit getOutputPhysicalUnit() {
        return (PhysicalUnit)this.outputPhysicalUnit.get();
    }

    public void setOutputPhysicalUnit(PhysicalUnit physicalUnit) {
        this.outputPhysicalUnit.set((Object)physicalUnit);
    }

    public final ObjectProperty<PhysicalUnit> outputPhysicalUnitProperty() {
        return this.outputPhysicalUnit;
    }

    @Column(name="output_mu_id", nullable=false)
    public MeasuringUnit getOutputMeasuringUnit() {
        return (MeasuringUnit)this.outputMeasuringUnit.get();
    }

    public void setOutputMeasuringUnit(MeasuringUnit measuringUnit) {
        this.outputMeasuringUnit.set((Object)measuringUnit);
    }

    public final ObjectProperty<MeasuringUnit> outputMeasuringUnitProperty() {
        return this.outputMeasuringUnit;
    }

    @ManyToOne
    @JoinColumn(name="specialization")
    public Specialization getSpecialization() {
        return (Specialization)this.specialization.get();
    }

    public void setSpecialization(Specialization specialization) {
        this.specialization.set((Object)specialization);
    }

    public final ObjectProperty<Specialization> specializationProperty() {
        return this.specialization;
    }

    @ManyToOne
    @JoinColumn(name="specialization_2")
    public Specialization getSpecialization2() {
        return (Specialization)this.specialization2.get();
    }

    public void setSpecialization2(Specialization specialization2) {
        this.specialization2.set((Object)specialization2);
    }

    public final ObjectProperty<Specialization> specialization2Property() {
        return this.specialization2;
    }

    @Column(name="description", columnDefinition="TEXT")
    public String getDescription() {
        return (String)this.description.get();
    }

    public void setDescription(String description) {
        this.description.set((Object)description);
    }

    public final StringProperty descriptionProperty() {
        return this.description;
    }

    @ManyToOne
    @JoinColumn(name="input_values_bounds")
    public ValuesBounds getInputValuesBounds() {
        return (ValuesBounds)this.inputValuesBounds.get();
    }

    public void setInputValuesBounds(ValuesBounds valuesBounds) {
        this.inputValuesBounds.set((Object)valuesBounds);
    }

    public final ObjectProperty<ValuesBounds> inputValuesBoundsProperty() {
        return this.inputValuesBounds;
    }

    @ManyToOne
    @JoinColumn(name="output_values_bounds")
    public ValuesBounds getOutputValuesBounds() {
        return (ValuesBounds)this.outputValuesBounds.get();
    }

    public void setOutputValuesBounds(ValuesBounds valuesBounds) {
        this.outputValuesBounds.set((Object)valuesBounds);
    }

    public final ObjectProperty<ValuesBounds> outputValuesBoundsProperty() {
        return this.outputValuesBounds;
    }

    @ElementCollection
    @CollectionTable(name="ewms_characteristic_2d_roles", joinColumns={@JoinColumn(name="characteristic_id")})
    @Column(name="role_id")
    public Set<String> getRoleIds() {
        return this.roleIds;
    }

    protected void setRoleIds(Set<String> roleIds) {
        this.roleIds = roleIds;
    }

    @OneToMany(mappedBy="characteristic")
    public Set<Characteristic2DInstance> getInstances() {
        return this.instances;
    }

    protected void setInstances(Set<Characteristic2DInstance> instances) {
        this.instances = instances;
    }

    public Characteristic2DInstance findInstance(StructureObject object) {
        for (Characteristic2DInstance instance : this.getInstances()) {
            if (!instance.getStructureObject().equals(object)) continue;
            return instance;
        }
        return null;
    }

    @Transient
    public String getIconUri() {
        return DEFAULT_ICON.toString();
    }

    public String toString() {
        if (this.getStructureClass() == null || this.getMedium() == null || this.getInputPhysicalUnit() == null || this.getOutputPhysicalUnit() == null) {
            return "undefined";
        }
        return String.format("%s%s.%s.%s~%s%s%s", this.getStructureResultClassToken(), this.getLocation() != null ? "_" + this.getLocation().getValue() : "", this.getMedium().getValue(), this.getInputPhysicalUnit().getName(), this.getOutputPhysicalUnit().getName(), this.getSpecialization() != null ? "_" + this.getSpecialization().getValue() : "", this.getSpecialization2() != null ? "_" + this.getSpecialization2().getValue() : "");
    }

    public boolean equals(Object obj) {
        if (obj instanceof Characteristic2D) {
            if (this.getId() == null) {
                return super.equals(obj);
            }
            if (this.getId().equals(((Characteristic2D)obj).getId())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return Characteristic2D.class.hashCode() + 17 * this.getId();
    }
}

