/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.characteristic;

import de.elpro.ewms.core.characteristic.Characteristic2D;
import de.elpro.ewms.core.characteristic.Characteristic2DFunction;
import de.elpro.ewms.core.characteristic.Characteristic2DFunctions;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.variable.ValuesBounds;
import de.elpro.resources.Resources;
import de.elpro.ui.model.CustomUILabelElement;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import java.net.URL;
import java.time.Instant;
import java.util.Set;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="ewms_characteristic_2d_instance", uniqueConstraints={@UniqueConstraint(columnNames={"characteristic", "structure_object"})})
@Access(value=AccessType.PROPERTY)
public class Characteristic2DInstance
extends CustomUILabelElement
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "characteristic/2d_instance";
    public static final URL ENABLED_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/characteristic2DInstance_enabled.png");
    public static final URL DISABLED_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/characteristic2DInstance_disabled.png");
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final ObjectProperty<Characteristic2D> characteristic = new SimpleObjectProperty();
    private final ObjectProperty<StructureObject> structureObject = new SimpleObjectProperty();
    private final ObjectProperty<ValuesBounds> inputValuesBounds = new SimpleObjectProperty();
    private final ObjectProperty<ValuesBounds> outputValuesBounds = new SimpleObjectProperty();
    private Characteristic2DFunctions functions = new Characteristic2DFunctions();

    public Characteristic2DInstance() {
    }

    public Characteristic2DInstance(Characteristic2D characteristic, StructureObject object) {
        this();
        this.setCharacteristic(characteristic);
        this.setStructureObject(object);
    }

    public Characteristic2DInstance(int id) {
        this();
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_characteristic_2d_instance_sequence")
    @SequenceGenerator(name="ewms_characteristic_2d_instance_sequence", sequenceName="ewms_characteristic_2d_instance_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    protected void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @ManyToOne
    @JoinColumn(name="characteristic", nullable=false)
    public Characteristic2D getCharacteristic() {
        return (Characteristic2D)this.characteristic.get();
    }

    public void setCharacteristic(Characteristic2D characteristic) {
        this.characteristic.set((Object)characteristic);
    }

    public final ObjectProperty<Characteristic2D> characteristicProperty() {
        return this.characteristic;
    }

    @ManyToOne
    @JoinColumn(name="structure_object", nullable=false)
    public StructureObject getStructureObject() {
        return (StructureObject)this.structureObject.get();
    }

    public void setStructureObject(StructureObject structureObject) {
        this.structureObject.set((Object)structureObject);
    }

    public final ObjectProperty<StructureObject> structureObjectProperty() {
        return this.structureObject;
    }

    @ManyToOne
    @JoinColumn(name="input_values_bounds")
    public ValuesBounds getInputValuesBounds() {
        return (ValuesBounds)this.inputValuesBounds.get();
    }

    public void setInputValuesBounds(ValuesBounds valuesBounds) {
        this.inputValuesBounds.set((Object)valuesBounds);
    }

    public final ObjectProperty<ValuesBounds> inputValuesBoundsProperty() {
        return this.inputValuesBounds;
    }

    @Transient
    public ValuesBounds getResultInputValuesBounds() {
        if (this.getInputValuesBounds() != null) {
            return this.getInputValuesBounds();
        }
        return this.getCharacteristic().getInputValuesBounds();
    }

    @ManyToOne
    @JoinColumn(name="output_values_bounds")
    public ValuesBounds getOutputValuesBounds() {
        return (ValuesBounds)this.outputValuesBounds.get();
    }

    public void setOutputValuesBounds(ValuesBounds valuesBounds) {
        this.outputValuesBounds.set((Object)valuesBounds);
    }

    public final ObjectProperty<ValuesBounds> outputValuesBoundsProperty() {
        return this.outputValuesBounds;
    }

    @Column(name="functions", columnDefinition="TEXT")
    public String getFunctionsSerialized() {
        if (this.functions == null) {
            return null;
        }
        return this.functions.toJson();
    }

    public void setFunctionsSerialized(String functionsSerialized) {
        this.functions = functionsSerialized == null ? new Characteristic2DFunctions() : Characteristic2DFunctions.parse(functionsSerialized);
    }

    @Transient
    public Characteristic2DFunctions getFunctions() {
        return this.functions;
    }

    public final void putFunction(Instant from, Characteristic2DFunction function) {
        this.functions.put(from, function);
    }

    @Transient
    public final Instant getCurrentFunctionTimestamp(Instant timestamp) {
        return this.functions.floorKey(timestamp);
    }

    @Transient
    public final Characteristic2DFunction getFunction(Instant beginTimestamp) {
        return (Characteristic2DFunction)this.functions.get(beginTimestamp);
    }

    @Transient
    public final Set<Instant> getFunctionsBeginTimestamps() {
        return this.functions.keySet();
    }

    public final void removeFunction(Instant beginTimestamp) {
        this.functions.remove(beginTimestamp);
    }

    @Transient
    public ValuesBounds getResultOutputValuesBounds() {
        if (this.getOutputValuesBounds() != null) {
            return this.getOutputValuesBounds();
        }
        return this.getCharacteristic().getOutputValuesBounds();
    }

    public String toString() {
        if (this.buildTextLableCallback != null) {
            return this.buildTextLableCallback.buildTextLabel((CustomUILabelElement)this);
        }
        if (this.getStructureObject() != null) {
            return this.getStructureObject().toString();
        }
        return this.getId().toString();
    }

    @Transient
    public String getFullName() {
        return String.format("%s - %s", this.getCharacteristic(), this.getStructureObject());
    }

    @Transient
    public String getIconUri() {
        return DISABLED_ICON.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Characteristic2DInstance) {
            if (this.getId() == null) {
                return super.equals(obj);
            }
            if (this.getId().equals(((Characteristic2DInstance)((Object)obj)).getId())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return Characteristic2DInstance.class.hashCode() + 17 * this.getId();
    }
}

