/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.characteristic;

import de.elpro.ewms.core.characteristic.Characteristic3DInstance;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.structure.StructureObject;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.PhysicalUnit;
import de.elpro.ewms.core.variable.Location;
import de.elpro.ewms.core.variable.Medium;
import de.elpro.ewms.core.variable.Specialization;
import de.elpro.resources.Resources;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.SortNatural;

@Entity
@Table(name="ewms_characteristic_3d", uniqueConstraints={@UniqueConstraint(columnNames={"structure_class", "location", "medium", "input_x_axis_pu_id", "input_y_axis_pu_id", "output_z_axis_pu_id", "output_w_axis_pu_id", "specialization"})})
@Access(value=AccessType.PROPERTY)
public class Characteristic3D
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "characteristic/3d";
    public static final URL DEFAULT_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/characteristic3D_V2.png");
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final StringProperty key = new SimpleStringProperty();
    private final ObjectProperty<StructureClass> structureClass = new SimpleObjectProperty();
    private final ObjectProperty<Location> location = new SimpleObjectProperty();
    private final ObjectProperty<Medium> medium = new SimpleObjectProperty();
    private final ObjectProperty<PhysicalUnit> inputXAxisPhysicalUnit = new SimpleObjectProperty();
    private final ObjectProperty<MeasuringUnit> inputXAxisMeasuringUnit = new SimpleObjectProperty();
    private final ObjectProperty<PhysicalUnit> inputYAxisPhysicalUnit = new SimpleObjectProperty();
    private final ObjectProperty<MeasuringUnit> inputYAxisMeasuringUnit = new SimpleObjectProperty();
    private final ObjectProperty<PhysicalUnit> outputZAxisPhysicalUnit = new SimpleObjectProperty();
    private final ObjectProperty<MeasuringUnit> outputZAxisMeasuringUnit = new SimpleObjectProperty();
    private final ObjectProperty<PhysicalUnit> outputWAxisPhysicalUnit = new SimpleObjectProperty();
    private final ObjectProperty<MeasuringUnit> outputWAxisMeasuringUnit = new SimpleObjectProperty();
    private final ObjectProperty<Specialization> specialization = new SimpleObjectProperty();
    private final ObjectProperty<Specialization> specialization2 = new SimpleObjectProperty();
    private final StringProperty description = new SimpleStringProperty();
    private Set<String> roleIds = new LinkedHashSet<String>();
    private SortedSet<Characteristic3DInstance> instances = new TreeSet<Characteristic3DInstance>();
    private final StringProperty structureClassToken = new SimpleStringProperty();

    public Characteristic3D() {
    }

    public Characteristic3D(int id) {
        this();
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_characteristic_3d_sequence")
    @SequenceGenerator(name="ewms_characteristic_3d_sequence", sequenceName="ewms_characteristic_3d_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    protected void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @Column(name="key", unique=true, nullable=true)
    public String getKey() {
        return (String)this.keyProperty().get();
    }

    public void setKey(String key) {
        this.keyProperty().set((Object)key);
    }

    public final StringProperty keyProperty() {
        return this.key;
    }

    @ManyToOne
    @JoinColumn(name="structure_class", nullable=false)
    public StructureClass getStructureClass() {
        return (StructureClass)this.structureClass.get();
    }

    public void setStructureClass(StructureClass structureClass) {
        this.structureClass.set((Object)structureClass);
    }

    public final ObjectProperty<StructureClass> structureClassProperty() {
        return this.structureClass;
    }

    @Transient
    public String getStructureResultClassToken() {
        if (this.structureClassToken.get() == null) {
            if (this.getStructureClass() != null) {
                this.structureClassToken.set((Object)this.getStructureClass().getResultToken());
            } else {
                this.structureClassToken.set((Object)"unknown");
            }
        }
        return (String)this.structureClassToken.get();
    }

    public void setStructureClassResultToken(String token) {
        this.structureClassToken.set((Object)token);
    }

    @ManyToOne
    @JoinColumn(name="location")
    public Location getLocation() {
        return (Location)this.location.get();
    }

    public void setLocation(Location location) {
        this.location.set((Object)location);
    }

    public final ObjectProperty<Location> locationProperty() {
        return this.location;
    }

    @ManyToOne
    @JoinColumn(name="medium", nullable=false)
    public Medium getMedium() {
        return (Medium)this.medium.get();
    }

    public void setMedium(Medium medium) {
        this.medium.set((Object)medium);
    }

    public final ObjectProperty<Medium> mediumProperty() {
        return this.medium;
    }

    public ObjectProperty<PhysicalUnit> inputXAxisPhysicalUnitProperty() {
        return this.inputXAxisPhysicalUnit;
    }

    @Column(name="input_x_axis_pu_id", nullable=false)
    public PhysicalUnit getInputXAxisPhysicalUnit() {
        return (PhysicalUnit)this.inputXAxisPhysicalUnitProperty().get();
    }

    public void setInputXAxisPhysicalUnit(PhysicalUnit inputXAxisPhysicalUnit) {
        this.inputXAxisPhysicalUnitProperty().set((Object)inputXAxisPhysicalUnit);
    }

    public ObjectProperty<MeasuringUnit> inputXAxisMeasuringUnitProperty() {
        return this.inputXAxisMeasuringUnit;
    }

    @Column(name="input_x_axis_mu_id", nullable=false)
    public MeasuringUnit getInputXAxisMeasuringUnit() {
        return (MeasuringUnit)this.inputXAxisMeasuringUnitProperty().get();
    }

    public void setInputXAxisMeasuringUnit(MeasuringUnit inputXAxisMeasuringUnit) {
        this.inputXAxisMeasuringUnitProperty().set((Object)inputXAxisMeasuringUnit);
    }

    public ObjectProperty<PhysicalUnit> inputYAxisPhysicalUnitProperty() {
        return this.inputYAxisPhysicalUnit;
    }

    @Column(name="input_y_axis_pu_id", nullable=false)
    public PhysicalUnit getInputYAxisPhysicalUnit() {
        return (PhysicalUnit)this.inputYAxisPhysicalUnitProperty().get();
    }

    public void setInputYAxisPhysicalUnit(PhysicalUnit inputYAxisPhysicalUnit) {
        this.inputYAxisPhysicalUnitProperty().set((Object)inputYAxisPhysicalUnit);
    }

    public ObjectProperty<MeasuringUnit> inputYAxisMeasuringUnitProperty() {
        return this.inputYAxisMeasuringUnit;
    }

    @Column(name="input_y_axis_mu_id", nullable=false)
    public MeasuringUnit getInputYAxisMeasuringUnit() {
        return (MeasuringUnit)this.inputYAxisMeasuringUnitProperty().get();
    }

    public void setInputYAxisMeasuringUnit(MeasuringUnit inputYAxisMeasuringUnit) {
        this.inputYAxisMeasuringUnitProperty().set((Object)inputYAxisMeasuringUnit);
    }

    public ObjectProperty<PhysicalUnit> outputZAxisPhysicalUnitProperty() {
        return this.outputZAxisPhysicalUnit;
    }

    @Column(name="output_z_axis_pu_id", nullable=false)
    public PhysicalUnit getOutputZAxisPhysicalUnit() {
        return (PhysicalUnit)this.outputZAxisPhysicalUnitProperty().get();
    }

    public void setOutputZAxisPhysicalUnit(PhysicalUnit outputZAxisPhysicalUnit) {
        this.outputZAxisPhysicalUnitProperty().set((Object)outputZAxisPhysicalUnit);
    }

    public ObjectProperty<MeasuringUnit> outputZAxisMeasuringUnitProperty() {
        return this.outputZAxisMeasuringUnit;
    }

    @Column(name="output_z_axis_mu_id", nullable=false)
    public MeasuringUnit getOutputZAxisMeasuringUnit() {
        return (MeasuringUnit)this.outputZAxisMeasuringUnitProperty().get();
    }

    public void setOutputZAxisMeasuringUnit(MeasuringUnit outputZAxisMeasuringUnit) {
        this.outputZAxisMeasuringUnitProperty().set((Object)outputZAxisMeasuringUnit);
    }

    public ObjectProperty<PhysicalUnit> outputWAxisPhysicalUnitProperty() {
        return this.outputWAxisPhysicalUnit;
    }

    @Column(name="output_w_axis_pu_id", nullable=true)
    public PhysicalUnit getOutputWAxisPhysicalUnit() {
        return (PhysicalUnit)this.outputWAxisPhysicalUnitProperty().get();
    }

    public void setOutputWAxisPhysicalUnit(PhysicalUnit outputWAxisPhysicalUnit) {
        this.outputWAxisPhysicalUnitProperty().set((Object)outputWAxisPhysicalUnit);
    }

    public ObjectProperty<MeasuringUnit> outputWAxisMeasuringUnitProperty() {
        return this.outputWAxisMeasuringUnit;
    }

    @Column(name="output_w_axis_mu_id", nullable=true)
    public MeasuringUnit getOutputWAxisMeasuringUnit() {
        return (MeasuringUnit)this.outputWAxisMeasuringUnitProperty().get();
    }

    public void setOutputWAxisMeasuringUnit(MeasuringUnit outputWAxisMeasuringUnit) {
        this.outputWAxisMeasuringUnitProperty().set((Object)outputWAxisMeasuringUnit);
    }

    @ManyToOne
    @JoinColumn(name="specialization")
    public Specialization getSpecialization() {
        return (Specialization)this.specialization.get();
    }

    public void setSpecialization(Specialization specialization) {
        this.specialization.set((Object)specialization);
    }

    public final ObjectProperty<Specialization> specializationProperty() {
        return this.specialization;
    }

    @ManyToOne
    @JoinColumn(name="specialization_2")
    public Specialization getSpecialization2() {
        return (Specialization)this.specialization2.get();
    }

    public void setSpecialization2(Specialization specialization2) {
        this.specialization2.set((Object)specialization2);
    }

    public final ObjectProperty<Specialization> specialization2Property() {
        return this.specialization2;
    }

    @Column(name="description", columnDefinition="TEXT")
    public String getDescription() {
        return (String)this.description.get();
    }

    public void setDescription(String description) {
        this.description.set((Object)description);
    }

    public final StringProperty descriptionProperty() {
        return this.description;
    }

    @ElementCollection
    @CollectionTable(name="ewms_characteristic_3d_roles", joinColumns={@JoinColumn(name="characteristic_id")})
    @Column(name="role_id")
    public Set<String> getRoleIds() {
        return this.roleIds;
    }

    protected void setRoleIds(Set<String> roleIds) {
        this.roleIds = roleIds;
    }

    @OneToMany(mappedBy="characteristic")
    @SortNatural
    public Set<Characteristic3DInstance> getInstances() {
        return this.instances;
    }

    protected void setInstances(SortedSet<Characteristic3DInstance> instances) {
        this.instances = instances;
    }

    public Characteristic3DInstance findInstance(StructureObject object) {
        for (Characteristic3DInstance instance : this.getInstances()) {
            if (!instance.getStructureObject().equals(object)) continue;
            return instance;
        }
        return null;
    }

    @Transient
    public String getIconUri() {
        return DEFAULT_ICON.toString();
    }

    public String toString() {
        if (this.getStructureClass() == null || this.getMedium() == null || this.getInputXAxisPhysicalUnit() == null || this.getInputYAxisPhysicalUnit() == null || this.getOutputZAxisPhysicalUnit() == null) {
            return "undefined";
        }
        String formatString = this.getOutputWAxisPhysicalUnit() == null ? "%s%s.%s.<%s,%s>~<%s>%s%s" : "%s%s.%s.<%s,%s>~<%s,%s>%s%s";
        ArrayList<String> params = new ArrayList<String>(Arrays.asList(this.getStructureResultClassToken(), this.getLocation() != null ? "_" + this.getLocation().getValue() : "", this.getMedium().getValue() != null ? this.getMedium().getValue() : "", this.getInputXAxisPhysicalUnit().getName(), this.getInputYAxisPhysicalUnit().getName(), this.getOutputZAxisPhysicalUnit().getName()));
        if (this.getOutputWAxisPhysicalUnit() != null) {
            params.add(this.getOutputWAxisPhysicalUnit().getName());
        }
        params.add(this.getSpecialization() != null ? "_" + this.getSpecialization().getValue() : "");
        params.add(this.getSpecialization2() != null ? "_" + this.getSpecialization2().getValue() : "");
        String format = String.format(formatString, params.toArray());
        return format;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Characteristic3D) {
            if (this.getId() == null) {
                return super.equals(obj);
            }
            if (this.getId().equals(((Characteristic3D)obj).getId())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return Characteristic3D.class.hashCode() + 17 * this.getId();
    }
}

