/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.characteristic;

import de.elpro.ewms.core.characteristic.Characteristic3DExtremeLine;
import de.elpro.ewms.core.characteristic.ExtremePoint;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ui.fx.charts.xyz.series.XYAreaBounds;
import java.util.LinkedList;
import java.util.List;

public class Characteristic3DExtremeXLine
implements Characteristic3DExtremeLine {
    private final MeasuringUnit xAxisMU;
    private final MeasuringUnit yAxisMU;
    private final MeasuringUnit zAxisMU;
    private final MeasuringUnit wAxisMU;
    private final double minX;
    private final double maxX;
    private final int xAxisResolution;
    private final double[] yValues;
    private final double[] zValues;
    private final double[] wValues;

    public Characteristic3DExtremeXLine(boolean searchForMinimum, boolean overZ, MeasuringUnit xAxisMU, MeasuringUnit yAxisMU, MeasuringUnit zAxisMU, MeasuringUnit wAxisMU, double minX, double maxX, double minY, double maxY, int xAxisResolution, int yAxisResolution, double[][] zValues, double[][] wValues, XYAreaBounds xyAreaBounds) {
        this.xAxisMU = xAxisMU;
        this.yAxisMU = yAxisMU;
        this.zAxisMU = zAxisMU;
        this.wAxisMU = wAxisMU;
        this.minX = minX;
        this.maxX = maxX;
        this.xAxisResolution = xAxisResolution;
        this.yValues = new double[xAxisResolution];
        this.zValues = new double[xAxisResolution];
        this.wValues = (double[])(wAxisMU != null ? new double[xAxisResolution] : null);
        int xIndex = 0;
        while (xIndex < xAxisResolution) {
            double x = minX + (double)xIndex * (maxX - minX) / (double)(xAxisResolution - 1);
            double mZ = Double.NaN;
            double mW = Double.NaN;
            double mY = Double.NaN;
            int yIndex = 0;
            while (yIndex < yAxisResolution) {
                double y = minY + (double)yIndex * (maxY - minY) / (double)(yAxisResolution - 1);
                if (xyAreaBounds == null || xyAreaBounds.contains(x, y)) {
                    double v;
                    double d = v = overZ ? zValues[xIndex][yIndex] : wValues[xIndex][yIndex];
                    if (Double.isFinite(v)) {
                        if (!Double.isFinite(overZ ? mZ : mW)) {
                            mZ = zValues[xIndex][yIndex];
                            mW = wValues != null ? wValues[xIndex][yIndex] : Double.NaN;
                            mY = y;
                        } else if (searchForMinimum) {
                            double d2 = overZ ? mZ : mW;
                            if (v < d2) {
                                mZ = zValues[xIndex][yIndex];
                                mW = wValues != null ? wValues[xIndex][yIndex] : Double.NaN;
                                mY = y;
                            }
                        } else {
                            double d3 = overZ ? mZ : mW;
                            if (v > d3) {
                                mZ = zValues[xIndex][yIndex];
                                mW = wValues != null ? wValues[xIndex][yIndex] : Double.NaN;
                                mY = y;
                            }
                        }
                    }
                }
                ++yIndex;
            }
            this.yValues[xIndex] = mY;
            this.zValues[xIndex] = mZ;
            if (this.wValues != null) {
                this.wValues[xIndex] = mW;
            }
            ++xIndex;
        }
    }

    @Override
    public ExtremePoint getPoint(double atValue) {
        return this.getPoint(atValue, this.xAxisMU, this.yAxisMU, this.zAxisMU, this.wAxisMU);
    }

    @Override
    public ExtremePoint getPoint(double atX, MeasuringUnit xAxisMU, MeasuringUnit yAxisMU, MeasuringUnit zAxisMU, MeasuringUnit wAxisMU) {
        double wValue;
        double zValue;
        double yValue;
        double xValue = this.xAxisMU.convert(atX, xAxisMU);
        if (xValue < this.minX || xValue > this.maxX) {
            return null;
        }
        double xValueIndex = (xValue - this.minX) / (this.maxX - this.minX) * (double)(this.xAxisResolution - 1);
        if (xValueIndex != (double)((int)xValueIndex)) {
            double y1 = this.yValues[(int)xValueIndex];
            double y2 = this.yValues[(int)xValueIndex + 1];
            if (!Double.isFinite(y1) || !Double.isFinite(y2)) {
                return null;
            }
            double ratio = xValueIndex - (double)((int)xValueIndex);
            yValue = y1 + (y2 - y1) * ratio;
            double z1 = this.zValues[(int)xValueIndex];
            double z2 = this.zValues[(int)xValueIndex + 1];
            double w1 = this.wValues != null ? this.wValues[(int)xValueIndex] : Double.NaN;
            double w2 = this.wValues != null ? this.wValues[(int)xValueIndex + 1] : Double.NaN;
            zValue = z1 + (z2 - z1) * ratio;
            wValue = w1 + (w2 - w1) * ratio;
        } else {
            yValue = this.yValues[(int)xValueIndex];
            if (!Double.isFinite(yValue)) {
                return null;
            }
            zValue = this.zValues[(int)xValueIndex];
            wValue = this.wValues != null ? this.wValues[(int)xValueIndex] : Double.NaN;
        }
        return new ExtremePoint(atX, yAxisMU.convert(yValue, this.yAxisMU), zAxisMU.convert(zValue, this.zAxisMU), wAxisMU.convert(wValue, this.wAxisMU));
    }

    @Override
    public List<ExtremePoint> getPoints(MeasuringUnit xAxisMU, MeasuringUnit yAxisMU, MeasuringUnit zAxisMU, MeasuringUnit wAxisMU) {
        LinkedList<ExtremePoint> points = new LinkedList<ExtremePoint>();
        int xIndex = 0;
        while (xIndex < this.xAxisResolution) {
            double y = this.yValues[xIndex];
            if (Double.isFinite(y)) {
                double x = this.minX + (double)xIndex * (this.maxX - this.minX) / (double)(this.xAxisResolution - 1);
                double z = this.zValues[xIndex];
                double w = this.wValues != null ? this.wValues[xIndex] : Double.NaN;
                points.add(new ExtremePoint(xAxisMU.convert(x, this.xAxisMU), yAxisMU.convert(y, this.yAxisMU), zAxisMU.convert(z, this.zAxisMU), this.wValues != null ? wAxisMU.convert(w, this.wAxisMU) : Double.NaN));
            }
            ++xIndex;
        }
        return points;
    }
}

