/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.characteristic;

import de.elpro.ewms.core.characteristic.Characteristic3DExtremeLine;
import de.elpro.ewms.core.characteristic.Characteristic3DExtremeXLine;
import de.elpro.ewms.core.characteristic.Characteristic3DExtremeYLine;
import de.elpro.ewms.core.json.JsonUtils;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ui.fx.charts.xyz.series.AreaSurfaceEditMode;
import de.elpro.ui.fx.charts.xyz.series.XYAreaBounds;
import javafx.geometry.Point2D;

public class Characteristic3DFunction {
    private final MeasuringUnit xAxisMU;
    private final MeasuringUnit yAxisMU;
    private final MeasuringUnit zAxisMU;
    private final MeasuringUnit wAxisMU;
    private final double minX;
    private final double maxX;
    private final double minY;
    private final double maxY;
    private final int xAxisResolution;
    private final int yAxisResolution;
    private final double[][] zValues;
    private final double[][] wValues;
    private double[] xyBounds;
    private transient XYAreaBounds xyAreaBounds;
    private transient Characteristic3DExtremeLineCache<Characteristic3DExtremeXLine> extremeXLineCache;
    private transient Characteristic3DExtremeLineCache<Characteristic3DExtremeYLine> extremeYLineCache;

    public Characteristic3DFunction(MeasuringUnit xAxisMU, MeasuringUnit yAxisMU, MeasuringUnit zAxisMU, MeasuringUnit wAxisMU, double minX, double maxX, double minY, double maxY, int xAxisResolution, int yAxisResolution, double[] xyBounds) {
        this.xAxisMU = xAxisMU;
        this.yAxisMU = yAxisMU;
        this.zAxisMU = zAxisMU;
        this.wAxisMU = wAxisMU;
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.xAxisResolution = xAxisResolution;
        this.yAxisResolution = yAxisResolution;
        this.zValues = new double[xAxisResolution][yAxisResolution];
        this.wValues = (double[][])(wAxisMU != null ? new double[xAxisResolution][yAxisResolution] : null);
        this.xyBounds = xyBounds;
        if (xyBounds != null) {
            this.xyAreaBounds = new XYAreaBounds(xyBounds);
        }
    }

    public MeasuringUnit getXAxisMU() {
        return this.xAxisMU;
    }

    public MeasuringUnit getYAxisMU() {
        return this.yAxisMU;
    }

    public MeasuringUnit getZAxisMU() {
        return this.zAxisMU;
    }

    public MeasuringUnit getWAxisMU() {
        return this.wAxisMU;
    }

    public double[] getXValues() {
        return this.getXValues(this.xAxisMU);
    }

    public double[] getXValues(MeasuringUnit xAxisMU) {
        double[] returnArray = new double[this.xAxisResolution];
        int i = 0;
        while (i < this.xAxisResolution) {
            returnArray[i] = xAxisMU.convert(this.minX + (double)i * (this.maxX - this.minX) / (double)(this.xAxisResolution - 1), this.xAxisMU);
            ++i;
        }
        return returnArray;
    }

    public double[] getYValues() {
        return this.getYValues(this.yAxisMU);
    }

    public double[] getYValues(MeasuringUnit yAxisMU) {
        double[] returnArray = new double[this.yAxisResolution];
        int i = 0;
        while (i < this.yAxisResolution) {
            returnArray[i] = yAxisMU.convert(this.minY + (double)i * (this.maxY - this.minY) / (double)(this.yAxisResolution - 1), this.yAxisMU);
            ++i;
        }
        return returnArray;
    }

    public double getClosesYByXZ(MeasuringUnit xValueMU, double xValue, MeasuringUnit zValueMU, double zValue, boolean maximizeY, MeasuringUnit yValueMU, double yReferenceValue, double zReferenceValue) {
        if ((xValue = this.xAxisMU.convert(xValue, xValueMU)) < this.minX || xValue > this.maxX) {
            return Double.NaN;
        }
        yReferenceValue = this.yAxisMU.convert(yReferenceValue, yValueMU);
        zReferenceValue = this.zAxisMU.convert(zReferenceValue, zValueMU);
        zValue = this.zAxisMU.convert(zValue, zValueMU);
        double xValueIndex = (xValue - this.minX) / (this.maxX - this.minX) * (double)(this.xAxisResolution - 1);
        double xRatio = xValueIndex - (double)((int)xValueIndex);
        double distance = Math.abs(zValue - zReferenceValue);
        double yValue = yReferenceValue;
        XYAreaBounds xyBounds = this.getXYBounds();
        int i = 0;
        while (i < this.yAxisResolution - 1) {
            double z2;
            double y1Value = this.minY + (this.maxY - this.minY) * (double)i / (double)(this.yAxisResolution - 1);
            double y2Value = this.minY + (this.maxY - this.minY) * (double)(i + 1) / (double)(this.yAxisResolution - 1);
            double z1 = xRatio == 0.0 ? this.zValues[(int)xValueIndex][i] : this.zValues[(int)xValueIndex][i] + (this.zValues[(int)xValueIndex + 1][i] - this.zValues[(int)xValueIndex][i]) * xRatio;
            double d = z2 = xRatio == 0.0 ? this.zValues[(int)xValueIndex][i + 1] : this.zValues[(int)xValueIndex][i + 1] + (this.zValues[(int)xValueIndex + 1][i + 1] - this.zValues[(int)xValueIndex][i + 1]) * xRatio;
            if (z1 <= zValue && zValue <= z2 || z1 >= zValue && zValue >= z2) {
                double yRatio = (zValue - z1) / (z2 - z1);
                double yValueCand = y1Value + (y2Value - y1Value) * yRatio;
                if ((maximizeY && yValueCand > yReferenceValue || !maximizeY && yValueCand < yReferenceValue) && (xyBounds == null || xyBounds.contains(xValue, yValueCand))) {
                    return yValueMU.convert(yValueCand, this.yAxisMU);
                }
            }
            if (Math.abs(z1 - zValue) < distance && (maximizeY && y1Value > yReferenceValue || !maximizeY && y1Value < yReferenceValue) && (xyBounds == null || xyBounds.contains(xValue, y1Value))) {
                yValue = y1Value;
                distance = Math.abs(z1 - zValue);
            }
            if (Math.abs(z2 - zValue) < distance && (maximizeY && y2Value > yReferenceValue || !maximizeY && y2Value < yReferenceValue) && (xyBounds == null || xyBounds.contains(xValue, y2Value))) {
                yValue = y2Value;
                distance = Math.abs(z2 - zValue);
            }
            ++i;
        }
        return yValue;
    }

    public void setZValues(double[][] zValues) {
        if (zValues.length != this.zValues.length) {
            throw new IllegalArgumentException("given zValues size does not match needed size");
        }
        int x = 0;
        while (x < zValues.length) {
            if (zValues[x].length != this.zValues[x].length) {
                throw new IllegalArgumentException("given zValues size does not match needed size");
            }
            System.arraycopy(zValues[x], 0, this.zValues[x], 0, zValues[x].length);
            ++x;
        }
        this.clearCache();
    }

    public void setWValues(double[][] wValues) {
        if (this.wValues == null) {
            throw new IllegalStateException("trying to set w values, while no array exist");
        }
        if (wValues.length != this.wValues.length) {
            throw new IllegalArgumentException("given wValues size does not match needed size");
        }
        int x = 0;
        while (x < wValues.length) {
            if (wValues[x].length != this.wValues[x].length) {
                throw new IllegalArgumentException("given wValues size does not match needed size");
            }
            System.arraycopy(wValues[x], 0, this.wValues[x], 0, wValues[x].length);
            ++x;
        }
        this.clearCache();
    }

    public XYAreaBounds getXYBounds() {
        if (this.xyBounds == null) {
            return null;
        }
        if (this.xyAreaBounds == null) {
            this.xyAreaBounds = new XYAreaBounds(this.xyBounds);
        }
        return this.xyAreaBounds;
    }

    public XYAreaBounds getXYBounds(MeasuringUnit xAxisDisplayMU, MeasuringUnit yAxisDisplayMU) {
        if (this.xyBounds == null) {
            return null;
        }
        double[] polygonPoints = new double[this.xyBounds.length];
        int i = 0;
        while (i < this.xyBounds.length) {
            polygonPoints[i] = i % 2 == 0 ? xAxisDisplayMU.convert(this.xyBounds[i], this.xAxisMU) : yAxisDisplayMU.convert(this.xyBounds[i], this.yAxisMU);
            ++i;
        }
        return new XYAreaBounds(polygonPoints);
    }

    public void setXYBounds(XYAreaBounds areaBounds, MeasuringUnit xAxisDisplayMU, MeasuringUnit yAxisDisplayMU) {
        if (areaBounds == null) {
            this.xyBounds = null;
            this.xyAreaBounds = null;
        } else {
            this.xyBounds = new double[areaBounds.getPoints().length * 2];
            int i = 0;
            Point2D[] point2DArray = areaBounds.getPoints();
            int n = point2DArray.length;
            int n2 = 0;
            while (n2 < n) {
                Point2D p = point2DArray[n2];
                this.xyBounds[i * 2] = this.xAxisMU.convert(p.getX(), xAxisDisplayMU);
                this.xyBounds[i * 2 + 1] = this.yAxisMU.convert(p.getY(), yAxisDisplayMU);
                ++i;
                ++n2;
            }
            this.xyAreaBounds = new XYAreaBounds(this.xyBounds);
        }
        this.clearCache();
    }

    public void modifyZWValues(AreaSurfaceEditMode editMode, Point2D initialPoint, Point2D editPoint, double xRadius, double yRadius, double zAmplitude, double wAmplitude, MeasuringUnit xAxisDisplayMU, MeasuringUnit yAxisDisplayMU, MeasuringUnit zAxisDisplayMU, MeasuringUnit wAxisDisplayMU) {
        double editX = this.xAxisMU.convert(editPoint.getX(), xAxisDisplayMU);
        double editY = this.yAxisMU.convert(editPoint.getY(), yAxisDisplayMU);
        xRadius = this.xAxisMU.convert(xRadius, xAxisDisplayMU);
        yRadius = this.yAxisMU.convert(yRadius, yAxisDisplayMU);
        double xCenterIndex = (double)(this.xAxisResolution - 1) * (editX - this.minX) / (this.maxX - this.minX);
        double yCenterIndex = (double)(this.yAxisResolution - 1) * (editY - this.minY) / (this.maxY - this.minY);
        double xIndexDelta = (double)(this.xAxisResolution - 1) * xRadius / (this.maxX - this.minX);
        double yIndexDelta = (double)(this.yAxisResolution - 1) * yRadius / (this.maxY - this.minY);
        int minXIndex = Math.max(0, (int)Math.ceil(xCenterIndex - xIndexDelta));
        int maxXIndex = Math.min(this.xAxisResolution - 1, (int)(xCenterIndex + xIndexDelta));
        int minYIndex = Math.max(0, (int)Math.ceil(yCenterIndex - yIndexDelta));
        int maxYIndex = Math.min(this.yAxisResolution - 1, (int)(yCenterIndex + yIndexDelta));
        double weightetAverageZ = 0.0;
        double weightetAverageW = 0.0;
        if (editMode != AreaSurfaceEditMode.Equate) {
            zAmplitude = this.zAxisMU.convert(zAmplitude, zAxisDisplayMU);
            wAmplitude = this.wAxisMU != null ? this.wAxisMU.convert(wAmplitude, wAxisDisplayMU) : Double.NaN;
        } else {
            double initialX = this.xAxisMU.convert(initialPoint.getX(), xAxisDisplayMU);
            double initialY = this.yAxisMU.convert(initialPoint.getY(), yAxisDisplayMU);
            double initialXIndex = (double)(this.xAxisResolution - 1) * (initialX - this.minX) / (this.maxX - this.minX);
            double initialYIndex = (double)(this.yAxisResolution - 1) * (initialY - this.minY) / (this.maxY - this.minY);
            int initialMinXIndex = Math.max(0, (int)Math.ceil(initialXIndex - xIndexDelta));
            int initialMaxXIndex = Math.min(this.xAxisResolution - 1, (int)(initialXIndex + xIndexDelta));
            int initialMinYIndex = Math.max(0, (int)Math.ceil(initialYIndex - yIndexDelta));
            int initialMaxYIndex = Math.min(this.yAxisResolution - 1, (int)(initialYIndex + yIndexDelta));
            double cZ = 0.0;
            double cW = 0.0;
            int xIndex = initialMinXIndex;
            while (xIndex <= initialMaxXIndex) {
                double x = this.minX + (this.maxX - this.minX) * (double)xIndex / (double)(this.xAxisResolution - 1);
                double xRatio = Math.min(1.0, 1.0 - Math.abs(initialX - x) / xRadius);
                int yIndex = initialMinYIndex;
                while (yIndex <= initialMaxYIndex) {
                    double y = this.minY + (this.maxY - this.minY) * (double)yIndex / (double)(this.yAxisResolution - 1);
                    double yRatio = Math.min(1.0, 1.0 - Math.abs(initialY - y) / yRadius);
                    double ratio = xRatio * yRatio;
                    if (Double.isFinite(this.zValues[xIndex][yIndex])) {
                        weightetAverageZ += this.zValues[xIndex][yIndex] * ratio;
                        cZ += ratio;
                    }
                    if (this.wValues != null && Double.isFinite(this.wValues[xIndex][yIndex])) {
                        weightetAverageW += this.wValues[xIndex][yIndex] * ratio;
                        cW += ratio;
                    }
                    ++yIndex;
                }
                ++xIndex;
            }
            weightetAverageZ = cZ > 0.0 ? weightetAverageZ / cZ : Double.NaN;
            weightetAverageW = cW > 0.0 ? weightetAverageW / cW : Double.NaN;
            zAmplitude /= 50.0;
            wAmplitude /= 50.0;
        }
        int xIndex = minXIndex;
        while (xIndex <= maxXIndex) {
            double x = this.minX + (this.maxX - this.minX) * (double)xIndex / (double)(this.xAxisResolution - 1);
            double xRatio = Math.min(1.0, 1.0 - Math.abs(editX - x) / xRadius);
            xRatio = (1.0 + Math.sin(Math.PI * xRatio - 1.5707963267948966)) / 2.0;
            int yIndex = minYIndex;
            while (yIndex <= maxYIndex) {
                double y = this.minY + (this.maxY - this.minY) * (double)yIndex / (double)(this.yAxisResolution - 1);
                double yRatio = Math.min(1.0, 1.0 - Math.abs(editY - y) / yRadius);
                yRatio = (1.0 + Math.sin(Math.PI * yRatio - 1.5707963267948966)) / 2.0;
                double ratio = xRatio * yRatio;
                switch (editMode) {
                    case Amplify: {
                        if (Double.isFinite(zAmplitude)) {
                            double[] dArray = this.zValues[xIndex];
                            int n = yIndex;
                            dArray[n] = dArray[n] + zAmplitude * ratio;
                        }
                        if (!Double.isFinite(wAmplitude) || this.wValues == null) break;
                        double[] dArray = this.wValues[xIndex];
                        int n = yIndex;
                        dArray[n] = dArray[n] + wAmplitude * ratio;
                        break;
                    }
                    case Reduce: {
                        if (Double.isFinite(zAmplitude)) {
                            double[] dArray = this.zValues[xIndex];
                            int n = yIndex;
                            dArray[n] = dArray[n] - zAmplitude * ratio;
                        }
                        if (!Double.isFinite(wAmplitude) || this.wValues == null) break;
                        double[] dArray = this.wValues[xIndex];
                        int n = yIndex;
                        dArray[n] = dArray[n] - wAmplitude * ratio;
                        break;
                    }
                    case Equate: {
                        if (Double.isFinite(zAmplitude) && Double.isFinite(weightetAverageZ)) {
                            double delta = (weightetAverageZ - this.zValues[xIndex][yIndex]) * ratio * zAmplitude;
                            double[] dArray = this.zValues[xIndex];
                            int n = yIndex;
                            dArray[n] = dArray[n] + delta;
                        }
                        if (!Double.isFinite(wAmplitude) || !Double.isFinite(weightetAverageW)) break;
                        double[] dArray = this.wValues[xIndex];
                        int n = yIndex;
                        dArray[n] = dArray[n] + (weightetAverageW - this.wValues[xIndex][yIndex]) * ratio * wAmplitude;
                        break;
                    }
                }
                ++yIndex;
            }
            ++xIndex;
        }
        this.clearCache();
    }

    public double getZValue(double xValue, double yValue) {
        return this.getInterpolatedValue(this.zValues, xValue, yValue);
    }

    public double getZValue(MeasuringUnit xValueMU, double xValue, MeasuringUnit yValueMU, double yValue, MeasuringUnit outputMU) {
        double zValue = this.getZValue(this.xAxisMU.convert(xValue, xValueMU), this.yAxisMU.convert(yValue, yValueMU));
        return outputMU.convert(zValue, this.zAxisMU);
    }

    public double[][] getZValues(double[] xs, double[] ys, MeasuringUnit xValuesMU, MeasuringUnit yValuesMU, MeasuringUnit outputMU) {
        double[][] values = new double[xs.length][];
        int xi = 0;
        while (xi < xs.length) {
            double xValue = this.xAxisMU.convert(xs[xi], xValuesMU);
            values[xi] = new double[ys.length];
            int yi = 0;
            while (yi < ys.length) {
                double yValue = this.yAxisMU.convert(ys[yi], yValuesMU);
                double zValue = this.getZValue(xValue, yValue);
                values[xi][yi] = outputMU.convert(zValue, this.zAxisMU);
                ++yi;
            }
            ++xi;
        }
        return values;
    }

    public double getWValue(double xValue, double yValue) {
        return this.getInterpolatedValue(this.wValues, xValue, yValue);
    }

    public double getWValue(MeasuringUnit xValueMU, double xValue, MeasuringUnit yValueMU, double yValue, MeasuringUnit outputMU) {
        double wValue = this.getWValue(this.xAxisMU.convert(xValue, xValueMU), this.yAxisMU.convert(yValue, yValueMU));
        return outputMU.convert(wValue, this.wAxisMU);
    }

    public double[][] getWValues(double[] xs, double[] ys, MeasuringUnit xValuesMU, MeasuringUnit yValuesMU, MeasuringUnit outputMU) {
        double[][] values = new double[xs.length][];
        int xi = 0;
        while (xi < xs.length) {
            double xValue = this.xAxisMU.convert(xs[xi], xValuesMU);
            values[xi] = new double[ys.length];
            int yi = 0;
            while (yi < ys.length) {
                double yValue = this.yAxisMU.convert(ys[yi], yValuesMU);
                double zValue = this.getWValue(xValue, yValue);
                values[xi][yi] = outputMU.convert(zValue, this.wAxisMU);
                ++yi;
            }
            ++xi;
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Characteristic3DExtremeXLine getExtremeXLine(boolean searchForMinimum, boolean overZ) {
        Object object = this;
        synchronized (object) {
            if (this.extremeXLineCache == null) {
                this.extremeXLineCache = new Characteristic3DExtremeLineCache();
            }
        }
        object = this.extremeXLineCache;
        synchronized (object) {
            Characteristic3DExtremeXLine extremeXLine = this.extremeXLineCache.get(searchForMinimum, overZ);
            if (extremeXLine == null) {
                extremeXLine = new Characteristic3DExtremeXLine(searchForMinimum, overZ, this.xAxisMU, this.yAxisMU, this.zAxisMU, this.wAxisMU, this.minX, this.maxX, this.minY, this.maxY, this.xAxisResolution, this.yAxisResolution, this.zValues, this.wValues, this.getXYBounds());
                this.extremeXLineCache.put(extremeXLine, searchForMinimum, overZ);
            }
            return extremeXLine;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Characteristic3DExtremeYLine getExtremeYLine(boolean searchForMinimum, boolean overZ) {
        Object object = this;
        synchronized (object) {
            if (this.extremeYLineCache == null) {
                this.extremeYLineCache = new Characteristic3DExtremeLineCache();
            }
        }
        object = this.extremeYLineCache;
        synchronized (object) {
            Characteristic3DExtremeYLine extremeYLine = this.extremeYLineCache.get(searchForMinimum, overZ);
            if (extremeYLine == null) {
                extremeYLine = new Characteristic3DExtremeYLine(searchForMinimum, overZ, this.xAxisMU, this.yAxisMU, this.zAxisMU, this.wAxisMU, this.minX, this.maxX, this.minY, this.maxY, this.xAxisResolution, this.yAxisResolution, this.zValues, this.wValues, this.getXYBounds());
                this.extremeYLineCache.put(extremeYLine, searchForMinimum, overZ);
            }
            return extremeYLine;
        }
    }

    private double getInterpolatedValue(double[][] array, double xValue, double yValue) {
        int yRowIndexUpperBound;
        int yRowIndexLowerBound;
        double[] yValueUpperBounds;
        double[] yValueLowerBounds;
        if (xValue < this.minX || xValue > this.maxX) {
            return Double.NaN;
        }
        if (yValue < this.minY || yValue > this.maxY) {
            return Double.NaN;
        }
        XYAreaBounds xyBounds = this.getXYBounds();
        if (xyBounds != null && !xyBounds.contains(xValue, yValue)) {
            return Double.NaN;
        }
        double xValueIndex = (xValue - this.minX) / (this.maxX - this.minX) * (double)(this.xAxisResolution - 1);
        double yValueIndex = (yValue - this.minY) / (this.maxY - this.minY) * (double)(this.yAxisResolution - 1);
        if (xValueIndex != (double)((int)xValueIndex)) {
            yValueLowerBounds = array[(int)xValueIndex];
            yValueUpperBounds = array[(int)xValueIndex + 1];
        } else {
            yValueUpperBounds = array[(int)xValueIndex];
            yValueLowerBounds = yValueUpperBounds;
        }
        if (yValueIndex != (double)((int)yValueIndex)) {
            yRowIndexLowerBound = (int)yValueIndex;
            yRowIndexUpperBound = (int)yValueIndex + 1;
        } else {
            yRowIndexLowerBound = yRowIndexUpperBound = (int)yValueIndex;
        }
        double x1y1 = yValueLowerBounds[yRowIndexLowerBound];
        double x2y1 = yValueUpperBounds[yRowIndexLowerBound];
        double x1y2 = yValueLowerBounds[yRowIndexUpperBound];
        double x2y2 = yValueUpperBounds[yRowIndexUpperBound];
        double z1 = x1y1 + (x2y1 - x1y1) * (xValueIndex - (double)((int)xValueIndex));
        double z2 = x1y2 + (x2y2 - x1y2) * (xValueIndex - (double)((int)xValueIndex));
        double z = z1 + (z2 - z1) * (yValueIndex - (double)((int)yValueIndex));
        return z;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinX(MeasuringUnit mu) {
        return mu.convert(this.minX, this.xAxisMU);
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxX(MeasuringUnit mu) {
        return mu.convert(this.maxX, this.xAxisMU);
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMinY(MeasuringUnit mu) {
        return mu.convert(this.minY, this.yAxisMU);
    }

    public double getMaxY() {
        return this.maxY;
    }

    public double getMaxY(MeasuringUnit mu) {
        return mu.convert(this.maxY, this.yAxisMU);
    }

    public double getMinValidX() {
        double boundsX;
        double minX = this.getMinX();
        XYAreaBounds areaBounds = this.getXYBounds();
        if (areaBounds != null && Double.isFinite(boundsX = areaBounds.getMinX())) {
            minX = boundsX;
        }
        return minX;
    }

    public double getMinValidX(MeasuringUnit xValueMU) {
        double maxX = this.getMinValidX();
        return xValueMU.convert(maxX, this.xAxisMU);
    }

    public double getMaxValidX() {
        double boundsX;
        double maxX = this.getMaxX();
        XYAreaBounds areaBounds = this.getXYBounds();
        if (areaBounds != null && Double.isFinite(boundsX = areaBounds.getMaxX())) {
            maxX = boundsX;
        }
        return maxX;
    }

    public double getMaxValidX(MeasuringUnit xValueMU) {
        double maxX = this.getMaxValidX();
        return xValueMU.convert(maxX, this.xAxisMU);
    }

    public double getMinValidY() {
        double boundsY;
        double minY = this.getMinY();
        XYAreaBounds areaBounds = this.getXYBounds();
        if (areaBounds != null && Double.isFinite(boundsY = areaBounds.getMinY())) {
            minY = boundsY;
        }
        return minY;
    }

    public double getMinValidY(MeasuringUnit yValueMU) {
        double minY = this.getMinValidY();
        return yValueMU.convert(minY, this.yAxisMU);
    }

    public double getMinValidY(double xValue) {
        double boundsY;
        double minY = this.getMinY();
        XYAreaBounds areaBounds = this.getXYBounds();
        if (areaBounds != null && Double.isFinite(boundsY = areaBounds.getMinY())) {
            minY = boundsY;
        }
        return minY;
    }

    public double getMinValidY(MeasuringUnit xValueMU, double xValue, MeasuringUnit yValueMU) {
        double minY = this.getMinValidY(this.xAxisMU.convert(xValue, xValueMU));
        return yValueMU.convert(minY, this.yAxisMU);
    }

    public double getMaxValidY() {
        double boundsY;
        double maxY = this.getMaxY();
        XYAreaBounds areaBounds = this.getXYBounds();
        if (areaBounds != null && Double.isFinite(boundsY = areaBounds.getMaxY())) {
            maxY = boundsY;
        }
        return maxY;
    }

    public double getMaxValidY(MeasuringUnit yValueMU) {
        double maxY = this.getMaxValidY();
        return yValueMU.convert(maxY, this.yAxisMU);
    }

    public double getMaxValidY(double xValue) {
        double boundsY;
        double maxY = this.getMaxY();
        XYAreaBounds areaBounds = this.getXYBounds();
        if (areaBounds != null && Double.isFinite(boundsY = areaBounds.getMaxY())) {
            maxY = boundsY;
        }
        return maxY;
    }

    public double getMaxValidY(MeasuringUnit xValueMU, double xValue, MeasuringUnit yValueMU) {
        double maxY = this.getMaxValidY(this.xAxisMU.convert(xValue, xValueMU));
        return yValueMU.convert(maxY, this.yAxisMU);
    }

    public double getMinValidZ() {
        double minValidZ = Double.NaN;
        int i = 0;
        while (i < this.xAxisResolution) {
            int j = 0;
            while (j < this.yAxisResolution) {
                double x = this.minX + (double)i * ((this.maxX - this.minX) / (double)this.xAxisResolution);
                double y = this.minY + (double)j * ((this.maxY - this.minY) / (double)this.yAxisResolution);
                double z = this.getZValue(x, y);
                if (!Double.isFinite(minValidZ) || z < minValidZ) {
                    minValidZ = z;
                }
                ++j;
            }
            ++i;
        }
        return minValidZ;
    }

    public double getMinValidZ(MeasuringUnit zValueMU) {
        return zValueMU.convert(this.getMinValidZ(), this.zAxisMU);
    }

    public double getMaxValidZ() {
        double maxValidZ = Double.NaN;
        int i = 0;
        while (i < this.xAxisResolution) {
            int j = 0;
            while (j < this.yAxisResolution) {
                double x = this.minX + (double)i * ((this.maxX - this.minX) / (double)this.xAxisResolution);
                double y = this.minY + (double)j * ((this.maxY - this.minY) / (double)this.yAxisResolution);
                double z = this.getZValue(x, y);
                if (!Double.isFinite(maxValidZ) || z > maxValidZ) {
                    maxValidZ = z;
                }
                ++j;
            }
            ++i;
        }
        return maxValidZ;
    }

    public double getMaxValidZ(MeasuringUnit zValueMU) {
        return zValueMU.convert(this.getMaxValidZ(), this.zAxisMU);
    }

    public double getMinValidW() {
        double minValidW = Double.NaN;
        int i = 0;
        while (i < this.xAxisResolution) {
            int j = 0;
            while (j < this.yAxisResolution) {
                double x = this.minX + (double)i * ((this.maxX - this.minX) / (double)this.xAxisResolution);
                double y = this.minY + (double)j * ((this.maxY - this.minY) / (double)this.yAxisResolution);
                double w = this.getWValue(x, y);
                if (!Double.isFinite(minValidW) || w < minValidW) {
                    minValidW = w;
                }
                ++j;
            }
            ++i;
        }
        return minValidW;
    }

    public double getMinValidW(MeasuringUnit wValueMU) {
        return wValueMU.convert(this.getMinValidW(), this.wAxisMU);
    }

    public double getMaxValidW() {
        double maxValidW = Double.NaN;
        int i = 0;
        while (i < this.xAxisResolution) {
            int j = 0;
            while (j < this.yAxisResolution) {
                double x = this.minX + (double)i * ((this.maxX - this.minX) / (double)this.xAxisResolution);
                double y = this.minY + (double)j * ((this.maxY - this.minY) / (double)this.yAxisResolution);
                double w = this.getWValue(x, y);
                if (!Double.isFinite(maxValidW) || w > maxValidW) {
                    maxValidW = w;
                }
                ++j;
            }
            ++i;
        }
        return maxValidW;
    }

    public double getMaxValidW(MeasuringUnit wValueMU) {
        return wValueMU.convert(this.getMaxValidW(), this.wAxisMU);
    }

    public ViewBounds getViewBounds(MeasuringUnit xAxisMU, MeasuringUnit yAxisMU, MeasuringUnit zAxisMU, MeasuringUnit wAxisMU) {
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        double minW = Double.POSITIVE_INFINITY;
        double maxW = Double.NEGATIVE_INFINITY;
        XYAreaBounds xyBounds = this.getXYBounds();
        int x = 0;
        while (x < this.zValues.length) {
            double xValue = this.minX + (this.maxX - this.minX) * (double)x / (double)(this.xAxisResolution - 1);
            int y = 0;
            while (y < this.zValues[x].length) {
                double yValue = this.minY + (this.maxY - this.minY) * (double)y / (double)(this.yAxisResolution - 1);
                if (xyBounds == null || xyBounds.contains(xValue, yValue)) {
                    minX = Math.min(minX, xValue);
                    maxX = Math.max(maxX, xValue);
                    minY = Math.min(minY, yValue);
                    maxY = Math.max(maxY, yValue);
                    minZ = Math.min(minZ, this.zValues[x][y]);
                    maxZ = Math.max(maxZ, this.zValues[x][y]);
                    if (this.wValues != null) {
                        minW = Math.min(minW, this.wValues[x][y]);
                        maxW = Math.max(maxW, this.wValues[x][y]);
                    }
                }
                ++y;
            }
            ++x;
        }
        return new ViewBounds(xAxisMU.convert(minX, this.xAxisMU), xAxisMU.convert(maxX, this.xAxisMU), yAxisMU.convert(minY, this.yAxisMU), yAxisMU.convert(maxY, this.yAxisMU), zAxisMU.convert(minZ, this.zAxisMU), zAxisMU.convert(maxZ, this.zAxisMU), this.wValues != null ? wAxisMU.convert(minW, this.wAxisMU) : Double.NaN, this.wValues != null ? wAxisMU.convert(maxW, this.wAxisMU) : Double.NaN);
    }

    public String toJson() {
        return JsonUtils.GSON.toJson((Object)this);
    }

    public static Characteristic3DFunction parse(String json) {
        return (Characteristic3DFunction)JsonUtils.GSON.fromJson(json, Characteristic3DFunction.class);
    }

    public String toString() {
        return this.toJson();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearCache() {
        Characteristic3DFunction characteristic3DFunction = this;
        synchronized (characteristic3DFunction) {
            Characteristic3DExtremeLineCache<Characteristic3DExtremeLine> characteristic3DExtremeLineCache;
            if (this.extremeXLineCache != null) {
                characteristic3DExtremeLineCache = this.extremeXLineCache;
                synchronized (characteristic3DExtremeLineCache) {
                    this.extremeXLineCache.clear();
                }
            }
            if (this.extremeYLineCache != null) {
                characteristic3DExtremeLineCache = this.extremeYLineCache;
                synchronized (characteristic3DExtremeLineCache) {
                    this.extremeYLineCache.clear();
                }
            }
        }
    }

    private static class Characteristic3DExtremeLineCache<T extends Characteristic3DExtremeLine> {
        private T minOverZ;
        private T maxOverZ;
        private T minOverW;
        private T maxOverW;

        private Characteristic3DExtremeLineCache() {
        }

        public T get(boolean searchForMinimum, boolean overZ) {
            if (searchForMinimum) {
                return overZ ? this.minOverZ : this.minOverW;
            }
            return overZ ? this.maxOverZ : this.maxOverW;
        }

        public void put(T extremeLine, boolean searchForMinimum, boolean overZ) {
            if (searchForMinimum) {
                if (overZ) {
                    this.minOverZ = extremeLine;
                } else {
                    this.minOverW = extremeLine;
                }
            } else if (overZ) {
                this.maxOverZ = extremeLine;
            } else {
                this.maxOverW = extremeLine;
            }
        }

        public void clear() {
            this.minOverZ = null;
            this.maxOverZ = null;
            this.minOverW = null;
            this.maxOverW = null;
        }
    }

    public static final class ViewBounds {
        public final double minX;
        public final double maxX;
        public final double minY;
        public final double maxY;
        public final double minZ;
        public final double maxZ;
        public final double minW;
        public final double maxW;

        public ViewBounds(double minX, double maxX, double minY, double maxY, double minZ, double maxZ, double minW, double maxW) {
            this.minX = minX;
            this.maxX = maxX;
            this.minY = minY;
            this.maxY = maxY;
            this.minZ = minZ;
            this.maxZ = maxZ;
            this.minW = minW;
            this.maxW = maxW;
        }

        public ViewBounds withPadding(double padding) {
            return new ViewBounds(this.minX - (this.maxX - this.minX) * padding, this.maxX + (this.maxX - this.minX) * padding, this.minY - (this.maxY - this.minY) * padding, this.maxY + (this.maxY - this.minY) * padding, this.minZ - (this.maxZ - this.minZ) * padding, this.maxZ + (this.maxZ - this.minZ) * padding, this.minW - (this.maxW - this.minW) * padding, this.maxW + (this.maxW - this.minW) * padding);
        }
    }
}

