/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.characteristic;

import de.elpro.ewms.core.characteristic.Characteristic3DExtremeLine;
import de.elpro.ewms.core.characteristic.Characteristic3DFunction;
import de.elpro.ewms.core.characteristic.ExtremePoint;
import de.elpro.ewms.core.json.JsonUtils;
import de.elpro.ewms.core.variable.value.IVarValue;
import de.elpro.ewms.core.variable.value.ValueSource;
import de.elpro.ewms.core.variable.value.VarValue;
import java.time.Instant;
import java.util.Map;
import java.util.TreeMap;

public class Characteristic3DFunctions
extends TreeMap<Instant, Characteristic3DFunction> {
    private static final long serialVersionUID = -8511517897560486350L;

    public String toJson() {
        return JsonUtils.GSON.toJson((Object)this);
    }

    public static Characteristic3DFunctions parse(String text) {
        try {
            return (Characteristic3DFunctions)JsonUtils.GSON.fromJson(text, Characteristic3DFunctions.class);
        }
        catch (Exception exception) {
            return new Characteristic3DFunctions();
        }
    }

    public Instant getNextFunctionBegin(Instant timestamp) {
        return this.higherKey(timestamp);
    }

    public IVarValue getOutput(IVarValue xAxisInput, IVarValue yAxisInput, boolean zAxis) {
        if (!xAxisInput.isValid() || !yAxisInput.isValid()) {
            return VarValue.nan(Math.max(xAxisInput.getEndTimestamp(), yAxisInput.getEndTimestamp()));
        }
        long timestamp = Math.max(xAxisInput.getEndTimestamp(), yAxisInput.getEndTimestamp());
        Map.Entry functionEntry = this.floorEntry(Instant.ofEpochMilli(timestamp));
        if (functionEntry == null) {
            return VarValue.nan(timestamp);
        }
        Characteristic3DFunction function = (Characteristic3DFunction)functionEntry.getValue();
        double outputValue = zAxis ? function.getZValue(xAxisInput.getValue(), yAxisInput.getValue()) : function.getWValue(xAxisInput.getValue(), yAxisInput.getValue());
        if (Double.isFinite(outputValue)) {
            return new VarValue(timestamp, outputValue, 1.0, ValueSource.Calculated);
        }
        return VarValue.nan(timestamp);
    }

    public IVarValue getExtremePoint(IVarValue input, boolean getX, boolean searchForMinimum, boolean overZ) {
        double outputValue;
        Characteristic3DExtremeLine extremeLine;
        if (!input.isValid()) {
            return VarValue.nan(input.getEndTimestamp());
        }
        long timestamp = input.getEndTimestamp();
        Map.Entry functionEntry = this.floorEntry(Instant.ofEpochMilli(timestamp));
        if (functionEntry == null) {
            return VarValue.nan(timestamp);
        }
        Characteristic3DFunction function = (Characteristic3DFunction)functionEntry.getValue();
        Characteristic3DExtremeLine characteristic3DExtremeLine = extremeLine = getX ? function.getExtremeYLine(searchForMinimum, overZ) : function.getExtremeXLine(searchForMinimum, overZ);
        if (extremeLine == null) {
            return VarValue.nan(timestamp);
        }
        ExtremePoint extremePoint = extremeLine.getPoint(input.getValue());
        if (extremePoint == null) {
            return VarValue.nan(timestamp);
        }
        double d = outputValue = getX ? extremePoint.getX() : extremePoint.getY();
        if (Double.isFinite(outputValue)) {
            return new VarValue(timestamp, outputValue, 1.0, ValueSource.Calculated);
        }
        return VarValue.nan(timestamp);
    }
}

