/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.charts;

import de.elpro.ewms.core.characteristic.Characteristic2D;
import de.elpro.ewms.core.charts.Chart2D;
import de.elpro.ewms.core.charts.YAxis;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleText;
import de.elpro.ui.utils.TextUtils;
import java.net.URL;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.paint.Color;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ewms_charts_characteristic2d_series")
@Access(value=AccessType.PROPERTY)
public class Characteristic2DSeries
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "charts/characteristic2d_series";
    public static final URL DEFAULT_ICON = Characteristic2D.DEFAULT_ICON;
    private int id;
    private final ObjectProperty<Chart2D> chart = new SimpleObjectProperty();
    private final StringProperty title = new SimpleStringProperty();
    private final ObjectProperty<YAxis> yAxis = new SimpleObjectProperty();
    private final ObjectProperty<Characteristic2D> characteristic = new SimpleObjectProperty();
    private final ObjectProperty<Color> defaultColor = new SimpleObjectProperty();

    public Characteristic2DSeries() {
    }

    public Characteristic2DSeries(int id) {
        this.setId(id);
    }

    @Id
    public Integer getId() {
        return this.id;
    }

    protected void setId(int id) {
        this.id = id;
    }

    @OneToOne(fetch=FetchType.LAZY, orphanRemoval=false)
    @MapsId
    public Chart2D getChart() {
        return (Chart2D)this.chart.get();
    }

    public void setChart(Chart2D chart) {
        this.chart.set((Object)chart);
    }

    public final ObjectProperty<Chart2D> chartProperty() {
        return this.chart;
    }

    @ManyToOne
    @JoinColumn(name="y_axis", nullable=false)
    public YAxis getYAxis() {
        return (YAxis)this.yAxis.get();
    }

    public void setYAxis(YAxis yAxis) {
        this.yAxis.set((Object)yAxis);
    }

    public final ObjectProperty<YAxis> yAxisProperty() {
        return this.yAxis;
    }

    @ManyToOne
    @JoinColumn(name="characteristic", nullable=false)
    public Characteristic2D getCharacteristic() {
        return (Characteristic2D)this.characteristic.get();
    }

    public void setCharacteristic(Characteristic2D characteristic) {
        this.characteristic.set((Object)characteristic);
    }

    public final ObjectProperty<Characteristic2D> characteristicProperty() {
        return this.characteristic;
    }

    @Column(name="title", columnDefinition="TEXT")
    public String getTitle() {
        return (String)this.title.get();
    }

    @Transient
    public final String getLocalTitle() {
        return LocaleText.tryParse((String)this.getTitle()).getTextOrDefault();
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public final StringProperty titleProperty() {
        return this.title;
    }

    @Transient
    public final String getResultTitle() {
        String title = this.getLocalTitle();
        if (title != null && !title.isEmpty()) {
            return title;
        }
        if (this.getCharacteristic() != null) {
            if (this.getCharacteristic().getDescription() != null && !this.getCharacteristic().getDescription().isEmpty()) {
                return TextUtils.getFirstLine((String)this.getCharacteristic().getDescription(), (int)50);
            }
            return this.getCharacteristic().toString();
        }
        return null;
    }

    @Column(name="default_color")
    public Color getDefaultColor() {
        return (Color)this.defaultColor.get();
    }

    public void setDefaultColor(Color color) {
        this.defaultColor.set((Object)color);
    }

    public final ObjectProperty<Color> defaultColorProperty() {
        return this.defaultColor;
    }

    public String toString() {
        return this.getResultTitle();
    }

    @Transient
    public String getIconUri() {
        return Characteristic2D.DEFAULT_ICON.toString();
    }
}

