/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.charts;

import de.elpro.ewms.core.charts.Chart2D;
import de.elpro.resources.Icons;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleText;
import java.net.URL;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ewms_charts_chart_group")
@Access(value=AccessType.PROPERTY)
public class ChartGroup
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "charts/chart2d/group";
    public static final URL DEFAULT_ICON = Icons.FOLDER_ITEM_URL;
    public static final String ICONS_FOLDER = "ewms/icons/svg/charts/chart2d/group";
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final StringProperty name = new SimpleStringProperty();
    private final StringProperty iconKey = new SimpleStringProperty();
    private final ObjectProperty<Integer> visualOrderPosition = new SimpleObjectProperty();
    private Set<Chart2D> charts = new HashSet<Chart2D>();

    public ChartGroup() {
    }

    public ChartGroup(int id) {
        this();
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_charts_chart_group_sequence")
    @SequenceGenerator(name="ewms_charts_chart_group_sequence", sequenceName="ewms_charts_chart_group_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    protected void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @Column(name="name", nullable=false, columnDefinition="TEXT")
    public String getName() {
        return (String)this.name.get();
    }

    @Transient
    public final String getLocalName() {
        return LocaleText.tryParse((String)this.getName()).getTextOrDefault();
    }

    public void setName(String displayName) {
        this.name.set((Object)displayName);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    @Column(name="icon_key")
    public String getIconKey() {
        return (String)this.iconKey.get();
    }

    public void setIconKey(String iconKey) {
        this.iconKey.set((Object)iconKey);
    }

    public final StringProperty iconKeyProperty() {
        return this.iconKey;
    }

    @Column(name="visual_order_position")
    public Integer getVisualOrderPosition() {
        return (Integer)this.visualOrderPosition.get();
    }

    public void setVisualOrderPosition(Integer visualOrderPosition) {
        this.visualOrderPosition.set((Object)visualOrderPosition);
    }

    public final ObjectProperty<Integer> visualOrderPositionProperty() {
        return this.visualOrderPosition;
    }

    @OneToMany(mappedBy="chartGroup")
    public Set<Chart2D> getCharts() {
        return this.charts;
    }

    protected void setCharts(Set<Chart2D> charts) {
        this.charts = charts;
    }

    public String toString() {
        return LocaleText.tryParse((String)this.getName()).getTextOrDefault(Locale.getDefault());
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChartGroup) {
            if (this.getId() == null) {
                return super.equals(obj);
            }
            if (this.getId().equals(((ChartGroup)obj).getId())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return ChartGroup.class.hashCode() + 17 * (Integer)this.id.get();
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        if (o instanceof Chart2D) {
            return -1;
        }
        if (!(o instanceof ChartGroup)) {
            return this.toString().compareTo(o.toString());
        }
        ChartGroup chartGroup = (ChartGroup)o;
        if (this.getVisualOrderPosition() != chartGroup.getVisualOrderPosition() && this.getVisualOrderPosition() != null && chartGroup.getVisualOrderPosition() != null) {
            return this.getVisualOrderPosition().compareTo(chartGroup.getVisualOrderPosition());
        }
        if (this.toString() == null) {
            return -1;
        }
        return this.toString().compareTo(chartGroup.toString());
    }

    @Transient
    public String getIconUri() {
        return DEFAULT_ICON.toString();
    }
}

