/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.charts;

import de.elpro.ewms.core.charts.Chart3D;
import de.elpro.ewms.core.charts.LineType;
import de.elpro.ewms.core.charts.ShapeType;
import de.elpro.ewms.core.charts.VarSeries2D;
import de.elpro.ewms.core.charts.VarSeries3D;
import de.elpro.ewms.core.structure.Property;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.resources.Resources;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleText;
import java.net.URL;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ewms_charts_function_series3d")
@Access(value=AccessType.PROPERTY)
public class FunctionSeries3D
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "charts/chart3d/function_series";
    public static final URL DEFAULT_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/charts/series.png");
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final ObjectProperty<Chart3D> chart = new SimpleObjectProperty();
    private final StringProperty title = new SimpleStringProperty();
    private final ObjectProperty<Color> defaultColor = new SimpleObjectProperty();
    private final ObjectProperty<Integer> visualOrderPosition = new SimpleObjectProperty();
    private final ObjectProperty<Property> zFunctionProperty = new SimpleObjectProperty();
    private final ObjectProperty<Property> wFunctionProperty = new SimpleObjectProperty();
    private final StringProperty xAxisParameter = new SimpleStringProperty();
    private final ObjectProperty<MeasuringUnit> xAxisMU = new SimpleObjectProperty();
    private final StringProperty yAxisParameter = new SimpleStringProperty();
    private final ObjectProperty<MeasuringUnit> yAxisMU = new SimpleObjectProperty();
    private final StringProperty zAxisParameter = new SimpleStringProperty();
    private final ObjectProperty<MeasuringUnit> zAxisMU = new SimpleObjectProperty();
    private final StringProperty wAxisParameter = new SimpleStringProperty();
    private final ObjectProperty<MeasuringUnit> wAxisMU = new SimpleObjectProperty();

    public FunctionSeries3D() {
    }

    public FunctionSeries3D(int id) {
        this.setId(id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_charts_function_series3d_sequence")
    @SequenceGenerator(name="ewms_charts_function_series3d_sequence", sequenceName="ewms_charts_function_series3d_sequence")
    public Integer getId() {
        return (Integer)this.idProperty().get();
    }

    protected void setId(Integer id) {
        this.idProperty().set((Object)id);
    }

    public final ObjectProperty<Chart3D> chartProperty() {
        return this.chart;
    }

    @ManyToOne
    @JoinColumn(name="chart", nullable=false)
    public Chart3D getChart() {
        return (Chart3D)this.chartProperty().get();
    }

    public void setChart(Chart3D chart) {
        this.chartProperty().set((Object)chart);
    }

    public final StringProperty titleProperty() {
        return this.title;
    }

    @Column(name="title", nullable=false, columnDefinition="TEXT")
    public String getTitle() {
        return (String)this.titleProperty().get();
    }

    @Transient
    public final String getLocalTitle() {
        return LocaleText.tryParse((String)this.getTitle()).getTextOrDefault();
    }

    public void setTitle(String title) {
        this.titleProperty().set((Object)title);
    }

    public final ObjectProperty<Color> defaultColorProperty() {
        return this.defaultColor;
    }

    @Column(name="default_color")
    public Color getDefaultColor() {
        return (Color)this.defaultColorProperty().get();
    }

    public void setDefaultColor(Color defaultColor) {
        this.defaultColorProperty().set((Object)defaultColor);
    }

    public final ObjectProperty<Integer> visualOrderPositionProperty() {
        return this.visualOrderPosition;
    }

    public ObjectProperty<Property> zFunctionPropertyProperty() {
        return this.zFunctionProperty;
    }

    @ManyToOne
    @JoinColumn(name="z_function", nullable=false)
    public Property getZFunctionProperty() {
        return (Property)this.zFunctionPropertyProperty().get();
    }

    public void setZFunctionProperty(Property functionProperty) {
        this.zFunctionPropertyProperty().set((Object)functionProperty);
    }

    public ObjectProperty<Property> wFunctionPropertyProperty() {
        return this.wFunctionProperty;
    }

    @ManyToOne
    @JoinColumn(name="w_function", nullable=true)
    public Property getWFunctionProperty() {
        return (Property)this.wFunctionPropertyProperty().get();
    }

    public void setWFunctionProperty(Property functionProperty) {
        this.wFunctionPropertyProperty().set((Object)functionProperty);
    }

    public StringProperty xAxisParameterProperty() {
        return this.xAxisParameter;
    }

    @Column(name="x_axis_param")
    public String getXAxisParameter() {
        return (String)this.xAxisParameterProperty().get();
    }

    public void setXAxisParameter(String xAxisParameter) {
        this.xAxisParameterProperty().set((Object)xAxisParameter);
    }

    public ObjectProperty<MeasuringUnit> xAxisMUProperty() {
        return this.xAxisMU;
    }

    @Column(name="x_axis_mu")
    public MeasuringUnit getXAxisMU() {
        return (MeasuringUnit)this.xAxisMUProperty().get();
    }

    public void setXAxisMU(MeasuringUnit xAxisMU) {
        this.xAxisMUProperty().set((Object)xAxisMU);
    }

    public StringProperty yAxisParameterProperty() {
        return this.yAxisParameter;
    }

    @Column(name="y_axis_param")
    public String getYAxisParameter() {
        return (String)this.yAxisParameterProperty().get();
    }

    public void setYAxisParameter(String yAxisParameter) {
        this.yAxisParameterProperty().set((Object)yAxisParameter);
    }

    public ObjectProperty<MeasuringUnit> yAxisMUProperty() {
        return this.yAxisMU;
    }

    @Column(name="y_axis_mu")
    public MeasuringUnit getYAxisMU() {
        return (MeasuringUnit)this.yAxisMUProperty().get();
    }

    public void setYAxisMU(MeasuringUnit yAxisMU) {
        this.yAxisMUProperty().set((Object)yAxisMU);
    }

    public StringProperty zAxisParameterProperty() {
        return this.zAxisParameter;
    }

    @Column(name="z_axis_param")
    public String getZAxisParameter() {
        return (String)this.zAxisParameterProperty().get();
    }

    public void setZAxisParameter(String zAxisParameter) {
        this.zAxisParameterProperty().set((Object)zAxisParameter);
    }

    public ObjectProperty<MeasuringUnit> zAxisMUProperty() {
        return this.zAxisMU;
    }

    @Column(name="z_axis_mu")
    public MeasuringUnit getZAxisMU() {
        return (MeasuringUnit)this.zAxisMUProperty().get();
    }

    public void setZAxisMU(MeasuringUnit zAxisMU) {
        this.zAxisMUProperty().set((Object)zAxisMU);
    }

    public ObjectProperty<MeasuringUnit> wAxisMUProperty() {
        return this.wAxisMU;
    }

    @Column(name="w_axis_mu")
    public MeasuringUnit getWAxisMU() {
        return (MeasuringUnit)this.wAxisMUProperty().get();
    }

    public void setWAxisMU(MeasuringUnit wAxisParameterMU) {
        this.wAxisMUProperty().set((Object)wAxisParameterMU);
    }

    @Column(name="visual_order_position")
    public Integer getVisualOrderPosition() {
        return (Integer)this.visualOrderPositionProperty().get();
    }

    public void setVisualOrderPosition(Integer visualOrderPosition) {
        this.visualOrderPositionProperty().set((Object)visualOrderPosition);
    }

    @Transient
    public Node getGraphic() {
        Node styledGraphik = VarSeries2D.createGraphic(this.getDefaultColor(), LineType.None, ShapeType.Rectangle);
        return styledGraphik != null ? styledGraphik : new ImageView(DEFAULT_ICON.toString());
    }

    public String toString() {
        return this.getLocalTitle();
    }

    public boolean equals(Object obj) {
        if (obj instanceof VarSeries3D) {
            if (this.getId() == null) {
                return super.equals(obj);
            }
            if (this.getId().equals(((VarSeries3D)obj).getId())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return FunctionSeries3D.class.hashCode() + 17 * (Integer)this.id.get();
    }
}

