/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.charts;

import de.elpro.ui.model.UILabeledElement;
import java.awt.BasicStroke;
import java.awt.Stroke;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Shape;

public enum LineType implements UILabeledElement
{
    None,
    Solid,
    LongDash,
    MediumDash,
    ShortDash,
    Dotted,
    DashDotted,
    DashWithTwoDots;


    public Stroke createStroke(float strokeWidth) {
        switch (this) {
            case Solid: {
                return new BasicStroke(strokeWidth, 1, 2);
            }
            case LongDash: {
                return new BasicStroke(strokeWidth, 1, 1, 1.0f, new float[]{strokeWidth * 10.0f, strokeWidth * 10.0f}, 0.0f);
            }
            case MediumDash: {
                return new BasicStroke(strokeWidth, 1, 1, 1.0f, new float[]{strokeWidth * 6.0f, strokeWidth * 6.0f}, 0.0f);
            }
            case ShortDash: {
                return new BasicStroke(strokeWidth, 1, 1, 1.0f, new float[]{strokeWidth * 3.0f, strokeWidth * 3.0f}, 0.0f);
            }
            case Dotted: {
                return new BasicStroke(strokeWidth, 1, 1, 1.0f, new float[]{1.0f, strokeWidth * 3.0f}, 0.0f);
            }
            case DashDotted: {
                return new BasicStroke(strokeWidth, 1, 1, 1.0f, new float[]{strokeWidth * 3.0f, strokeWidth * 3.0f, 1.0f, strokeWidth * 3.0f}, 0.0f);
            }
            case DashWithTwoDots: {
                return new BasicStroke(strokeWidth, 1, 1, 1.0f, new float[]{strokeWidth * 4.0f, strokeWidth * 4.0f, 1.0f, 2.0f, 1.0f, strokeWidth * 4.0f}, 0.0f);
            }
        }
        return null;
    }

    public Line createFXStroke(double width, double lineWidth, Paint color) {
        Line line = new Line(0.0, width, width, 0.0);
        line.setStrokeWidth(lineWidth);
        line.setStroke(color);
        switch (this) {
            case Solid: {
                break;
            }
            case LongDash: {
                line.getStrokeDashArray().addAll((Object[])new Double[]{lineWidth * 7.54, lineWidth * 7.54});
                break;
            }
            case MediumDash: {
                line.getStrokeDashArray().addAll((Object[])new Double[]{lineWidth * 4.52, lineWidth * 4.52});
                break;
            }
            case ShortDash: {
                line.getStrokeDashArray().addAll((Object[])new Double[]{lineWidth * 3.23, lineWidth * 3.23});
                break;
            }
            case Dotted: {
                line.getStrokeDashArray().addAll((Object[])new Double[]{1.0, lineWidth * 3.5});
                break;
            }
            case DashDotted: {
                line.getStrokeDashArray().addAll((Object[])new Double[]{lineWidth * 3.0, lineWidth * 3.0, 1.0, lineWidth * 3.0});
                break;
            }
            case DashWithTwoDots: {
                line.getStrokeDashArray().addAll((Object[])new Double[]{lineWidth * 3.0, lineWidth * 3.0, 1.0, 2.0, 1.0, lineWidth * 3.0});
                break;
            }
            case None: {
                return null;
            }
        }
        return line;
    }

    public Shape getGraphic() {
        return this.createFXStroke(16.0, 1.0, (Paint)Color.BLACK);
    }
}

