/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.charts;

import de.elpro.ewms.core.charts.ChartGroup;
import de.elpro.ewms.core.charts.SankeyNode;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.PhysicalUnit;
import de.elpro.resources.Icons;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleText;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ewms_charts_sankey_chart")
@Access(value=AccessType.PROPERTY)
public class SankeyChart
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "charts/sankey_chart";
    public static final URL DEFAULT_ICON = Icons.SANKEY_ITEM_URL;
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final ObjectProperty<StructureClass> structureClass = new SimpleObjectProperty();
    private final ObjectProperty<ChartGroup> chartGroup = new SimpleObjectProperty();
    private final StringProperty name = new SimpleStringProperty();
    private final StringProperty title = new SimpleStringProperty();
    private final ObjectProperty<PhysicalUnit> physicalUnit = new SimpleObjectProperty();
    private final ObjectProperty<MeasuringUnit> defaultMeasuringUnit = new SimpleObjectProperty();
    private final ObjectProperty<Integer> visualOrderPosition = new SimpleObjectProperty();
    private List<SankeyNode> nodes = new LinkedList<SankeyNode>();
    private final List<SankeyNode> rootNodes = new LinkedList<SankeyNode>();

    public SankeyChart() {
    }

    public SankeyChart(int id) {
        this();
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_charts_sankey_chart_sequence")
    @SequenceGenerator(name="ewms_charts_sankey_chart_sequence", sequenceName="ewms_charts_sankey_chart_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    protected void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @ManyToOne
    @JoinColumn(name="structure_class", nullable=false)
    public StructureClass getStructureClass() {
        return (StructureClass)this.structureClass.get();
    }

    public void setStructureClass(StructureClass structureClass) {
        this.structureClass.set((Object)structureClass);
    }

    public final ObjectProperty<StructureClass> structureClassProperty() {
        return this.structureClass;
    }

    @ManyToOne
    @JoinColumn(name="chart_group", nullable=true)
    public ChartGroup getChartGroup() {
        return (ChartGroup)this.chartGroup.get();
    }

    public void setChartGroup(ChartGroup chartGroup) {
        this.chartGroup.set((Object)chartGroup);
    }

    public final ObjectProperty<ChartGroup> chartGroupProperty() {
        return this.chartGroup;
    }

    @Column(name="name", nullable=false, columnDefinition="TEXT")
    public String getName() {
        return (String)this.name.get();
    }

    @Transient
    public final String getLocalName() {
        return LocaleText.tryParse((String)this.getName()).getTextOrDefault();
    }

    public void setName(String name) {
        this.name.set((Object)name);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    @Column(name="title", columnDefinition="TEXT")
    public String getTitle() {
        return (String)this.title.get();
    }

    @Transient
    public final String getLocalTitle() {
        return LocaleText.tryParse((String)this.getTitle()).getTextOrDefault();
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public final StringProperty titleProperty() {
        return this.title;
    }

    @Column(name="physical_unit_id", nullable=false)
    public PhysicalUnit getPhysicalUnit() {
        return (PhysicalUnit)this.physicalUnit.get();
    }

    public void setPhysicalUnit(PhysicalUnit physicalUnit) {
        this.physicalUnit.set((Object)physicalUnit);
    }

    public final ObjectProperty<PhysicalUnit> physicalUnitProperty() {
        return this.physicalUnit;
    }

    @Column(name="default_measuring_unit_id")
    public MeasuringUnit getDefaultMeasuringUnit() {
        return (MeasuringUnit)this.defaultMeasuringUnit.get();
    }

    public void setDefaultMeasuringUnit(MeasuringUnit measuringUnit) {
        this.defaultMeasuringUnit.set((Object)measuringUnit);
    }

    public final ObjectProperty<MeasuringUnit> defaultMeasuringUnitProperty() {
        return this.defaultMeasuringUnit;
    }

    @Column(name="visual_order_position")
    public Integer getVisualOrderPosition() {
        return (Integer)this.visualOrderPosition.get();
    }

    public void setVisualOrderPosition(Integer visualOrderPosition) {
        this.visualOrderPosition.set((Object)visualOrderPosition);
    }

    public final ObjectProperty<Integer> visualOrderPositionProperty() {
        return this.visualOrderPosition;
    }

    @OneToMany(mappedBy="chart", cascade={CascadeType.REMOVE})
    public List<SankeyNode> getNodes() {
        return this.nodes;
    }

    protected void setNodes(List<SankeyNode> nodes) {
        this.nodes = nodes;
    }

    @Transient
    public final List<SankeyNode> getRootNodes() {
        return this.rootNodes;
    }

    public String toString() {
        return this.getLocalName();
    }

    @Transient
    public String getIconUri() {
        return DEFAULT_ICON.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SankeyChart) {
            if (this.getId() == null) {
                return super.equals(obj);
            }
            if (this.getId().equals(((SankeyChart)obj).getId())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return SankeyChart.class.hashCode() + 17 * (Integer)this.id.get();
    }
}

