/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.charts;

import de.elpro.ewms.core.charts.SankeyChart;
import de.elpro.ewms.core.charts.SankeyNodeType;
import de.elpro.ewms.core.structure.StructureClass;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.resources.Resources;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleText;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ewms_charts_sankey_node")
@Access(value=AccessType.PROPERTY)
public class SankeyNode
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "charts/sankey_node";
    public static final URL DEFAULT_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"figure/rectangle.png");
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final ObjectProperty<SankeyChart> chart = new SimpleObjectProperty();
    private final ObjectProperty<SankeyNode> parentNode = new SimpleObjectProperty();
    private final ObjectProperty<SankeyNodeType> type = new SimpleObjectProperty((Object)SankeyNodeType.Recursive);
    private final ObjectProperty<StructureClass> structureClass = new SimpleObjectProperty();
    private final ObjectProperty<Variable> variable = new SimpleObjectProperty();
    private final StringProperty name = new SimpleStringProperty();
    private final StringProperty title = new SimpleStringProperty();
    private List<SankeyNode> children = new LinkedList<SankeyNode>();

    public SankeyNode() {
    }

    public SankeyNode(int id) {
        this();
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_charts_sankey_node_sequence")
    @SequenceGenerator(name="ewms_charts_sankey_node_sequence", sequenceName="ewms_charts_sankey_node_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    protected void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @ManyToOne
    @JoinColumn(name="sankey_chart", nullable=false)
    public SankeyChart getChart() {
        return (SankeyChart)this.chart.get();
    }

    public void setChart(SankeyChart chart) {
        this.chart.set((Object)chart);
    }

    public final ObjectProperty<SankeyChart> chartProperty() {
        return this.chart;
    }

    @ManyToOne
    @JoinColumn(name="parent_node", nullable=true)
    public SankeyNode getParentNode() {
        return (SankeyNode)this.parentNode.get();
    }

    public void setParentNode(SankeyNode parentNode) {
        this.parentNode.set((Object)parentNode);
    }

    public final ObjectProperty<SankeyNode> parentNodeProperty() {
        return this.parentNode;
    }

    @Column(name="type")
    public SankeyNodeType getType() {
        return (SankeyNodeType)((Object)this.type.get());
    }

    public void setType(SankeyNodeType type) {
        this.type.set((Object)type);
    }

    public final ObjectProperty<SankeyNodeType> typeProperty() {
        return this.type;
    }

    @ManyToOne
    @JoinColumn(name="structure_class", nullable=false)
    public StructureClass getStructureClass() {
        return (StructureClass)this.structureClass.get();
    }

    public void setStructureClass(StructureClass structureClass) {
        this.structureClass.set((Object)structureClass);
    }

    public final ObjectProperty<StructureClass> structureClassProperty() {
        return this.structureClass;
    }

    @ManyToOne
    @JoinColumn(name="variable", nullable=false)
    public Variable getVariable() {
        return (Variable)this.variable.get();
    }

    public void setVariable(Variable variable) {
        this.variable.set((Object)variable);
    }

    public final ObjectProperty<Variable> variableProperty() {
        return this.variable;
    }

    @Column(name="name", columnDefinition="TEXT")
    public String getName() {
        return (String)this.name.get();
    }

    @Transient
    public final String getLocalName() {
        return LocaleText.tryParse((String)this.getName()).getTextOrDefault();
    }

    public void setName(String name) {
        this.name.set((Object)name);
    }

    public final StringProperty nameProperty() {
        return this.name;
    }

    @Column(name="title", columnDefinition="TEXT")
    public String getTitle() {
        return (String)this.title.get();
    }

    @Transient
    public final String getLocalTitle() {
        return LocaleText.tryParse((String)this.getTitle()).getTextOrDefault();
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public final StringProperty titleProperty() {
        return this.title;
    }

    @OneToMany(mappedBy="parentNode", cascade={CascadeType.REMOVE})
    public List<SankeyNode> getChildren() {
        return this.children;
    }

    protected void setChildren(List<SankeyNode> children) {
        this.children = children;
    }

    public String toString() {
        return this.getLocalName();
    }

    @Transient
    public String getIconUri() {
        return DEFAULT_ICON.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SankeyNode) {
            if (this.getId() == null) {
                return super.equals(obj);
            }
            if (this.getId().equals(((SankeyNode)obj).getId())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return SankeyNode.class.hashCode() + 17 * (Integer)this.id.get();
    }
}

