/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.charts;

import de.elpro.ui.model.UILabeledElement;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import org.jfree.chart.util.ShapeUtils;

public enum ShapeType implements UILabeledElement
{
    None,
    Circle,
    Rectangle,
    Diamod,
    RegularCross,
    DiagonalCross,
    UpTriangle,
    DownTriangle,
    LeftTriangle,
    RightTriangle;


    public Shape createAWTShape(float size) {
        switch (this) {
            case Circle: {
                return new Ellipse2D.Double(-size / 2.0f, -size / 2.0f, size, size);
            }
            case Rectangle: {
                return new Rectangle2D.Double(-size / 2.0f, -size / 2.0f, size, size);
            }
            case Diamod: {
                return ShapeUtils.createDiamond((float)(size / 2.0f));
            }
            case RegularCross: {
                return ShapeUtils.createRegularCross((float)(size / 2.0f), (float)(size / 6.0f));
            }
            case DiagonalCross: {
                return ShapeUtils.createDiagonalCross((float)(size / 2.5f), (float)(size / 7.5f));
            }
            case UpTriangle: {
                return ShapeUtils.createUpTriangle((float)(size / 2.0f));
            }
            case DownTriangle: {
                return ShapeUtils.createDownTriangle((float)(size / 2.0f));
            }
            case LeftTriangle: {
                GeneralPath p0 = new GeneralPath();
                p0.moveTo(-size / 2.0f, -size / 2.0f);
                p0.lineTo(size / 2.0f, 0.0f);
                p0.lineTo(-size / 2.0f, size / 2.0f);
                p0.closePath();
                return p0;
            }
            case RightTriangle: {
                GeneralPath p0 = new GeneralPath();
                p0.moveTo(size / 2.0f, -size / 2.0f);
                p0.lineTo(size / 2.0f, size / 2.0f);
                p0.lineTo(-size / 2.0f, 0.0f);
                p0.closePath();
                return p0;
            }
        }
        return null;
    }

    public javafx.scene.shape.Shape createFXShape(double size, Paint strokeColor, Paint fillColor) {
        switch (this) {
            case Circle: {
                Circle circle = new Circle(size / 2.0, fillColor);
                circle.setStroke(strokeColor);
                return circle;
            }
            case Rectangle: {
                Rectangle rect = new Rectangle(size, size, fillColor);
                rect.setStroke(strokeColor);
                return rect;
            }
            case Diamod: {
                Polygon polygon = new Polygon();
                polygon.getPoints().addAll((Object[])new Double[]{size / 2.0, 0.0, size, size / 2.0, size / 2.0, size, 0.0, size / 2.0});
                polygon.setFill(fillColor);
                polygon.setStroke(strokeColor);
                return polygon;
            }
            case RegularCross: {
                Polygon polygon = new Polygon();
                polygon.getPoints().addAll((Object[])new Double[]{size * 2.0 / 6.0, 0.0, size * 4.0 / 6.0, 0.0, size * 4.0 / 6.0, size * 2.0 / 6.0, size, size * 2.0 / 6.0, size, size * 4.0 / 6.0, size * 4.0 / 6.0, size * 4.0 / 6.0, size * 4.0 / 6.0, size, size * 2.0 / 6.0, size, size * 2.0 / 6.0, size * 4.0 / 6.0, 0.0, size * 4.0 / 6.0, 0.0, size * 2.0 / 6.0, size * 2.0 / 6.0, size * 2.0 / 6.0});
                polygon.setFill(fillColor);
                polygon.setStroke(strokeColor);
                return polygon;
            }
            case DiagonalCross: {
                javafx.scene.shape.Shape shape = RegularCross.createFXShape(size / 1.1, strokeColor, fillColor);
                shape.setRotate(45.0);
                return shape;
            }
            case UpTriangle: {
                Polygon polygon = new Polygon();
                polygon.getPoints().addAll((Object[])new Double[]{size / 2.0, 0.0, size, size, 0.0, size});
                polygon.setFill(fillColor);
                polygon.setStroke(strokeColor);
                return polygon;
            }
            case DownTriangle: {
                Polygon polygon = new Polygon();
                polygon.getPoints().addAll((Object[])new Double[]{0.0, 0.0, size, 0.0, size / 2.0, size});
                polygon.setFill(fillColor);
                polygon.setStroke(strokeColor);
                return polygon;
            }
            case LeftTriangle: {
                Polygon polygon = new Polygon();
                polygon.getPoints().addAll((Object[])new Double[]{0.0, 0.0, size, size / 2.0, 0.0, size});
                polygon.setFill(fillColor);
                polygon.setStroke(strokeColor);
                return polygon;
            }
            case RightTriangle: {
                Polygon polygon = new Polygon();
                polygon.getPoints().addAll((Object[])new Double[]{size, 0.0, size, size, 0.0, size / 2.0});
                polygon.setFill(fillColor);
                polygon.setStroke(strokeColor);
                return polygon;
            }
        }
        return null;
    }

    public Node getGraphic() {
        return this.createFXShape(10.0, (Paint)Color.BLACK, (Paint)Color.GRAY);
    }
}

