/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.charts;

import de.elpro.ewms.core.charts.DurationCurveType;
import de.elpro.ewms.core.charts.IVarSeries;
import de.elpro.ewms.core.charts.LineType;
import de.elpro.ewms.core.charts.SeriesGroup;
import de.elpro.ewms.core.charts.ShapeType;
import de.elpro.ewms.core.charts.VarSeriesPointLabelGenerator;
import de.elpro.ewms.core.charts.YAxis;
import de.elpro.ewms.core.charts.viewprefs.Series2DViewPrefs;
import de.elpro.ewms.core.structure.SearchPolicy;
import de.elpro.ewms.core.units.MeasuringUnitFormat;
import de.elpro.ewms.core.variable.Variable;
import de.elpro.ewms.core.variable.VariableInstance;
import de.elpro.resources.Resources;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleText;
import de.elpro.ui.utils.TextUtils;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Shape;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ewms_charts_series")
@Access(value=AccessType.PROPERTY)
public class VarSeries2D
implements UIModelElement,
IVarSeries {
    public static final String DAO_NAMESPACE = "charts/chart2d/var_series";
    public static final URL DEFAULT_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/charts/series.png");
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final ObjectProperty<YAxis> yAxis = new SimpleObjectProperty();
    private final ObjectProperty<SeriesGroup> seriesGroup = new SimpleObjectProperty();
    private final StringProperty title = new SimpleStringProperty();
    private final ObjectProperty<Variable> variable = new SimpleObjectProperty();
    private final ObjectProperty<VariableInstance> variableInstance = new SimpleObjectProperty();
    private final BooleanProperty durationCurve = new SimpleBooleanProperty();
    private final ObjectProperty<DurationCurveType> durationCurveType = new SimpleObjectProperty((Object)DurationCurveType.Increment);
    private final ObjectProperty<SearchPolicy> searchPolicy = new SimpleObjectProperty((Object)SearchPolicy.Auto);
    private final ObjectProperty<LineType> lineType = new SimpleObjectProperty((Object)LineType.Solid);
    private final ObjectProperty<Integer> lineWidth = new SimpleObjectProperty();
    private final ObjectProperty<Color> defaultColor = new SimpleObjectProperty();
    private final ObjectProperty<ShapeType> shapeType = new SimpleObjectProperty((Object)ShapeType.None);
    private final ObjectProperty<Integer> shapeSize = new SimpleObjectProperty();
    private final BooleanProperty showValuesBounds = new SimpleBooleanProperty();
    private final BooleanProperty showValuesLabels = new SimpleBooleanProperty();
    private final ObjectProperty<MeasuringUnitFormat> valueMeasuringUnitFormat = new SimpleObjectProperty();
    private final BooleanProperty isVisible = new SimpleBooleanProperty(true);
    private final ObjectProperty<Integer> visualOrderPosition = new SimpleObjectProperty();
    private final BooleanProperty customData = new SimpleBooleanProperty();
    private List<Series2DViewPrefs> seriesViewPrefs = new LinkedList<Series2DViewPrefs>();
    private VarSeriesPointLabelGenerator customItemLabelGenerator;

    public VarSeries2D() {
    }

    public VarSeries2D(int id) {
        this();
        this.setId(id);
    }

    public VarSeries2D(String title, SeriesGroup group) {
        this.setTitle(title);
        this.setSeriesGroup(group);
    }

    public VarSeries2D(String title, Variable variable, Color color) {
        this(title, variable, color, LineType.Solid, null);
    }

    public VarSeries2D(String title, Variable variable, Color color, Integer lineWidth) {
        this(title, variable, color, LineType.Solid, lineWidth);
    }

    public VarSeries2D(String title, Variable variable, Color color, LineType lineType, Integer lineWidth) {
        this.setTitle(title);
        this.setVariable(variable);
        this.setDefaultColor(color);
        this.setLineType(lineType);
        this.setLineWidth(lineWidth);
    }

    public VarSeries2D(String title, boolean isCustomData, Color color) {
        this(title, isCustomData, color, LineType.Solid, null);
    }

    public VarSeries2D(String title, boolean isCustomData, Color color, Integer lineWidth) {
        this(title, isCustomData, color, LineType.Solid, lineWidth);
    }

    public VarSeries2D(String title, boolean isCustomData, Color color, LineType lineType, Integer lineWidth) {
        this.setTitle(title);
        this.setCustomData(isCustomData);
        this.setDefaultColor(color);
        this.setLineType(lineType);
        this.setLineWidth(lineWidth);
    }

    public VarSeries2D(String title, boolean isCustomData, Color color, LineType lineType, Integer lineWidth, ShapeType shapeType, Integer shapeSize) {
        this(title, isCustomData, color, lineType, lineWidth);
        this.setShapeType(shapeType);
        this.setShapeSize(shapeSize);
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_charts_series_sequence")
    @SequenceGenerator(name="ewms_charts_series_sequence", sequenceName="ewms_charts_series_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    protected void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @ManyToOne
    @JoinColumn(name="y_axis", nullable=false)
    public YAxis getYAxis() {
        return (YAxis)this.yAxis.get();
    }

    public void setYAxis(YAxis yAxis) {
        this.yAxis.set((Object)yAxis);
    }

    public final ObjectProperty<YAxis> yAxisProperty() {
        return this.yAxis;
    }

    @ManyToOne
    @JoinColumn(name="series_group", nullable=true)
    public SeriesGroup getSeriesGroup() {
        return (SeriesGroup)this.seriesGroup.get();
    }

    public void setSeriesGroup(SeriesGroup group) {
        this.seriesGroup.set((Object)group);
    }

    public final ObjectProperty<SeriesGroup> groupProperty() {
        return this.seriesGroup;
    }

    @Column(name="title", columnDefinition="TEXT")
    public String getTitle() {
        return (String)this.title.get();
    }

    @Transient
    public final String getLocalTitle() {
        return LocaleText.tryParse((String)this.getTitle()).getTextOrDefault();
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public final StringProperty titleProperty() {
        return this.title;
    }

    @Transient
    public final String getResultTitle() {
        String title = this.getLocalTitle();
        if (title != null && !title.isEmpty()) {
            return title;
        }
        if (this.getVariable() != null) {
            if (this.getVariable().getDescription() != null && !this.getVariable().getDescription().isEmpty()) {
                return TextUtils.getFirstLine((String)this.getVariable().getDescription(), (int)50);
            }
            return this.getVariable().toString();
        }
        return null;
    }

    @ManyToOne
    @JoinColumn(name="variable", nullable=false)
    public Variable getVariable() {
        return (Variable)this.variable.get();
    }

    public void setVariable(Variable variable) {
        this.variable.set((Object)variable);
    }

    public final ObjectProperty<Variable> variableProperty() {
        return this.variable;
    }

    @ManyToOne
    @JoinColumn(name="variable_instance", nullable=true)
    public VariableInstance getVariableInstance() {
        return (VariableInstance)((Object)this.variableInstance.get());
    }

    public void setVariableInstance(VariableInstance variableInstance) {
        this.variableInstance.set((Object)variableInstance);
    }

    public final ObjectProperty<VariableInstance> variableInstanceProperty() {
        return this.variableInstance;
    }

    @Column(name="duration_curve", nullable=false, columnDefinition="BOOLEAN DEFAULT FALSE")
    public boolean isDurationCurve() {
        return this.durationCurve.get();
    }

    public void setDurationCurve(boolean durationCurve) {
        this.durationCurve.set(durationCurve);
    }

    public final BooleanProperty durationCurveProperty() {
        return this.durationCurve;
    }

    @Column(name="duration_curve_type", nullable=false, columnDefinition="INTEGER DEFAULT 0")
    public DurationCurveType getDurationCurveType() {
        return (DurationCurveType)((Object)this.durationCurveType.get());
    }

    public void setDurationCurveType(DurationCurveType durationCurveType) {
        this.durationCurveType.set((Object)durationCurveType);
    }

    public final ObjectProperty<DurationCurveType> durationCurveTypeProperty() {
        return this.durationCurveType;
    }

    @Column(name="search_policy")
    public SearchPolicy getSearchPolicy() {
        return (SearchPolicy)((Object)this.searchPolicy.get());
    }

    public void setSearchPolicy(SearchPolicy searchPolicy) {
        this.searchPolicy.set((Object)searchPolicy);
    }

    public final ObjectProperty<SearchPolicy> searchPolicyProperty() {
        return this.searchPolicy;
    }

    @Column(name="lineType", nullable=false)
    public LineType getLineType() {
        return (LineType)((Object)this.lineType.get());
    }

    public void setLineType(LineType lineType) {
        this.lineType.set((Object)lineType);
    }

    public final ObjectProperty<LineType> lineTypeProperty() {
        return this.lineType;
    }

    @Column(name="line_width")
    public Integer getLineWidth() {
        return (Integer)this.lineWidth.get();
    }

    public void setLineWidth(Integer lineWidth) {
        this.lineWidth.set((Object)lineWidth);
    }

    public final ObjectProperty<Integer> lineWidthProperty() {
        return this.lineWidth;
    }

    @Override
    @Column(name="default_color")
    public Color getDefaultColor() {
        return (Color)this.defaultColor.get();
    }

    public void setDefaultColor(Color color) {
        this.defaultColor.set((Object)color);
    }

    public final ObjectProperty<Color> defaultColorProperty() {
        return this.defaultColor;
    }

    @Column(name="shape_type", nullable=false)
    public ShapeType getShapeType() {
        return (ShapeType)((Object)this.shapeType.get());
    }

    public void setShapeType(ShapeType shapeType) {
        this.shapeType.set((Object)shapeType);
    }

    public final ObjectProperty<ShapeType> shapeTypeProperty() {
        return this.shapeType;
    }

    @Column(name="shape_size")
    public Integer getShapeSize() {
        return (Integer)this.shapeSize.get();
    }

    public void setShapeSize(Integer shapeSize) {
        this.shapeSize.set((Object)shapeSize);
    }

    public final ObjectProperty<Integer> shapeSizeProperty() {
        return this.shapeSize;
    }

    @Column(name="show_values_bounds", nullable=false, columnDefinition="BOOLEAN DEFAULT FALSE")
    public boolean isShowValuesBounds() {
        return this.showValuesBounds.get();
    }

    public void setShowValuesBounds(boolean showValuesBounds) {
        this.showValuesBounds.set(showValuesBounds);
    }

    public final BooleanProperty showValuesBoundsProperty() {
        return this.showValuesBounds;
    }

    @Column(name="show_values_labels", nullable=false, columnDefinition="BOOLEAN DEFAULT FALSE")
    public boolean isShowValuesLabels() {
        return this.showValuesLabels.get();
    }

    public void setShowValuesLabels(boolean showValuesLabels) {
        this.showValuesLabels.set(showValuesLabels);
    }

    public final BooleanProperty showValuesLabelsProperty() {
        return this.showValuesLabels;
    }

    @Column(name="value_measuring_unit_format_id")
    public MeasuringUnitFormat getValueMeasuringUnitFormat() {
        return (MeasuringUnitFormat)this.valueMeasuringUnitFormat.get();
    }

    public void setValueMeasuringUnitFormat(MeasuringUnitFormat measuringUnitFormat) {
        this.valueMeasuringUnitFormat.set((Object)measuringUnitFormat);
    }

    public final ObjectProperty<MeasuringUnitFormat> valueMeasuringUnitFormatProperty() {
        return this.valueMeasuringUnitFormat;
    }

    @Column(name="is_visible", nullable=false, columnDefinition="BOOLEAN DEFAULT TRUE")
    public boolean isVisible() {
        return this.isVisible.get();
    }

    public void setVisible(boolean isVisible) {
        this.isVisible.set(isVisible);
    }

    @Transient
    public final BooleanProperty isVisibleProperty() {
        return this.isVisible;
    }

    @Column(name="visual_order_position")
    public Integer getVisualOrderPosition() {
        return (Integer)this.visualOrderPosition.get();
    }

    public void setVisualOrderPosition(Integer visualOrderPosition) {
        this.visualOrderPosition.set((Object)visualOrderPosition);
    }

    public final ObjectProperty<Integer> visualOrderPositionProperty() {
        return this.visualOrderPosition;
    }

    @Transient
    public final boolean isCustomData() {
        return this.customData.get();
    }

    public void setCustomData(boolean isCustomData) {
        this.customData.set(isCustomData);
    }

    @Transient
    public final VarSeriesPointLabelGenerator getCustomItemLabelGenerator() {
        return this.customItemLabelGenerator;
    }

    public void setCustomItemLabelGenerator(VarSeriesPointLabelGenerator customItemLabelGenerator) {
        this.customItemLabelGenerator = customItemLabelGenerator;
    }

    @OneToMany(mappedBy="series", cascade={CascadeType.REMOVE})
    public List<Series2DViewPrefs> getSeriesViewPrefs() {
        return this.seriesViewPrefs;
    }

    protected void setSeriesViewPrefs(List<Series2DViewPrefs> seriesViewPrefs) {
        this.seriesViewPrefs = seriesViewPrefs;
    }

    public String toString() {
        return this.getResultTitle();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof VarSeries2D) {
            if (this.getId() == null) {
                return super.equals(obj);
            }
            if (this.getId().equals(((VarSeries2D)obj).getId())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return VarSeries2D.class.hashCode() + 17 * (Integer)this.id.get();
    }

    public static Node createGraphic(Color color, LineType lineType, ShapeType shapeType) {
        Shape shape;
        if (color == null) {
            color = Color.BLACK;
        }
        Line line = lineType != null ? lineType.createFXStroke(16.0, 1.0, (Paint)color) : null;
        Shape shape2 = shape = shapeType != null ? shapeType.createFXShape(8.0, (Paint)color, (Paint)color) : null;
        if (line != null || shape != null) {
            Group group = new Group();
            if (line != null) {
                group.getChildren().add((Object)line);
            }
            if (shape != null) {
                BorderPane bp = new BorderPane((Node)shape);
                bp.setPrefWidth(16.0);
                bp.setPrefHeight(16.0);
                group.getChildren().add((Object)bp);
            }
            return group;
        }
        return null;
    }

    @Transient
    public Node getGraphic() {
        Node styledGraphik = VarSeries2D.createGraphic(this.getDefaultColor(), this.getLineType(), this.getShapeType());
        return styledGraphik != null ? styledGraphik : new ImageView(DEFAULT_ICON.toString());
    }
}

