/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.charts;

import de.elpro.ewms.core.charts.Chart2D;
import de.elpro.ewms.core.charts.RendererType;
import de.elpro.ewms.core.charts.SeriesGroup;
import de.elpro.ewms.core.charts.VarSeries2D;
import de.elpro.ewms.core.charts.YAxisLocation;
import de.elpro.ewms.core.charts.viewprefs.AxisViewPrefs;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ewms.core.units.PhysicalUnit;
import de.elpro.resources.Resources;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import de.elpro.ui.text.LocaleText;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.paint.Color;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ewms_charts_yaxis")
@Access(value=AccessType.PROPERTY)
public class YAxis
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "charts/chart2d/yaxis";
    public static final URL DEFAULT_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"ewms/charts/axis-three.png");
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final ObjectProperty<Chart2D> chart = new SimpleObjectProperty();
    private final ObjectProperty<RendererType> defaultRendererType = new SimpleObjectProperty((Object)RendererType.Line);
    private final StringProperty title = new SimpleStringProperty();
    private final ObjectProperty<PhysicalUnit> physicalUnit = new SimpleObjectProperty();
    private final ObjectProperty<MeasuringUnit> defaultMeasuringUnit = new SimpleObjectProperty();
    private final ObjectProperty<YAxisLocation> axisLocation = new SimpleObjectProperty((Object)YAxisLocation.Left);
    private final ObjectProperty<Color> color = new SimpleObjectProperty();
    private final ObjectProperty<Integer> visualOrderPosition = new SimpleObjectProperty();
    private List<SeriesGroup> seriesGroups = new LinkedList<SeriesGroup>();
    private List<VarSeries2D> series = new LinkedList<VarSeries2D>();
    private List<AxisViewPrefs> axesViewPrefs = new LinkedList<AxisViewPrefs>();

    public YAxis() {
    }

    public YAxis(int id) {
        this();
        this.setId(id);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_charts_yaxis_sequence")
    @SequenceGenerator(name="ewms_charts_yaxis_sequence", sequenceName="ewms_charts_yaxis_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    protected void setId(int id) {
        this.id.set((Object)id);
    }

    public final ObjectProperty<Integer> idProperty() {
        return this.id;
    }

    @ManyToOne
    @JoinColumn(name="chart", nullable=false)
    public Chart2D getChart() {
        return (Chart2D)this.chart.get();
    }

    public void setChart(Chart2D chart) {
        this.chart.set((Object)chart);
    }

    public final ObjectProperty<Chart2D> chartProperty() {
        return this.chart;
    }

    @Column(name="default_renderer_type", nullable=false)
    public RendererType getDefaultRendererType() {
        return (RendererType)((Object)this.defaultRendererType.get());
    }

    public void setDefaultRendererType(RendererType rendererType) {
        this.defaultRendererType.set((Object)rendererType);
    }

    public final ObjectProperty<RendererType> defaultRendererTypeProperty() {
        return this.defaultRendererType;
    }

    @Column(name="title", nullable=false, columnDefinition="TEXT")
    public String getTitle() {
        return (String)this.title.get();
    }

    @Transient
    public final String getLocalTitle() {
        return LocaleText.tryParse((String)this.getTitle()).getTextOrDefault();
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public final StringProperty titleProperty() {
        return this.title;
    }

    @Column(name="physical_unit_id", nullable=false)
    public PhysicalUnit getPhysicalUnit() {
        return (PhysicalUnit)this.physicalUnit.get();
    }

    public void setPhysicalUnit(PhysicalUnit physicalUnit) {
        this.physicalUnit.set((Object)physicalUnit);
    }

    public final ObjectProperty<PhysicalUnit> physicalUnitProperty() {
        return this.physicalUnit;
    }

    @Column(name="default_measuring_unit_id")
    public MeasuringUnit getDefaultMeasuringUnit() {
        return (MeasuringUnit)this.defaultMeasuringUnit.get();
    }

    public void setDefaultMeasuringUnit(MeasuringUnit measuringUnit) {
        this.defaultMeasuringUnit.set((Object)measuringUnit);
    }

    public final ObjectProperty<MeasuringUnit> defaultMeasuringUnitProperty() {
        return this.defaultMeasuringUnit;
    }

    @Column(name="axis_location", nullable=false, columnDefinition="INTEGER DEFAULT 0")
    public YAxisLocation getAxisLocation() {
        return (YAxisLocation)((Object)this.axisLocation.get());
    }

    public void setAxisLocation(YAxisLocation location) {
        this.axisLocation.set((Object)location);
    }

    public final ObjectProperty<YAxisLocation> axisLocationProperty() {
        return this.axisLocation;
    }

    @Column(name="color")
    public Color getColor() {
        return (Color)this.color.get();
    }

    public void setColor(Color color) {
        this.color.set((Object)color);
    }

    public final ObjectProperty<Color> colorProperty() {
        return this.color;
    }

    @Column(name="visual_order_position")
    public Integer getVisualOrderPosition() {
        return (Integer)this.visualOrderPosition.get();
    }

    public void setVisualOrderPosition(Integer visualOrderPosition) {
        this.visualOrderPosition.set((Object)visualOrderPosition);
    }

    public final ObjectProperty<Integer> visualOrderPositionProperty() {
        return this.visualOrderPosition;
    }

    @OneToMany(mappedBy="YAxis", cascade={CascadeType.REMOVE})
    public List<SeriesGroup> getSeriesGroups() {
        return this.seriesGroups;
    }

    protected void setSeriesGroups(List<SeriesGroup> seriesGroups) {
        this.seriesGroups = seriesGroups;
    }

    @OneToMany(mappedBy="YAxis", cascade={CascadeType.REMOVE})
    public List<VarSeries2D> getSeries() {
        return this.series;
    }

    protected void setSeries(List<VarSeries2D> series) {
        this.series = series;
    }

    @OneToMany(mappedBy="YAxis", cascade={CascadeType.REMOVE})
    public List<AxisViewPrefs> getAxesViewPrefs() {
        return this.axesViewPrefs;
    }

    protected void setAxesViewPrefs(List<AxisViewPrefs> axesViewPrefs) {
        this.axesViewPrefs = axesViewPrefs;
    }

    public String toString() {
        return this.getLocalTitle();
    }

    public boolean equals(Object obj) {
        if (obj instanceof YAxis) {
            if (this.getId() == null) {
                return super.equals(obj);
            }
            if (this.getId().equals(((YAxis)obj).getId())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.getId() == null) {
            return super.hashCode();
        }
        return YAxis.class.hashCode() + 17 * (Integer)this.id.get();
    }

    @Transient
    public String getIconUri() {
        return DEFAULT_ICON.toString();
    }
}

