/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.charts.viewprefs;

import de.elpro.ewms.core.charts.YAxis;
import de.elpro.ewms.core.charts.viewprefs.Chart2DViewPrefs;
import de.elpro.ewms.core.units.DisplayUnitFormat;
import de.elpro.ewms.core.units.MeasuringUnit;
import de.elpro.ui.model.IdObject;
import de.elpro.ui.model.UIModelElement;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="ewms_charts_viewprefs_axis")
@Access(value=AccessType.PROPERTY)
public class AxisViewPrefs
implements UIModelElement,
IdObject {
    public static final String DAO_NAMESPACE = "axis_view_prefs";
    private final ObjectProperty<Integer> id = new SimpleObjectProperty();
    private final ObjectProperty<Chart2DViewPrefs> chartViewPrefs = new SimpleObjectProperty();
    private final ObjectProperty<YAxis> yAxis = new SimpleObjectProperty();
    private final ObjectProperty<MeasuringUnit> measuringUnit = new SimpleObjectProperty();
    private final BooleanProperty isAbsolute = new SimpleBooleanProperty(false);
    private final ObjectProperty<Double> lowerRange = new SimpleObjectProperty();
    private final ObjectProperty<Double> upperRange = new SimpleObjectProperty();

    public AxisViewPrefs() {
    }

    public AxisViewPrefs(int id) {
        this();
        this.setId(id);
    }

    public AxisViewPrefs(Chart2DViewPrefs chartViewPrefs, MeasuringUnit measuringUnit) {
        this();
        this.setChartViewPrefs(chartViewPrefs);
        this.setMeasuringUnit(measuringUnit);
    }

    public AxisViewPrefs(Chart2DViewPrefs chartViewPrefs, YAxis yAxis, MeasuringUnit measuringUnit) {
        this();
        this.setChartViewPrefs(chartViewPrefs);
        this.setYAxis(yAxis);
        this.setMeasuringUnit(measuringUnit);
    }

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ewms_charts_viewprefs_axis_sequence")
    @SequenceGenerator(name="ewms_charts_viewprefs_axis_sequence", sequenceName="ewms_charts_viewprefs_axis_sequence")
    public Integer getId() {
        return (Integer)this.id.get();
    }

    public void setId(int id) {
        this.id.set((Object)id);
    }

    @ManyToOne
    @JoinColumn(name="chart_view_prefs", nullable=false)
    public Chart2DViewPrefs getChartViewPrefs() {
        return (Chart2DViewPrefs)this.chartViewPrefs.get();
    }

    public void setChartViewPrefs(Chart2DViewPrefs prefs) {
        this.chartViewPrefs.set((Object)prefs);
    }

    @Transient
    public final String getLocalTitle() {
        if (this.getYAxis() != null) {
            return this.getYAxis().getLocalTitle();
        }
        return this.getChartViewPrefs().getChart().getLocalXAxisTitle();
    }

    @Transient
    public final String getFullTitle() {
        String axisTitle = this.getLocalTitle();
        if (axisTitle == null || axisTitle.isEmpty()) {
            return String.format("[%s]", this.getMeasuringUnit().getDisplayUnitText(DisplayUnitFormat.SIMPLE));
        }
        return String.format("%s [%s]", axisTitle, this.getMeasuringUnit().getDisplayUnitText(DisplayUnitFormat.SIMPLE));
    }

    @ManyToOne
    @JoinColumn(name="axis_definition", nullable=true)
    public YAxis getYAxis() {
        return (YAxis)this.yAxis.get();
    }

    public void setYAxis(YAxis yAxis) {
        this.yAxis.set((Object)yAxis);
    }

    @Column(name="measuring_unit_id", nullable=false)
    public MeasuringUnit getMeasuringUnit() {
        return (MeasuringUnit)this.measuringUnit.get();
    }

    public void setMeasuringUnit(MeasuringUnit measuringUnit) {
        this.measuringUnit.set((Object)measuringUnit);
    }

    public final ObjectProperty<MeasuringUnit> measuringUnitProperty() {
        return this.measuringUnit;
    }

    @Column(name="is_absolute", nullable=false)
    public boolean isAbsolute() {
        return this.isAbsolute.get();
    }

    public void setAbsolute(boolean isAbsolute) {
        this.isAbsolute.set(isAbsolute);
    }

    @Transient
    public final BooleanProperty isAbsoluteProperty() {
        return this.isAbsolute;
    }

    @Column(name="lower_range")
    public Double getLowerRange() {
        return (Double)this.lowerRange.get();
    }

    public void setLowerRange(Double lowerRange) {
        this.lowerRange.set((Object)lowerRange);
    }

    public final ObjectProperty<Double> lowerRangeProperty() {
        return this.lowerRange;
    }

    @Column(name="upper_range")
    public Double getUpperRange() {
        return (Double)this.upperRange.get();
    }

    public void setUpperRange(Double upperRange) {
        this.upperRange.set((Object)upperRange);
    }

    public final ObjectProperty<Double> upperRangeProperty() {
        return this.upperRange;
    }

    public String toString() {
        return this.getLocalTitle();
    }

    @Transient
    public Node getGraphic() {
        Label l = new Label();
        if (this.getYAxis() != null) {
            l.setText("Y");
            l.setStyle("-fx-font-weight: bold; -fx-text-fill: cornflowerblue;");
        } else {
            l.setText("X");
            l.setStyle("-fx-font-weight: bold; -fx-text-fill: chocolate;");
        }
        l.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
        return l;
    }

    public AxisViewPrefs clone(Chart2DViewPrefs prefs) {
        AxisViewPrefs clone = new AxisViewPrefs();
        clone.setChartViewPrefs(prefs);
        clone.setYAxis(this.getYAxis());
        clone.setMeasuringUnit(this.getMeasuringUnit());
        clone.setAbsolute(this.isAbsolute());
        clone.setLowerRange(this.getLowerRange());
        clone.setUpperRange(this.getUpperRange());
        return clone;
    }
}

