/*
 * Decompiled with CFR 0.152.
 */
package de.elpro.ewms.core.component;

import de.elpro.ewms.core.component.VersionUtils;
import de.elpro.resources.Resources;
import de.elpro.ui.model.UIModelElement;
import java.net.URL;
import org.osgi.framework.Version;

public class ComponentDependency
implements UIModelElement {
    public static final URL DEFAULT_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"eclipse/frgmt_obj.png");
    public static final URL MISSING_ICON = Resources.getResourceUrl((String)"/icons/16x16/", (String)"eclipse/frgmt_dis_obj.png");
    private final String id;
    private final Version minVersion;
    private final Version maxVersion;
    private final boolean includeMaxVersion;

    public ComponentDependency(String id, Version exactVersion) {
        this.id = id;
        this.minVersion = exactVersion;
        this.maxVersion = exactVersion;
        this.includeMaxVersion = true;
    }

    public ComponentDependency(String id, Version minVersion, Version maxVersion) {
        this.id = id;
        this.minVersion = minVersion;
        this.maxVersion = maxVersion;
        this.includeMaxVersion = false;
    }

    public ComponentDependency(String id, Version minVersion, Version maxVersion, boolean includeMaxVersion) {
        this.id = id;
        this.minVersion = minVersion;
        this.maxVersion = maxVersion;
        this.includeMaxVersion = includeMaxVersion;
    }

    public String getId() {
        return this.id;
    }

    public Version getMinVersion() {
        return this.minVersion;
    }

    public Version getMaxVersion() {
        return this.maxVersion;
    }

    public boolean isIncludeMaxVersion() {
        return this.includeMaxVersion;
    }

    public boolean matchNoQualifier(Version version) {
        version = VersionUtils.noQualifier(version);
        Version minVersion = VersionUtils.noQualifier(this.minVersion);
        Version maxVersion = VersionUtils.noQualifier(this.maxVersion);
        if (minVersion.compareTo(version) > 0) {
            return false;
        }
        return !(this.includeMaxVersion ? maxVersion.compareTo(version) < 0 : maxVersion.compareTo(version) <= 0);
    }

    public String getIconUri() {
        return DEFAULT_ICON.toString();
    }
}

